/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.loader.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.apiquery.DataGraphParser;
import com.mulesoft.apiquery.ServiceSource;
import com.mulesoft.apiquery.ServiceSourceBuilder;
import com.mulesoft.apiquery.ServiceSources;
import com.mulesoft.apiquery.adapter.internal.ApiQueryAdapterConfiguration;
import com.mulesoft.apiquery.adapter.internal.EngineData;
import com.mulesoft.apiquery.adapter.internal.MemoryPressureChecker;
import com.mulesoft.apiquery.adapter.internal.http.MuleHttpClient;
import com.mulesoft.apiquery.adapter.internal.http.ThrottlingFactory;
import com.mulesoft.apiquery.adapter.internal.loader.DataGraphElementLoader;
import com.mulesoft.apiquery.adapter.internal.loader.GatewayPropertiesLoader;
import com.mulesoft.apiquery.adapter.internal.metric.MetricsReporter;
import com.mulesoft.apiquery.adapter.internal.utils.URLExtractorUtils;
import com.mulesoft.apiquery.core.datagraph.ModelService;
import com.mulesoft.apiquery.core.datagraph.model.DataGraph;
import com.mulesoft.apiquery.http.HTTPProtocolClient;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.core.api.util.Base64;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.immutable.List;
import scala.concurrent.Future;

public class JsonArrayDataGraphElementLoader
implements DataGraphElementLoader {
    private final ApiQueryAdapterConfiguration apiQueryAdapterConfiguration;
    private HTTPProtocolClient client;
    private HTTPProtocolClient clientWithKeystore;
    private HTTPProtocolClient clientWithTruststore;
    private HttpClient defaultClient;
    private final HttpService httpService;
    private Optional<KeyStore> keystore = Optional.empty();
    private Optional<String> keystoreAbsolutePath = Optional.empty();
    private final GatewayPropertiesLoader loader;
    private final MetricsReporter metricsReporter;
    private ModelService modelService = null;
    private Optional<KeyStore> truststore = Optional.empty();
    private Optional<String> truststoreAbsolutePath = Optional.empty();
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonArrayDataGraphElementLoader.class);
    private static final String JSON_SOURCE_ID_KEY = "sourceId";
    private static final String JSON_SOURCE_NAME_KEY = "sourceName";
    private static final String JSON_SOURCE_GRPC_METADATA = "sourceGrpcMetadata";
    private static final String JSON_ANG_ID_KEY = "id";
    private static final String JSON_SOURCE_CONTENT_KEY = "content";
    private static final String JSON_SOURCE_BASE_URI_KEY = "baseUri";
    private static final String JSON_SOURCE_REFS_KEY = "sourceRefs";

    public JsonArrayDataGraphElementLoader(ApiQueryAdapterConfiguration apiQueryAdapterConfiguration, GatewayPropertiesLoader loader, MetricsReporter metricsReporter, HttpService httpService, HttpClient defaultClient) {
        this.apiQueryAdapterConfiguration = apiQueryAdapterConfiguration;
        this.loader = loader;
        this.metricsReporter = metricsReporter;
        this.httpService = httpService;
        this.defaultClient = defaultClient;
    }

    @Override
    public java.util.List<EngineData> loadProperties() {
        ArrayList<EngineData> result;
        block6: {
            result = new ArrayList<EngineData>();
            try {
                LOGGER.debug("About to load json properties");
                String rawSources = this.loader.rebuildDataGraph();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = objectMapper.readTree(rawSources);
                if (jsonNode.isArray()) {
                    for (JsonNode arrayItem : jsonNode) {
                        String angUrl = arrayItem.get(JSON_ANG_ID_KEY).asText();
                        String content = arrayItem.get(JSON_SOURCE_CONTENT_KEY).toString();
                        if (this.modelService == null) {
                            this.initializeModelService(angUrl);
                        }
                        Future futureDataGraph = DataGraphParser.parse((ModelService)this.modelService, (String)content);
                        ServiceSources serviceSources = this.buildServiceSources(arrayItem.get(JSON_SOURCE_REFS_KEY));
                        result.add(new EngineData((Future<DataGraph>)futureDataGraph, serviceSources));
                    }
                    break block6;
                }
                LOGGER.error("Properties have not json array shape");
                throw new IllegalStateException("Properties have not json array shape");
            }
            catch (IllegalStateException e) {
                LOGGER.error("Illegal State error: {}", (Object)e.getMessage());
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Unknown error: {}", (Object)e.getMessage());
                throw new IllegalStateException("Could not parse json sources: " + e.getMessage());
            }
        }
        return result;
    }

    @Override
    public HttpClient getDefaultClient() {
        return this.defaultClient;
    }

    @Override
    public HttpClientConfiguration getHttpClientConfiguration(boolean withTruststore, boolean withKeystore) throws IOException, CreateException {
        HttpClientConfiguration.Builder httpClientConfiguration = new HttpClientConfiguration.Builder().setName("ApiFederation").setUsePersistentConnections(this.apiQueryAdapterConfiguration.isUsePersistentConnections()).setMaxConnections(this.apiQueryAdapterConfiguration.getMaxConnections()).setConnectionIdleTimeout(this.apiQueryAdapterConfiguration.getConnectionIdleTimeout()).setResponseBufferSize(this.apiQueryAdapterConfiguration.getResponseBufferSize()).setClientSocketProperties(TcpClientSocketProperties.builder().clientTimeout(Integer.valueOf(this.apiQueryAdapterConfiguration.getClientTimeout())).connectionTimeout(Integer.valueOf(this.apiQueryAdapterConfiguration.getConnectionTimeout())).build());
        if (withTruststore || withKeystore) {
            TlsContextFactoryBuilder tlsContextFactoryBuilder = TlsContextFactory.builder();
            if (withTruststore && this.truststoreAbsolutePath.isPresent()) {
                tlsContextFactoryBuilder.trustStoreType((String)this.loader.getTrustStoreType().orElse(null)).trustStorePassword((String)this.loader.getTrustStorePassword().orElse(null)).trustStorePath(this.truststoreAbsolutePath.get());
            }
            if (withKeystore && this.keystoreAbsolutePath.isPresent()) {
                tlsContextFactoryBuilder.keyStoreType((String)this.loader.getKeyStoreType().orElse(null)).keyStorePassword((String)this.loader.getKeyStorePassword().orElse(null)).keyPassword((String)this.loader.getKeyStorePassword().orElse(null)).keyStorePath(this.keystoreAbsolutePath.get());
            }
            httpClientConfiguration.setTlsContextFactory(tlsContextFactoryBuilder.build());
        }
        return httpClientConfiguration.build();
    }

    public ModelService getModelService() {
        return this.modelService;
    }

    private HTTPProtocolClient buildHttpProtocolClient(boolean withTruststore, boolean withKeystore) {
        MuleHttpClient muleHttpClient = null;
        try {
            HttpClient httpClient = this.getHttpClient(withTruststore, withKeystore);
            Supplier<Boolean> memCheckSupplier = () -> MemoryPressureChecker.allow(this.apiQueryAdapterConfiguration.getMemoryThreshold(), MemoryPressureChecker.getDefaultMemoryProvider());
            Supplier<Boolean> tautology = () -> true;
            HttpRequestOptions httpOptions = HttpRequestOptions.builder().responseTimeout(this.apiQueryAdapterConfiguration.getClientTimeout()).build();
            muleHttpClient = new MuleHttpClient(httpClient, this.metricsReporter, ThrottlingFactory.outboundRequestsThrottling(this.apiQueryAdapterConfiguration.getMaxConnections(), this.apiQueryAdapterConfiguration.isEnableMemoryCheck() ? memCheckSupplier : tautology), this.apiQueryAdapterConfiguration.getApifAppVersion(), httpOptions);
        }
        catch (IOException e) {
            LOGGER.error("Error building http client", (Throwable)e);
        }
        catch (CreateException e) {
            LOGGER.error("Error building http client", (Throwable)e);
        }
        return muleHttpClient;
    }

    private ServiceSources buildServiceSources(JsonNode sourceRefsNode) {
        ArrayList sourceList = new ArrayList();
        this.loadKeystoreAndTrustsore();
        sourceRefsNode.forEach(s -> {
            String sourceId = s.get(JSON_SOURCE_ID_KEY).asText();
            JsonNode sourceNameNode = s.get(JSON_SOURCE_NAME_KEY);
            JsonNode sourceGrpcNode = s.get(JSON_SOURCE_GRPC_METADATA);
            ServiceSource source = ServiceSourceBuilder.create((String)sourceId, (String)s.get(JSON_SOURCE_BASE_URI_KEY).asText(), this.loader.retrieveSecrets(s.get(JSON_SOURCE_ID_KEY).asText()), (HTTPProtocolClient)this.getHttpClientForSource(sourceId), (Option)Option.apply((Object)sourceNameNode).flatMap(a -> Option.apply((Object)a.asText())), (Option)Option.apply((Object)sourceGrpcNode).flatMap(a -> Option.apply((Object)new ByteArrayInputStream(Base64.decode((String)a.asText())))));
            LOGGER.info("SourceId: {} BaseUri: {}", (Object)source.sourceId(), (Object)source.getBaseUri());
            LOGGER.info("Secrets size: {}", (Object)source.getSecurityCredentials().size());
            sourceList.add(source);
        });
        return new ServiceSources(JavaConverters.asScalaBuffer(sourceList).toList());
    }

    private void initializeModelService(String urlPattern) {
        Optional<String> baseUri = URLExtractorUtils.extractBaseUriFromAng(urlPattern);
        if (!baseUri.isPresent()) {
            throw new IllegalStateException("Could not extract source base uri from ANG URL");
        }
        this.modelService = ModelService.apply((String)baseUri.get(), (List)List.empty());
    }

    private void loadKeystoreAndTrustsore() {
        this.loadTruststore();
        this.loadKeytore();
    }

    private void loadKeytore() {
        Optional<byte[]> keystoreBytes = this.loader.rebuildKeyStore();
        if (keystoreBytes.isPresent() && this.loader.getKeyStoreType().isPresent()) {
            try {
                Path keystorePath = Files.createTempFile("keystore", "_tmp", new FileAttribute[0]);
                Files.write(keystorePath, keystoreBytes.get(), new OpenOption[0]);
                this.keystoreAbsolutePath = Optional.of(keystorePath.toFile().getAbsolutePath());
                this.keystore = Optional.of(KeyStore.getInstance(this.loader.getKeyStoreType().get()));
                this.keystore.get().load(new ByteArrayInputStream(keystoreBytes.get()), this.loader.getKeyStorePassword().isPresent() ? this.loader.getKeyStorePassword().get().toCharArray() : null);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                LOGGER.error("Error reading keystore property", (Throwable)e);
            }
        }
    }

    private void loadTruststore() {
        Optional<byte[]> truststoreBytes = this.loader.rebuildTrustStore();
        if (truststoreBytes.isPresent() && this.loader.getTrustStoreType().isPresent()) {
            try {
                Path truststorePath = Files.createTempFile("truststore", "_tmp", new FileAttribute[0]);
                Files.write(truststorePath, truststoreBytes.get(), new OpenOption[0]);
                this.truststoreAbsolutePath = Optional.of(truststorePath.toFile().getAbsolutePath());
                this.truststore = Optional.of(KeyStore.getInstance(this.loader.getTrustStoreType().get()));
                this.truststore.get().load(new ByteArrayInputStream(truststoreBytes.get()), this.loader.getTrustStorePassword().isPresent() ? this.loader.getTrustStorePassword().get().toCharArray() : null);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                LOGGER.error("Error reading truststore property", (Throwable)e);
            }
        }
    }

    private synchronized HTTPProtocolClient getClient() {
        if (this.client == null) {
            this.client = this.buildHttpProtocolClient(false, false);
        }
        return this.client;
    }

    private synchronized HTTPProtocolClient getClientWithKeystore() {
        if (this.clientWithKeystore == null) {
            this.clientWithKeystore = this.buildHttpProtocolClient(false, true);
        }
        return this.clientWithKeystore;
    }

    private synchronized HTTPProtocolClient getClientWithTrustStore() {
        if (this.clientWithTruststore == null) {
            this.clientWithTruststore = this.buildHttpProtocolClient(true, true);
        }
        return this.clientWithTruststore;
    }

    private HttpClient getHttpClient(boolean withTruststore, boolean withKeystore) throws IOException, CreateException {
        if (!withTruststore && !withKeystore) {
            return this.defaultClient;
        }
        HttpClient httpClient = this.httpService.getClientFactory().create(this.getHttpClientConfiguration(withTruststore, withKeystore));
        httpClient.start();
        return httpClient;
    }

    private HTTPProtocolClient getHttpClientForSource(String sourceId) {
        try {
            if (this.truststore.isPresent() && this.truststore.get().containsAlias(sourceId)) {
                return this.getClientWithTrustStore();
            }
            if (this.keystore.isPresent() && this.keystore.get().containsAlias(sourceId)) {
                return this.getClientWithKeystore();
            }
        }
        catch (KeyStoreException e) {
            LOGGER.error("Error getting http client for source", (Throwable)e);
        }
        return this.getClient();
    }
}

