/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal;

import com.mulesoft.apiquery.GraphQLEngine;
import com.mulesoft.apiquery.JVMGraphQLEngine;
import com.mulesoft.apiquery.ServiceSources;
import com.mulesoft.apiquery.adapter.internal.EngineData;
import com.mulesoft.apiquery.adapter.internal.http.oauth.MuleHttpRequestExecutor;
import com.mulesoft.apiquery.adapter.internal.loader.DataGraphElementLoader;
import com.mulesoft.apiquery.graphql.GraphQLService;
import com.mulesoft.apiquery.graphql.RequestContext;
import com.mulesoft.apiquery.graphql.config.RuntimeConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.compat.java8.OptionConverters;

class GraphQLEngines {
    private final List<GraphQLEngine> engines = new ArrayList<GraphQLEngine>();
    private final DataGraphElementLoader loader;
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphQLEngines.class);
    public static final String X_TRACING = "X-Tracing";

    GraphQLEngines(DataGraphElementLoader loader) {
        this.loader = loader;
    }

    void addEngine(GraphQLEngine engine) {
        this.engines.add(engine);
    }

    CompletionStage<String> definition(String sourceKey, Map<String, String> headers, Map<String, String> queryParams, String requestId, String correlationId) {
        RequestContext requestContext = GraphQLEngines.buildContext(headers, queryParams, requestId, correlationId);
        return this.getEngineOrFail(sourceKey).definitionAsJava(requestContext);
    }

    CompletionStage<GraphQLService.GraphQLServiceResult> execute(String graphQLQuery, String operationName, String sourceKey, Map<String, Object> variables, Map<String, String> headers, Map<String, String> queryParams, String requestId, String correlationId, Map<String, Object> extensions) {
        RequestContext requestContext = GraphQLEngines.buildContext(headers, queryParams, requestId, correlationId);
        LOGGER.debug("[RequestId: {}][CorrelationId: {}]", (Object)requestId, (Object)correlationId);
        Option stringOption = OptionConverters.toScala(Optional.ofNullable(operationName));
        return this.getEngineOrFail(sourceKey).executeJVMAsJava(graphQLQuery, stringOption, variables, extensions, requestContext);
    }

    void loadEngineConfig() {
        List<EngineData> enginesData = this.loader.loadProperties();
        for (EngineData engineData : enginesData) {
            RuntimeConfig libConfig = RuntimeConfig.create().withSystemProperties();
            libConfig.setHttpRequestExecutor((HttpRequestExecutor)new MuleHttpRequestExecutor(this.loader.getDefaultClient()));
            GraphQLEngine engine = JVMGraphQLEngine.create(engineData.getDataGraph(), (RuntimeConfig)libConfig, (ServiceSources)engineData.getServiceSources());
            this.addEngine(engine);
        }
    }

    private GraphQLEngine getEngineOrFail(String sourceKey) {
        if (sourceKey == null) {
            if (this.engines.size() > 1) {
                throw new IllegalStateException("More than one engine found for federation runtime.");
            }
            Optional federatedEngine = this.engines.stream().findFirst();
            if (federatedEngine.isPresent()) {
                return (GraphQLEngine)federatedEngine.get();
            }
            throw new IllegalStateException("No engine found for federation runtime. Call loadEngineConfig method first.");
        }
        List engines = this.engines.stream().filter(e -> e.getServiceSources().getSourcesId().contains((Object)sourceKey)).collect(Collectors.toList());
        if (engines.size() > 1) {
            throw new IllegalStateException("More than one engine found for sourceKey: " + sourceKey);
        }
        Optional engine = engines.stream().findFirst();
        if (engine.isPresent()) {
            return (GraphQLEngine)engine.get();
        }
        throw new IllegalStateException("API Query is not configured with a DataGraph. Call loadEngineConfig method first.");
    }

    public static RequestContext buildContext(Map<String, String> headers, Map<String, String> queryParams, String requestId, String correlationId) {
        String paramValue;
        boolean tracing = false;
        String value = headers.get(X_TRACING.toLowerCase());
        if (value != null) {
            tracing = Boolean.parseBoolean(value);
        }
        if ((paramValue = queryParams.get(X_TRACING.toLowerCase())) != null) {
            tracing = Boolean.parseBoolean(paramValue);
        }
        HashMap headersMap = new HashMap();
        headers.entrySet().stream().filter(x -> !((String)x.getKey()).equals(X_TRACING.toLowerCase())).forEach(entry -> headersMap.put((String)entry.getKey(), (String)entry.getValue()));
        return new RequestContext.RequestContextBuilder().withRequestId(requestId).withCorrelationId(correlationId).withTracing(Boolean.valueOf(tracing)).withHeaders(headersMap).build();
    }
}

