/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal;

import com.mulesoft.apiquery.adapter.internal.ApiQueryAdapterConfiguration;
import com.mulesoft.apiquery.adapter.internal.MemoryProvider;

public class MemoryPressureChecker {
    private MemoryPressureChecker() {
    }

    public static boolean allow(float memoryThreshold, MemoryProvider provider) {
        return (float)provider.totalMemory() - memoryThreshold * (float)provider.totalMemory() < (float)provider.freeMemory();
    }

    public static boolean allowInboundRequests(ApiQueryAdapterConfiguration config, MemoryProvider provider) {
        return !config.isEnableMemoryCheckForInboundRequests() || MemoryPressureChecker.allow(config.getMemoryThreshold(), provider);
    }

    public static boolean allowOutboundRequests(ApiQueryAdapterConfiguration config, MemoryProvider provider) {
        return MemoryPressureChecker.allow(config.getMemoryThreshold(), provider);
    }

    public static MemoryProvider getDefaultMemoryProvider() {
        return DefaultMemoryProvider.INSTANCE;
    }

    private static class DefaultMemoryProvider
    implements MemoryProvider {
        private static final MemoryProvider INSTANCE = new DefaultMemoryProvider();

        private DefaultMemoryProvider() {
        }

        @Override
        public long freeMemory() {
            return Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        }

        @Override
        public long totalMemory() {
            return Runtime.getRuntime().maxMemory();
        }
    }
}

