/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.http;

import com.mulesoft.apiquery.ServiceSource;
import com.mulesoft.apiquery.adapter.internal.http.Throttling;
import com.mulesoft.apiquery.adapter.internal.metric.ActionType;
import com.mulesoft.apiquery.adapter.internal.metric.Chronometer;
import com.mulesoft.apiquery.adapter.internal.metric.MetricBuilder;
import com.mulesoft.apiquery.adapter.internal.metric.MetricsReporter;
import com.mulesoft.apiquery.graphql.exceptions.JsonParseException;
import com.mulesoft.apiquery.http.HTTPProtocolClient;
import com.mulesoft.apiquery.http.HTTPRequest;
import com.mulesoft.apiquery.http.HTTPResponse;
import com.mulesoft.apiquery.log.Logging;
import com.mulesoft.apiquery.model.DataGraphData;
import com.mulesoft.apiquery.model.DataGraphDataJsonEncoder;
import com.mulesoft.apiquery.serialization.ResponseBodyParser;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;
import scala.util.Either;

public class MuleHttpClient
extends HTTPProtocolClient {
    private final String apifAppVersion;
    private final HttpClient httpClient;
    private final HttpRequestOptions httpClientConfig;
    private final MetricsReporter metricsReporter;
    private final Throttling throttling;
    private static final Logger LOG = LoggerFactory.getLogger(MuleHttpClient.class);

    public MuleHttpClient(HttpClient httpClient, MetricsReporter metricsReporter, Throttling throttling, String apifAppVersion, HttpRequestOptions httpClientConfig) {
        this.httpClient = httpClient;
        this.metricsReporter = metricsReporter;
        this.throttling = throttling;
        this.apifAppVersion = apifAppVersion;
        this.httpClientConfig = httpClientConfig;
    }

    public Future<HTTPResponse> execute(HTTPRequest request, ServiceSource source, Logging.LogContext lc) {
        CompletionStage futureResponse;
        Chronometer chronometer = Chronometer.create().start();
        try {
            futureResponse = ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.throttling.beforeInvoke(request).orElseGet(() -> this.httpClient.sendAsync(this.adapt(request), this.httpClientConfig)).thenApply(this::adapt)).thenApply(r -> {
                this.throttling.afterInvoke(request);
                return r;
            })).thenApply(r -> this.reportMetrics((HTTPResponse)r, source, chronometer, this.apifAppVersion))).whenComplete((r, e) -> {
                if (e != null) {
                    this.throttling.afterInvoke(request);
                }
            });
        }
        catch (Exception e2) {
            LOG.error("Unexpected MuleHttpClient execute exception: {}", (Object)e2.getMessage());
            this.throttling.afterInvoke(request);
            futureResponse = new CompletableFuture();
            futureResponse.completeExceptionally(e2);
        }
        return FutureConverters.toScala(futureResponse);
    }

    private HTTPResponse adapt(HttpResponse response) {
        try {
            String contentType = response.getHeaderValue("Content-Type");
            String content = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            Either parsedContentEither = ResponseBodyParser.parseForMediaType((int)response.getStatusCode(), (Option)Option.apply((Object)content), (Option)Option.apply((Object)contentType));
            if (parsedContentEither.isRight()) {
                return HTTPResponse.create((int)response.getStatusCode(), (Option)((Option)parsedContentEither.right().get()), (String)content, (java.util.Map)response.getHeaders(), (int)content.length());
            }
            throw (JsonParseException)parsedContentEither.left().get();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpRequest adapt(HTTPRequest request) {
        HttpRequestBuilder reqBuilder = (HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().method(request.method().toUpperCase()).uri(String.format("%s://%s", request.protocol(), request.url())).headers(new MultiMap(JavaConverters.mapAsJavaMap((Map)request.headers())))).addHeaders("Accept", JavaConverters.asJavaCollection((Iterable)request.mediaTypes()));
        if (request.payload().nonEmpty()) {
            reqBuilder.entity((HttpEntity)new ByteArrayHttpEntity(DataGraphDataJsonEncoder.toJsonByteArray((DataGraphData)((DataGraphData)request.payload().get()))));
        }
        return reqBuilder.build();
    }

    private HTTPResponse reportMetrics(HTTPResponse response, ServiceSource source, Chronometer chronometer, String apifAppVersion) {
        if (this.metricsReporter == null) {
            return response;
        }
        MetricBuilder.Dimension responseCodeFact = MetricBuilder.Dimension.build("http_status", Integer.toString(response.status()));
        MetricBuilder.Fact requestCount = MetricBuilder.Fact.build("request_count", 1.0);
        MetricBuilder.Fact timeFact = MetricBuilder.Fact.build("time", Double.valueOf(chronometer.getMilliseconds()));
        MetricBuilder.Fact payloadSizeFact = MetricBuilder.Fact.build("payload_size", Double.valueOf(response.getLength()));
        Optional<String> sourceName = source != null && source.getSourceName().isDefined() ? Optional.ofNullable((String)source.getSourceName().get()) : Optional.empty();
        String sourceId = source == null ? "unknown_source" : source.getSourceId();
        List<MetricBuilder.Fact> facts = Arrays.asList(requestCount, timeFact, payloadSizeFact);
        this.metricsReporter.report(sourceId, ActionType.EXECUTE, apifAppVersion, Collections.singletonList(responseCodeFact), facts, sourceName);
        return response;
    }
}

