/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.http.oauth;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.dmfs.httpessentials.HttpStatus;
import org.dmfs.httpessentials.client.HttpRequest;
import org.dmfs.httpessentials.client.HttpRequestEntity;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.dmfs.httpessentials.client.HttpResponse;
import org.dmfs.httpessentials.client.HttpResponseEntity;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.httpessentials.headers.FilteredHeaders;
import org.dmfs.httpessentials.headers.Header;
import org.dmfs.httpessentials.headers.HeaderType;
import org.dmfs.httpessentials.headers.Headers;
import org.dmfs.httpessentials.headers.ListHeaderType;
import org.dmfs.httpessentials.headers.SingletonHeaderType;
import org.dmfs.httpessentials.headers.UpdatedHeaders;
import org.dmfs.httpessentials.status.SimpleHttpStatus;
import org.dmfs.httpessentials.types.MediaType;
import org.dmfs.httpessentials.types.StringMediaType;
import org.dmfs.iterators.decorators.Filtered;
import org.dmfs.iterators.decorators.Flattened;
import org.dmfs.jems.optional.Optional;
import org.dmfs.jems.optional.adapters.Conditional;
import org.dmfs.jems.optional.decorators.Mapped;
import org.dmfs.jems.optional.elementary.NullSafe;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;

public class MuleHttpRequestExecutor
implements HttpRequestExecutor {
    private final HttpClient client;

    public MuleHttpRequestExecutor(HttpClient client) {
        this.client = client;
    }

    public <T> T execute(final URI uri, HttpRequest<T> httpRequest) throws IOException, ProtocolError, ProtocolException {
        MultiMap headers = new MultiMap();
        httpRequest.headers().forEach(h -> headers.put((Object)h.type().name(), (Object)h.value().toString()));
        HttpRequestEntity httpRequestEntity = httpRequest.requestEntity();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        httpRequestEntity.writeContent((OutputStream)baos);
        HttpRequestBuilder requestBuilder = (HttpRequestBuilder)((HttpRequestBuilder)org.mule.runtime.http.api.domain.message.request.HttpRequest.builder().uri(uri).method(httpRequest.method().verb()).headers(headers)).entity((HttpEntity)new ByteArrayHttpEntity(baos.toByteArray()));
        if (httpRequestEntity.contentType().isPresent()) {
            requestBuilder.addHeader("Content-Type", ((MediaType)httpRequestEntity.contentType().value()).type());
        }
        if (httpRequestEntity.contentLength().isPresent()) {
            requestBuilder.addHeader("Content-Length", ((Long)httpRequestEntity.contentLength().value()).toString());
        }
        try {
            final org.mule.runtime.http.api.domain.message.response.HttpResponse send = this.client.send(requestBuilder.build());
            HttpResponse r = new HttpResponse(){

                public HttpStatus status() {
                    return new SimpleHttpStatus(send.getStatusCode(), send.getReasonPhrase());
                }

                public Headers headers() {
                    return new Headers(){

                        public boolean contains(HeaderType<?> headerType) {
                            return new Filtered(send.getHeaders().keySet().iterator(), v -> headerType.name().equalsIgnoreCase((String)v)).hasNext();
                        }

                        public <T> Header<T> header(SingletonHeaderType<T> headerType) {
                            return headerType.entityFromString((String)send.getHeaders().get(new Filtered(send.getHeaders().keySet().iterator(), v -> headerType.name().equalsIgnoreCase((String)v)).next()));
                        }

                        public <T> Header<List<T>> header(ListHeaderType<T> headerType) {
                            Header result = headerType.entity(Collections.emptyList());
                            org.dmfs.jems.iterator.decorators.Mapped headerIterator = new org.dmfs.jems.iterator.decorators.Mapped(arg_0 -> headerType.entityFromString(arg_0), (Iterator)new Flattened((Iterator)new org.dmfs.jems.iterator.decorators.Mapped(arg_0 -> ((MultiMap)send.getHeaders()).getAll(arg_0), (Iterator)new Filtered(send.getHeaders().keySet().iterator(), v -> headerType.name().equalsIgnoreCase((String)v)))));
                            while (headerIterator.hasNext()) {
                                result = headerType.merged(result, (Header)headerIterator.next());
                            }
                            return result;
                        }

                        public <T> Headers withHeader(Header<T> header) {
                            return new UpdatedHeaders((Headers)this, header);
                        }

                        public <T> Headers withoutHeaderType(HeaderType<T> headerType) {
                            return new FilteredHeaders((Headers)this, new HeaderType[]{headerType});
                        }

                        public Iterator<Header<?>> iterator() {
                            throw new UnsupportedOperationException("Iterating headers is not supported.");
                        }
                    };
                }

                public HttpResponseEntity responseEntity() {
                    return new HttpResponseEntity(){

                        public Optional<MediaType> contentType() {
                            return new Mapped(StringMediaType::new, (Optional)new NullSafe((Object)send.getHeaderValue("Content-Type")));
                        }

                        public Optional<Long> contentLength() {
                            long length;
                            try {
                                length = Long.parseLong(send.getHeaderValue("Content-Length"));
                            }
                            catch (NumberFormatException e) {
                                length = 0L;
                            }
                            return new Conditional(l -> l >= 0L, (Object)length);
                        }

                        public InputStream contentStream() {
                            return send.getEntity().getContent();
                        }
                    };
                }

                public URI requestUri() {
                    return uri;
                }

                public URI responseUri() {
                    return uri;
                }
            };
            return (T)httpRequest.responseHandler(r).handleResponse(r);
        }
        catch (TimeoutException e) {
            throw new IOException(e);
        }
    }
}

