/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.loader;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public abstract class PropertiesRetriever {
    public abstract Map<String, String> getAllProperties();

    public final boolean getBoolean(String key, Boolean defaultValue) {
        return this.getOrDefault(key, defaultValue, Boolean::valueOf);
    }

    public final float getFloat(String key, Float defaultValue) {
        return this.getOrDefault(key, defaultValue, Float::valueOf).floatValue();
    }

    public final int getInteger(String key, Integer defaultValue) {
        return this.getOrDefault(key, defaultValue, Integer::valueOf);
    }

    public final Optional<String> getOptionalProperty(String name) {
        return Optional.ofNullable(this.getProperty(name));
    }

    public abstract String getProperty(String var1);

    private <T> T getOrDefault(String key, T defaultValue, Function<String, T> converter) {
        try {
            String found = this.getProperty(key);
            if (found == null) {
                return defaultValue;
            }
            return converter.apply(found);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

