/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.apiquery.adapter.internal.http;

import com.mulesoft.apiquery.adapter.internal.http.Throttling;
import com.mulesoft.apiquery.http.HTTPRequest;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MaxOutboundConnectionsThrottling
implements Throttling {
    private final int maxConnections;
    private final Supplier<Boolean> memPressureAllow;
    private final AtomicInteger mutex = new AtomicInteger(0);
    private static final Logger LOG = LoggerFactory.getLogger(MaxOutboundConnectionsThrottling.class);

    MaxOutboundConnectionsThrottling(int maxConnections, Supplier<Boolean> memPressureAllow) {
        this.maxConnections = maxConnections;
        this.memPressureAllow = memPressureAllow;
        LOG.info("Configuring throttling at {}", (Object)maxConnections);
    }

    @Override
    public void afterInvoke(HTTPRequest request) {
        this.mutex.decrementAndGet();
    }

    @Override
    public Optional<CompletableFuture<HttpResponse>> beforeInvoke(HTTPRequest request) {
        int increment = this.mutex.getAndIncrement();
        LOG.debug("Used connections: {}", (Object)increment);
        if (increment >= this.maxConnections) {
            LOG.error("Max connection {} reached", (Object)this.maxConnections);
            return this.tooManyRequestsFailure();
        }
        if (this.isMemPressureAllowFalse()) {
            LOG.error("Max allowed memory reached");
            return this.tooManyRequestsFailure();
        }
        return Optional.empty();
    }

    private Optional<CompletableFuture<HttpResponse>> tooManyRequestsFailure() {
        return Optional.of(CompletableFuture.completedFuture(this.tooManyRequests()));
    }

    private boolean isMemPressureAllowFalse() {
        return Boolean.FALSE.equals(this.memPressureAllow.get());
    }
}

