/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.modify.UpdateEngine;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeFactoryExtra;

public abstract class UpdateEngineBase
implements UpdateEngine {
    protected final DatasetGraph datasetGraph;
    protected final Binding inputBinding;
    protected final Context context;

    public UpdateEngineBase(DatasetGraph datasetGraph, Binding inputBinding, Context context) {
        this.datasetGraph = datasetGraph;
        this.inputBinding = inputBinding;
        this.context = UpdateEngineBase.setupContext(context, datasetGraph);
    }

    private static Context setupContext(Context context, DatasetGraph dataset) {
        if (context == null) {
            context = ARQ.getContext();
        }
        context = context.copy();
        if (dataset.getContext() != null) {
            context.putAll(dataset.getContext());
        }
        context.set(ARQConstants.sysCurrentTime, NodeFactoryExtra.nowAsDateTime());
        return context;
    }
}

