/*
 * Decompiled with CFR 0.152.
 */
package amf.core.registries;

import amf.core.metamodel.Obj;
import amf.core.model.domain.AnnotationGraphLoader;
import amf.core.plugins.AMFDocumentPlugin;
import amf.core.plugins.AMFDomainPlugin;
import amf.core.plugins.AMFPlugin;
import amf.core.plugins.AMFSyntaxPlugin;
import amf.core.registries.AMFDomainEntityResolver;
import amf.core.registries.AMFDomainRegistry$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;

public final class AMFPluginsRegistry$ {
    public static AMFPluginsRegistry$ MODULE$;
    private final HashMap<String, AMFSyntaxPlugin> syntaxPluginIDRegistry;
    private final HashMap<String, AMFSyntaxPlugin> syntaxPluginRegistry;
    private final HashMap<String, Seq<AMFDocumentPlugin>> documentPluginRegistry;
    private final HashMap<String, AMFDocumentPlugin> documentPluginIDRegistry;
    private final HashMap<String, Seq<AMFDocumentPlugin>> documentPluginVendorsRegistry;
    private final HashMap<String, AMFDomainPlugin> domainPluginRegistry;
    private final HashMap<String, AMFPlugin> featurePluginIDRegistry;
    private final HashMap<String, AMFPlugin> featurePlugin;

    static {
        new AMFPluginsRegistry$();
    }

    private HashMap<String, AMFSyntaxPlugin> syntaxPluginIDRegistry() {
        return this.syntaxPluginIDRegistry;
    }

    private HashMap<String, AMFSyntaxPlugin> syntaxPluginRegistry() {
        return this.syntaxPluginRegistry;
    }

    private HashMap<String, Seq<AMFDocumentPlugin>> documentPluginRegistry() {
        return this.documentPluginRegistry;
    }

    private HashMap<String, AMFDocumentPlugin> documentPluginIDRegistry() {
        return this.documentPluginIDRegistry;
    }

    private HashMap<String, Seq<AMFDocumentPlugin>> documentPluginVendorsRegistry() {
        return this.documentPluginVendorsRegistry;
    }

    private HashMap<String, AMFDomainPlugin> domainPluginRegistry() {
        return this.domainPluginRegistry;
    }

    private HashMap<String, AMFPlugin> featurePluginIDRegistry() {
        return this.featurePluginIDRegistry;
    }

    private HashMap<String, AMFPlugin> featurePlugin() {
        return this.featurePlugin;
    }

    public Iterable<AMFPlugin> plugins() {
        return (Iterable)((TraversableLike)((TraversableLike)this.syntaxPluginIDRegistry().values().$plus$plus((GenTraversableOnce)this.documentPluginIDRegistry().values(), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.domainPluginRegistry().values(), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.featurePluginIDRegistry().values(), Iterable$.MODULE$.canBuildFrom());
    }

    public Iterable<AMFDocumentPlugin> documentPlugins() {
        return this.documentPluginIDRegistry().values();
    }

    public void registerSyntaxPlugin(AMFSyntaxPlugin syntaxPlugin) {
        Option option = this.syntaxPluginIDRegistry().get((Object)syntaxPlugin.ID());
        if (option instanceof Some) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.syntaxPluginIDRegistry().put((Object)syntaxPlugin.ID(), (Object)syntaxPlugin);
            syntaxPlugin.supportedMediaTypes().foreach((Function1 & Serializable & scala.Serializable)mediaType -> {
                boolean bl = false;
                Some some = null;
                Option option = this.syntaxPluginRegistry().get(mediaType);
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    AMFSyntaxPlugin plugin = (AMFSyntaxPlugin)some.value();
                    String string = plugin.ID();
                    String string2 = syntaxPlugin.ID();
                    if (string == null) {
                        if (string2 == null) return BoxedUnit.UNIT;
                    } else if (string.equals(string2)) {
                        return BoxedUnit.UNIT;
                    }
                }
                if (None$.MODULE$.equals(option)) {
                    return this.syntaxPluginRegistry().put(mediaType, (Object)syntaxPlugin);
                }
                if (!bl) throw new MatchError((Object)option);
                AMFSyntaxPlugin plugin = (AMFSyntaxPlugin)some.value();
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot register ", " for media type ", ", ", " already registered"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{syntaxPlugin.ID(), mediaType, plugin.ID()})));
            });
            this.registerDependencies(syntaxPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public Option<AMFSyntaxPlugin> syntaxPluginForMediaType(String mediaType) {
        Option option;
        Option option2 = this.syntaxPluginRegistry().get((Object)mediaType);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            AMFSyntaxPlugin plugin = (AMFSyntaxPlugin)some.value();
            option = new Some((Object)plugin);
        } else {
            option = this.syntaxPluginRegistry().get((Object)this.simpleMediaType(mediaType));
        }
        return option;
    }

    public void registerFeaturePlugin(AMFPlugin featurePlugin) {
        Option option = this.featurePluginIDRegistry().get((Object)featurePlugin.ID());
        if (option instanceof Some) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.featurePluginIDRegistry().put((Object)featurePlugin.ID(), (Object)featurePlugin);
            this.registerDependencies(featurePlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void registerDocumentPlugin(AMFDocumentPlugin documentPlugin) {
        Option option = this.documentPluginIDRegistry().get((Object)documentPlugin.ID());
        if (option instanceof Some) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.documentPluginIDRegistry().put((Object)documentPlugin.ID(), (Object)documentPlugin);
            documentPlugin.serializableAnnotations().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                AnnotationGraphLoader unloader = (AnnotationGraphLoader)tuple2._2();
                Option<AnnotationGraphLoader> option = AMFDomainRegistry$.MODULE$.registerAnnotation(name, unloader);
                return option;
            });
            documentPlugin.documentSyntaxes().foreach((Function1 & Serializable & scala.Serializable)mediaType -> {
                Seq plugins = (Seq)this.documentPluginRegistry().getOrElse(mediaType, (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                return this.documentPluginRegistry().put(mediaType, plugins.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AMFDocumentPlugin[]{documentPlugin})), Seq$.MODULE$.canBuildFrom()));
            });
            documentPlugin.vendors().foreach((Function1 & Serializable & scala.Serializable)vendor -> {
                Seq plugins = (Seq)this.documentPluginVendorsRegistry().getOrElse(vendor, (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                return this.documentPluginVendorsRegistry().put(vendor, plugins.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AMFDocumentPlugin[]{documentPlugin})), Seq$.MODULE$.canBuildFrom()));
            });
            documentPlugin.modelEntities().foreach((Function1 & Serializable & scala.Serializable)entity -> AMFDomainRegistry$.MODULE$.registerModelEntity((Obj)entity));
            documentPlugin.modelEntitiesResolver().foreach((Function1 & Serializable & scala.Serializable)resolver -> {
                AMFDomainRegistry$.MODULE$.registerModelEntityResolver(resolver);
                return BoxedUnit.UNIT;
            });
            this.registerDependencies(documentPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public Seq<AMFDocumentPlugin> documentPluginForMediaType(String mediaType) {
        return (Seq)this.documentPluginRegistry().getOrElse((Object)mediaType, (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public Option<AMFDocumentPlugin> documentPluginForID(String ID) {
        return this.documentPluginIDRegistry().get((Object)ID);
    }

    public Seq<AMFDocumentPlugin> documentPluginForVendor(String vendor) {
        return (Seq)this.documentPluginVendorsRegistry().getOrElse((Object)vendor, (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
    }

    public void registerDomainPlugin(AMFDomainPlugin domainPlugin) {
        Option option = this.domainPluginRegistry().get((Object)domainPlugin.ID());
        if (option instanceof Some) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            domainPlugin.serializableAnnotations().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                AnnotationGraphLoader unloader = (AnnotationGraphLoader)tuple2._2();
                Option<AnnotationGraphLoader> option = AMFDomainRegistry$.MODULE$.registerAnnotation(name, unloader);
                return option;
            });
            this.domainPluginRegistry().put((Object)domainPlugin.ID(), (Object)domainPlugin);
            domainPlugin.modelEntities().foreach((Function1 & Serializable & scala.Serializable)entity -> AMFDomainRegistry$.MODULE$.registerModelEntity((Obj)entity));
            Option<AMFDomainEntityResolver> option2 = domainPlugin.modelEntitiesResolver();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                AMFDomainEntityResolver resolver = (AMFDomainEntityResolver)some.value();
                AMFDomainRegistry$.MODULE$.registerModelEntityResolver(resolver);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.registerDependencies(domainPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String simpleMediaType(String mediaType) {
        Option option;
        String[] stringArray = mediaType.split("/");
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
            String main = (String)((SeqLike)option2.get()).apply(0);
            String sub = (String)((SeqLike)option2.get()).apply(1);
            if (sub.indexOf("+") > -1) {
                return main + "/" + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sub.split("\\+"))).last();
            }
        }
        if ((option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty()) return mediaType;
        if (option.get() == null) return mediaType;
        if (((SeqLike)option.get()).lengthCompare(2) != 0) return mediaType;
        String main = (String)((SeqLike)option.get()).apply(0);
        String sub = (String)((SeqLike)option.get()).apply(1);
        if (sub.indexOf(".") <= -1) return mediaType;
        return main + "/" + new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sub.split("\\."))).last();
    }

    public void registerDependencies(AMFPlugin plugin) {
        plugin.dependencies().foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            AMFPluginsRegistry$.$anonfun$registerDependencies$1(this, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$registerDependencies$1(AMFPluginsRegistry$ $this, AMFPlugin x0$3) {
        AMFPlugin aMFPlugin = x0$3;
        if (aMFPlugin instanceof AMFDomainPlugin) {
            AMFDomainPlugin aMFDomainPlugin = (AMFDomainPlugin)aMFPlugin;
            $this.registerDomainPlugin(aMFDomainPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (aMFPlugin instanceof AMFDocumentPlugin) {
            AMFDocumentPlugin aMFDocumentPlugin = (AMFDocumentPlugin)aMFPlugin;
            $this.registerDocumentPlugin(aMFDocumentPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (aMFPlugin instanceof AMFSyntaxPlugin) {
            AMFSyntaxPlugin aMFSyntaxPlugin = (AMFSyntaxPlugin)aMFPlugin;
            $this.registerSyntaxPlugin(aMFSyntaxPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private AMFPluginsRegistry$() {
        MODULE$ = this;
        this.syntaxPluginIDRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.syntaxPluginRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.documentPluginRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.documentPluginIDRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.documentPluginVendorsRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.domainPluginRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.featurePluginIDRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.featurePlugin = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

