/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.util.IteratorCollection;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphUtil {
    private static final boolean OldStyle = true;
    private static int MIN_SRC_SIZE = 1000;
    private static int DST_SRC_RATIO = 2;
    private static final int sliceSize = 1000;

    private GraphUtil() {
    }

    public static ExtendedIterator<Node> listSubjects(Graph g, Node p, Node o) {
        ExtendedIterator<Triple> iter = g.find(Node.ANY, p, o);
        Set<Node> nodes = iter.mapWith(t -> t.getSubject()).toSet();
        return WrappedIterator.createNoRemove(nodes.iterator());
    }

    public static ExtendedIterator<Node> listPredicates(Graph g, Node s, Node o) {
        ExtendedIterator<Triple> iter = g.find(s, Node.ANY, o);
        Set<Node> nodes = iter.mapWith(t -> t.getPredicate()).toSet();
        return WrappedIterator.createNoRemove(nodes.iterator());
    }

    public static ExtendedIterator<Node> listObjects(Graph g, Node s, Node p) {
        ExtendedIterator<Triple> iter = g.find(s, p, Node.ANY);
        Set<Node> nodes = iter.mapWith(t -> t.getObject()).toSet();
        return WrappedIterator.createNoRemove(nodes.iterator());
    }

    public static boolean containsNode(Graph graph, Node node) {
        return graph.contains(node, Node.ANY, Node.ANY) || graph.contains(Node.ANY, Node.ANY, node) || graph.contains(Node.ANY, node, Node.ANY);
    }

    public static ExtendedIterator<Triple> findAll(Graph g) {
        return g.find(Triple.ANY);
    }

    public static void add(Graph graph, Triple[] triples) {
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g = (GraphWithPerform)graph;
            for (Triple t : triples) {
                g.performAdd(t);
            }
            graph.getEventManager().notifyAddArray(graph, triples);
        } else {
            for (Triple t : triples) {
                graph.add(t);
            }
        }
    }

    public static void add(Graph graph, List<Triple> triples) {
        GraphUtil.addIteratorWorkerDirect(graph, triples.iterator());
        if (graph instanceof GraphWithPerform) {
            graph.getEventManager().notifyAddList(graph, triples);
        }
    }

    public static void add(Graph graph, Iterator<Triple> it) {
        if (graph instanceof GraphWithPerform) {
            List<Triple> s = IteratorCollection.iteratorToList(it);
            GraphUtil.addIteratorWorkerDirect(graph, s.iterator());
            graph.getEventManager().notifyAddIterator(graph, s);
        } else {
            GraphUtil.addIteratorWorker(graph, it);
        }
    }

    public static void addInto(Graph dstGraph, Graph srcGraph) {
        if (dstGraph == srcGraph && !dstGraph.getEventManager().listening()) {
            return;
        }
        dstGraph.getPrefixMapping().setNsPrefixes(srcGraph.getPrefixMapping());
        GraphUtil.addIteratorWorker(dstGraph, GraphUtil.findAll(srcGraph));
        dstGraph.getEventManager().notifyAddGraph(dstGraph, srcGraph);
    }

    private static void addIteratorWorker(Graph graph, Iterator<Triple> it) {
        List<Triple> s = IteratorCollection.iteratorToList(it);
        GraphUtil.addIteratorWorkerDirect(graph, s.iterator());
    }

    private static void addIteratorWorkerDirect(Graph graph, Iterator<Triple> it) {
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g = (GraphWithPerform)graph;
            it.forEachRemaining(g::performAdd);
        } else {
            it.forEachRemaining(graph::add);
        }
    }

    private static boolean requireEvents(Graph graph) {
        return graph.getEventManager().listening();
    }

    public static void delete(Graph graph, Triple[] triples) {
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g = (GraphWithPerform)graph;
            for (Triple t : triples) {
                g.performDelete(t);
            }
            graph.getEventManager().notifyDeleteArray(graph, triples);
        } else {
            for (Triple t : triples) {
                graph.delete(t);
            }
        }
    }

    public static void delete(Graph graph, List<Triple> triples) {
        GraphUtil.deleteIteratorWorkerDirect(graph, triples.iterator());
        if (graph instanceof GraphWithPerform) {
            graph.getEventManager().notifyDeleteList(graph, triples);
        }
    }

    public static void delete(Graph graph, Iterator<Triple> it) {
        if (graph instanceof GraphWithPerform) {
            List<Triple> s = IteratorCollection.iteratorToList(it);
            GraphUtil.deleteIteratorWorkerDirect(graph, s.iterator());
            graph.getEventManager().notifyDeleteIterator(graph, s);
        } else {
            GraphUtil.deleteIteratorWorker(graph, it);
        }
    }

    public static void deleteFrom(Graph dstGraph, Graph srcGraph) {
        boolean loopOnSrc;
        boolean events = GraphUtil.requireEvents(dstGraph);
        if (dstGraph == srcGraph && !events) {
            dstGraph.clear();
            return;
        }
        int dstSize = dstGraph.size();
        int srcSize = srcGraph.size();
        boolean bl = loopOnSrc = srcSize < MIN_SRC_SIZE || dstSize > DST_SRC_RATIO * srcSize;
        if (loopOnSrc) {
            GraphUtil.deleteIteratorWorker(dstGraph, GraphUtil.findAll(srcGraph));
            dstGraph.getEventManager().notifyDeleteGraph(dstGraph, srcGraph);
            return;
        }
        ArrayList<Triple> toBeDeleted = new ArrayList<Triple>();
        ExtendedIterator<Triple> iter = GraphUtil.findAll(dstGraph);
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            if (!srcGraph.contains(t)) continue;
            toBeDeleted.add(t);
        }
        GraphUtil.deleteIteratorWorkerDirect(dstGraph, toBeDeleted.iterator());
        dstGraph.getEventManager().notifyDeleteGraph(dstGraph, srcGraph);
    }

    private static void deleteIteratorWorker(Graph graph, Iterator<Triple> it) {
        List<Triple> s = IteratorCollection.iteratorToList(it);
        GraphUtil.deleteIteratorWorkerDirect(graph, s.iterator());
    }

    private static void deleteIteratorWorkerDirect(Graph graph, Iterator<Triple> it) {
        if (graph instanceof GraphWithPerform) {
            GraphWithPerform g = (GraphWithPerform)graph;
            it.forEachRemaining(g::performDelete);
        } else {
            it.forEachRemaining(graph::delete);
        }
    }

    public static void remove(Graph g, Node s, Node p, Node o) {
        int len;
        Triple[] array = new Triple[1000];
        do {
            ExtendedIterator<Triple> iter = g.find(s, p, o);
            for (len = 0; len < 1000 && iter.hasNext(); ++len) {
                array[len] = (Triple)iter.next();
            }
            for (int i = 0; i < len; ++i) {
                g.delete(array[i]);
                array[i] = null;
            }
        } while (len >= 1000);
    }
}

