/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq.functions;

import java.net.URI;
import java.util.Collections;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.shacl.arq.functions.SHACLRecursionGuard;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.util.FailureLog;
import org.topbraid.shacl.validation.DefaultShapesGraphProvider;
import org.topbraid.shacl.validation.ValidationEngineFactory;
import org.topbraid.shacl.validation.sparql.AbstractSPARQLExecutor;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.AbstractFunction3;
import org.topbraid.spin.util.JenaDatatypes;

public class HasShapeFunction
extends AbstractFunction3 {
    private static ThreadLocal<Boolean> recursionIsErrorFlag = new ThreadLocal();
    private static ThreadLocal<Model> resultsModelTL = new ThreadLocal();
    private static ThreadLocal<URI> shapesGraph = new ThreadLocal();

    public static Model getResultsModel() {
        return resultsModelTL.get();
    }

    public static URI getShapesGraph() {
        return shapesGraph.get();
    }

    public static void setResultsModel(Model value) {
        resultsModelTL.set(value);
    }

    public static void setShapesGraph(URI uri) {
        shapesGraph.set(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected NodeValue exec(Node focusNode, Node shapeNode, Node recursionIsError, FunctionEnv env) {
        Boolean oldFlag = recursionIsErrorFlag.get();
        if (JenaDatatypes.TRUE.asNode().equals((Object)recursionIsError)) {
            recursionIsErrorFlag.set(true);
        }
        try {
            Model results;
            block15: {
                NodeValue nodeValue;
                if (SHACLRecursionGuard.start(focusNode, shapeNode)) {
                    if (JenaDatatypes.TRUE.asNode().equals((Object)recursionIsError) || oldFlag != null && oldFlag.booleanValue()) {
                        String message = "Unsupported recursion";
                        Model resultsModel = resultsModelTL.get();
                        Resource failure = resultsModel.createResource(DASH.FailureResult);
                        failure.addProperty(SH.resultMessage, message);
                        failure.addProperty(SH.focusNode, resultsModel.asRDFNode(focusNode));
                        failure.addProperty(SH.sourceShape, resultsModel.asRDFNode(shapeNode));
                        FailureLog.get().logFailure(message);
                        throw new ExprEvalException("Unsupported recursion");
                    }
                    SHACLRecursionGuard.end(focusNode, shapeNode);
                    NodeValue message = NodeValue.TRUE;
                    return message;
                }
                try {
                    Model model = ModelFactory.createModelForGraph((Graph)env.getActiveGraph());
                    RDFNode resource = model.asRDFNode(focusNode);
                    Dataset dataset = DatasetImpl.wrap((DatasetGraph)env.getDataset());
                    Resource shape = (Resource)dataset.getDefaultModel().asRDFNode(shapeNode);
                    results = this.doRun(resource, shape, dataset);
                    if (resultsModelTL.get() != null) {
                        resultsModelTL.get().add(results);
                    }
                    if (results.contains(null, RDF.type, (RDFNode)DASH.FailureResult)) {
                        throw new ExprEvalException("Propagating failure from nested shapes");
                    }
                    if (!AbstractSPARQLExecutor.createDetails) break block15;
                    boolean result = true;
                    for (Resource r : results.listSubjectsWithProperty(RDF.type, (RDFNode)SH.ValidationResult).toList()) {
                        if (results.contains(null, SH.detail, (RDFNode)r)) continue;
                        result = false;
                        break;
                    }
                    nodeValue = NodeValue.makeBoolean((boolean)result);
                }
                catch (Throwable throwable) {
                    SHACLRecursionGuard.end(focusNode, shapeNode);
                    throw throwable;
                }
                SHACLRecursionGuard.end(focusNode, shapeNode);
                return nodeValue;
            }
            boolean result = !results.contains(null, RDF.type, (RDFNode)SH.ValidationResult);
            NodeValue nodeValue = NodeValue.makeBoolean((boolean)result);
            SHACLRecursionGuard.end(focusNode, shapeNode);
            return nodeValue;
        }
        finally {
            recursionIsErrorFlag.set(oldFlag);
        }
    }

    private Model doRun(RDFNode focusNode, Resource shape, Dataset dataset) {
        URI shapesGraphURI = shapesGraph.get();
        if (shapesGraphURI == null) {
            shapesGraphURI = DefaultShapesGraphProvider.get().getDefaultShapesGraphURI(dataset);
        }
        Model shapesModel = dataset.getNamedModel(shapesGraphURI.toString());
        ShapesGraph shapes = new ShapesGraph(shapesModel);
        return ValidationEngineFactory.get().create(dataset, shapesGraphURI, shapes, null).validateNodesAgainstShape(Collections.singletonList(focusNode), shape.asNode()).getModel();
    }
}

