%dw 2.0
output text/plain

import * from bat::Types
import DEBUG from bat::core::Console
import * from dw::http::Client

ns bat http://mulesoft.com/ns/bat

var testIdSplit = (payload.metadata.testId default '') splitBy ":"

var packageName = (testIdSplit[0] default '') ++ ':' ++ (testIdSplit[1] default '')

fun state(suite) = do {
  if(suite.skip == true)
    'pending'
  else if(suite.pass == true)
    'passed'
  else
    'failed'
}

fun sanitzeName(name: String) = name replace /([\/\]\[|*])/ with '-'

fun processHttp(httpCall: BATPassCapable<Any>, suite: String, classname: String = '', keywords: Array<String> = [], id: String | Null = null) = write({
  "job_name": ((if(DEBUG) httpCall.name else dw::System::envVar('JOB_NAME')) default httpCall.name default 'Test name'),
	"environment": (payload.parameters.env default 'default'),
	"build_number": ((if(DEBUG) 1000 else dw::System::envVar('BUILD_NUMBER')) default payload.metadata.executionNumber default 0),
	"commit": if(DEBUG) 'abcde12' else dw::System::envVar('GIT_COMMIT'),
	"test_type": "api-test",
	"package_name": (packageName default ''),
	"package_version": (testIdSplit[2] default ''),
	"title": (httpCall.name default 'Test name'),
	"suite": suite,
	"path": classname,
	"file": '-',
	"start": (httpCall.startDate default payload.startDate default now()),
	"duration": (httpCall.time default 0),
	"state": state(httpCall),
	"err": '',
	"keywords": keywords,
	"id": id
}, 'application/json', {indent: false})

fun processSuite(elem) = do {
  flatten(elem.result map print($, elem.name, elem.name))
}

fun sanitzeName(name: String) = name replace /([\/\]\[|*])/ with '-'

fun processTest(elem: BATPassCapable<Any>, suite: String, classname: String = '', keywords: Array<String> = []) = do {
  var package = elem.name
  var head = if(classname == '') '' else (classname ++ '/')
  var newKeywords = (elem.metadata.tags default []) ++ keywords distinctBy $
  ---
  if (elem.prefix == "SUITE")
    processSuite(elem)
  else
    flatten(elem.result map print($, suite, head ++ sanitzeName(package), newKeywords, elem.metadata.id))
}

fun print(elem, suite: String = payload.name, classname: String = '', keywords: Array<String> = [], id: String | Null = null) =
  elem match {
    case passCapable if passCapable is BATPassCapable<Any> ->
      passCapable.kind match {
        case "TEST"  -> processTest(passCapable, suite, classname, keywords)
        case "HTTP"  -> processHttp(passCapable, suite, classname, keywords, id)
        case "LOOPABLE" -> processTest(passCapable, suite, classname, keywords)
        else -> []
      }
    else -> using(yy = log('No match for', elem)) {}
  }

fun endpoint(): String =
  if(options != null and options.SUMO_ENDPOINT != null)
    options.SUMO_ENDPOINT default ''
  else if((dw::System::envVar('SUMO_ENDPOINT') default '') != '')
    dw::System::envVar('SUMO_ENDPOINT') default ''
  else
    log('Missing SUMO_ENDPOINT env variable or option', '')

var dataToSend = flatten(print(payload)) map $ joinBy "\n"
---
if (DEBUG or endpoint() == '')
  dataToSend
else
  (request('POST', endpoint(), {
     body: dataToSend as Binary,
     headers: {
       'Content-Type': 'application/json'
     }
  }) write 'application/json')

