/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.model.SHFactory;
import org.topbraid.shacl.model.SHPropertyShape;
import org.topbraid.shacl.validation.ConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;

class PropertyConstraintExecutor
implements ConstraintExecutor {
    PropertyConstraintExecutor() {
    }

    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine engine, List<RDFNode> focusNodes) {
        SHPropertyShape propertyShape = SHFactory.asPropertyShape(constraint.getParameterValue());
        if (constraint.getShapeResource().isPropertyShape()) {
            LinkedList<RDFNode> valueNodes = new LinkedList<RDFNode>();
            for (RDFNode focusNode : focusNodes) {
                valueNodes.addAll(engine.getValueNodes(constraint, focusNode));
            }
            engine.validateNodesAgainstShape(valueNodes, propertyShape.asNode());
        } else {
            engine.validateNodesAgainstShape(focusNodes, propertyShape.asNode());
        }
    }
}

