/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.engine;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.path.Path;
import org.topbraid.shacl.arq.SHACLPaths;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.engine.ShapesGraph;
import org.topbraid.shacl.model.SHConstraintComponent;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHShape;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.system.SPINLabels;

public class Shape {
    private List<Constraint> constraints;
    private Path jenaPath;
    private SHShape shape;
    private ShapesGraph shapesGraph;

    public Shape(ShapesGraph shapesGraph, SHShape shape) {
        this.shape = shape;
        this.shapesGraph = shapesGraph;
        Resource path = shape.getPath();
        if (path != null && path.isAnon()) {
            this.jenaPath = (Path)SHACLPaths.getJenaPath(SHACLPaths.getPathString(path), path.getModel());
        }
    }

    public Iterable<Constraint> getConstraints() {
        if (this.constraints == null) {
            this.constraints = new LinkedList<Constraint>();
            HashSet<SHConstraintComponent> handled = new HashSet<SHConstraintComponent>();
            for (Statement s : this.shape.listProperties().toList()) {
                Constraint constraint;
                SHConstraintComponent component = this.shapesGraph.getComponentWithParameter(s.getPredicate());
                if (component == null || handled.contains(component)) continue;
                List<SHParameter> params = component.getParameters();
                if (params.size() == 1) {
                    constraint = new Constraint(this, component, params, s.getObject());
                    if (this.shapesGraph.isIgnoredConstraint(constraint)) continue;
                    this.constraints.add(constraint);
                    continue;
                }
                if (!this.isComplete(params)) continue;
                handled.add(component);
                constraint = new Constraint(this, component, params, null);
                if (this.shapesGraph.isIgnoredConstraint(constraint)) continue;
                this.constraints.add(constraint);
            }
        }
        return this.constraints;
    }

    public Path getJenaPath() {
        return this.jenaPath;
    }

    public Double getOrder() {
        Statement s = this.shape.getProperty(SH.order);
        if (s != null && s.getObject().isLiteral()) {
            return s.getLiteral().getDouble();
        }
        return 0.0;
    }

    public SHShape getShapeResource() {
        return this.shape;
    }

    private boolean isComplete(List<SHParameter> params) {
        for (SHParameter param : params) {
            if (param.isOptional() || this.shape.hasProperty(param.getPredicate())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return SPINLabels.get().getLabel(this.getShapeResource());
    }
}

