/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.http.undertow;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.XnioByteBufferPool;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pool;
import org.xnio.channels.StreamSourceChannel;

public abstract class ByteReadChannelListener
implements ChannelListener<StreamSourceChannel> {
    private final ByteArrayOutputStream string = new ByteArrayOutputStream();
    private final ByteBufferPool bufferPool;

    public ByteReadChannelListener(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    @Deprecated
    public ByteReadChannelListener(Pool<ByteBuffer> bufferPool) {
        this.bufferPool = new XnioByteBufferPool(bufferPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(StreamSourceChannel channel) {
        PooledByteBuffer resource = this.bufferPool.allocate();
        ByteBuffer buffer = resource.getBuffer();
        try {
            int r = 0;
            do {
                if ((r = channel.read(buffer)) == 0) {
                    channel.getReadSetter().set((ChannelListener)this);
                    channel.resumeReads();
                    continue;
                }
                if (r == -1) {
                    this.bytesDone(this.string.toByteArray());
                    IoUtils.safeClose((Closeable)channel);
                    continue;
                }
                buffer.flip();
                byte[] arr = new byte[buffer.remaining()];
                buffer.get(arr);
                this.string.write(arr);
            } while (r > 0);
        }
        catch (IOException e) {
            this.error(e);
        }
        finally {
            resource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(StreamSourceChannel channel) {
        PooledByteBuffer resource = this.bufferPool.allocate();
        ByteBuffer buffer = resource.getBuffer();
        try {
            int r = 0;
            do {
                if ((r = channel.read(buffer)) == 0) {
                    return;
                }
                if (r == -1) {
                    this.bytesDone(this.string.toByteArray());
                    IoUtils.safeClose((Closeable)channel);
                    continue;
                }
                buffer.flip();
                byte[] arr = new byte[buffer.remaining()];
                buffer.get(arr);
                this.string.write(arr);
            } while (r > 0);
        }
        catch (IOException e) {
            this.error(e);
        }
        finally {
            resource.close();
        }
    }

    protected abstract void bytesDone(byte[] var1);

    protected abstract void error(IOException var1);
}

