/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mulesoft.bat.APIs.Http$;
import com.mulesoft.bat.CLIArguments;
import com.mulesoft.bat.CLILogger$;
import com.mulesoft.bat.ConfigureCLIUrls$;
import com.mulesoft.bat.CredentialsProfile;
import com.mulesoft.bat.Token;
import com.mulesoft.bat.commands.BatPackageCommands$;
import com.mulesoft.bat.commands.BatWorkerCommands$;
import com.mulesoft.bat.lambda.Response;
import com.mulesoft.bat.types.CreatedSchedule;
import com.mulesoft.bat.types.CurrentWorker;
import com.mulesoft.bat.types.DumbExecution;
import com.mulesoft.bat.types.ExchangeDescriptor;
import com.mulesoft.bat.types.LoginResponse;
import com.mulesoft.bat.types.LoginResponseOrganizations;
import com.mulesoft.bat.types.Schedule;
import com.mulesoft.bat.types.Target;
import com.mulesoft.bat.types.ZipFile;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.util.UUID;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public final class CLIXAPI$ {
    public static CLIXAPI$ MODULE$;
    private String host;

    static {
        new CLIXAPI$();
    }

    public boolean removeSchedule(CLIArguments cfg, String organizationId, String suite, String scheduleId) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/tests/", "/schedules/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), organizationId, suite, scheduleId}));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DELETE ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Response response = Http$.MODULE$.delete(url, ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        return response.getStatus() == 200 || response.getStatus() == 201;
    }

    public boolean updateSchedule(CLIArguments cfg, String organizationId, Schedule schedule, boolean active) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/tests/", "/schedules/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), organizationId, schedule.suite(), schedule.id()}));
        scala.collection.immutable.Map body = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"organizationId"), (Object)organizationId.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupId"), (Object)schedule.groupId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assetId"), (Object)schedule.assetId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)schedule.version()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)schedule.targetId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"CRON_EXPRESSION"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)schedule.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cron"), (Object)schedule.cron()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)BoxesRunTime.boxToBoolean((boolean)active))}));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PUT ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Response response = Http$.MODULE$.putJson(url, (Object)body, ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        return response.getStatus() == 200;
    }

    public Option<Schedule> getSchedule(CLIArguments cfg, String organizationId, String scheduleId) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/schedules/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), organizationId, scheduleId}));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Response response = Http$.MODULE$.get(url, ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() != 200) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error getting schedule for id: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scheduleId})));
        }
        return (Option)Http$.MODULE$.parseResponseJson(response, (TypeReference)new TypeReference<Option<Schedule>>(){});
    }

    public Seq<Schedule> getSchedules(CLIArguments cfg, String organizationId, Option<String> suite) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = suite.isDefined() ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/tests/", "/schedules"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), organizationId, suite.get()})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/schedules"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), organizationId}));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Response response = Http$.MODULE$.get(url, ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() != 200) {
            throw new Exception("Error getting schedules");
        }
        return (Seq)Http$.MODULE$.parseResponseJson(response, (TypeReference)new TypeReference<Seq<Schedule>>(){});
    }

    public Option<String> getSchedules$default$3() {
        return None$.MODULE$;
    }

    public String host() {
        return this.host;
    }

    public void host_$eq(String x$1) {
        this.host = x$1;
    }

    public String createDumbTarget(CLIArguments cfg, String organizationId, String name, String machineId) {
        String entity;
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/targets"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), organizationId}));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"POST ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Response response = Http$.MODULE$.postJson(url, (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"machineId"), (Object)machineId)})), ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() == 200 || response.getStatus() == 201) {
            entity = (String)Http$.MODULE$.mapper().readValue(response.getContent(), String.class);
            Try result = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> UUID.fromString(entity));
            if (!result.isSuccess()) {
                throw new Exception("Invalid response: " + response.toString());
            }
        } else {
            throw new Exception("Error registering target");
        }
        return entity;
    }

    public void uploadZip(CLIArguments cfg, ZipFile zip) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        CLILogger$.MODULE$.logInfo(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# Uploading ", ":", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zip.descriptor().groupId(), zip.descriptor().assetId(), zip.descriptor().version()})));
        String organizationId = (String)profile.organization().getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)zip.descriptor().groupUUID().map((Function1 & Serializable & scala.Serializable)x -> x.toString()).orNull(Predef$.MODULE$.$conforms()));
        Predef$.MODULE$.require(organizationId != null, (Function0 & Serializable & scala.Serializable)() -> "Cannot resolve organizationId for the current folder/profile");
        if (zip.descriptor().groupUUID().isDefined()) {
            String string = ((UUID)zip.descriptor().groupUUID().get()).toString();
            String string2 = organizationId;
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exchange.json::groupId contains a different organizationId than the current worker profile. (", " vs ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zip.descriptor().groupUUID().get(), organizationId})));
        }
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/assets/", "/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), organizationId, zip.descriptor().groupId(), zip.descriptor().assetId(), zip.descriptor().version()}));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"POST ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Response response = Http$.MODULE$.httpLink().upload(new URL(url), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"file"), (Object)Files.readAllBytes(zip.file().toPath()))}))).asJava(), ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        String entity = cfg.debug() ? new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps((char[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(response.getContent())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToCharacter((char)CLIXAPI$.$anonfun$uploadZip$5(BoxesRunTime.unboxToByte((Object)x$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Char())))).mkString() : "";
        int n = response.getStatus();
        switch (n) {
            case 200: 
            case 201: {
                CLILogger$.MODULE$.logInfo(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# Version ", " published"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zip.descriptor().version()})));
                break;
            }
            case 400: {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid request (missing zip file, file is not zip, malformed or missing `exchange.json` file, etc.)"})).s((Seq)Nil$.MODULE$));
            }
            case 401: {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unauthorized"})).s((Seq)Nil$.MODULE$));
            }
            case 409: {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"An asset with that group:asset:version already exists"})).s((Seq)Nil$.MODULE$));
            }
            default: {
                throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Zip asset could not be uploaded, status: ", ". ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), entity})));
            }
        }
    }

    public Seq<Target> getTargets(CLIArguments cfg, String organizationId) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/targets"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), organizationId}));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Response response = Http$.MODULE$.httpLink().get(new URL(url), ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() != 200 && response.getStatus() != 201) {
            throw new Exception("Error getting target list");
        }
        return (Seq)Http$.MODULE$.parseResponseJson(response, (TypeReference)new TypeReference<Seq<Target>>(){});
    }

    public CreatedSchedule scheduleTest(CLIArguments cfg, ExchangeDescriptor descriptor, String organizationId, String cron) {
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        Seq targets = (Seq)this.getTargets(cfg, organizationId).filter((Function1 & Serializable & scala.Serializable)$ -> BoxesRunTime.boxToBoolean((boolean)CLIXAPI$.$anonfun$scheduleTest$1($)));
        Target target = (Target)cfg.target().map((Function1 & Serializable & scala.Serializable)desiredTarget -> (Target)targets.find((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)CLIXAPI$.$anonfun$scheduleTest$3(desiredTarget, x))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find a target that matches '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desiredTarget})));
        })).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Target)targets.find((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)CLIXAPI$.$anonfun$scheduleTest$6(x))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Target)targets.headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Error("Could not find a suitable target");
        })));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# ", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{target.name(), target.transport()})));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"target: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{target.id()})));
        scala.collection.immutable.Map body = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"organizationId"), (Object)organizationId.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configurationId"), (Object)cfg.env()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupId"), (Object)descriptor.groupId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assetId"), (Object)descriptor.assetId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)descriptor.version()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)target.id()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"CRON_EXPRESSION"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)cron), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cron"), (Object)cron)}));
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/tests/", ":", "/schedules"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), organizationId.toString(), descriptor.groupId(), descriptor.assetId()}));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"POST ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Response response = Http$.MODULE$.postJson(url, (Object)body, ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() != 200 && response.getStatus() != 201) {
            throw new Exception("Error scheduling the test");
        }
        return (CreatedSchedule)Http$.MODULE$.parseResponseJson(response, CreatedSchedule.class);
    }

    public Option<DumbExecution> createLocalExecution(CLIArguments cfg) {
        ExchangeDescriptor descriptor = BatPackageCommands$.MODULE$.getExchangeDescriptor(cfg);
        descriptor.ensureValidGAV();
        CredentialsProfile profile = cfg.ensureCredentialsProfile();
        CurrentWorker target = BatWorkerCommands$.MODULE$.ensureCurrentWorker(cfg);
        if (descriptor.groupUUID().isDefined()) {
            String string = ((UUID)descriptor.groupUUID().get()).toString();
            String string2 = target.organizationId();
            Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exchange.json::groupId contains a different organizationId than the current worker profile. (", " vs ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{descriptor.groupUUID().get(), target.organizationId()})));
        }
        scala.collection.immutable.Map body = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"groupId"), (Object)descriptor.groupId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assetId"), (Object)descriptor.assetId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)descriptor.version()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"configurationId"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetId"), (Object)target.targetId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scheduleId"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"artifactId"), null)}));
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/executions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host(), target.organizationId()}));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"POST ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Response response = Http$.MODULE$.postJson(url, (Object)body, ((Token)profile.token().get()).token());
        CLILogger$.MODULE$.logDebug(response);
        if (response.getStatus() != 200 && response.getStatus() != 201) {
            throw new Exception("Error registering execution");
        }
        return Http$.MODULE$.parseJson(response.getContent(), DumbExecution.class);
    }

    public Token login(CLIArguments cfg, CredentialsProfile profile) {
        if (profile.isValid()) {
            return (Token)profile.token().get();
        }
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(profile.username())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Username is empty");
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(profile.password())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Password is empty");
        ConfigureCLIUrls$.MODULE$.configureWithCoreServices(profile.host());
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/auth/login"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.host()}));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to login"})).s((Seq)Nil$.MODULE$));
        CLILogger$.MODULE$.logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"POST ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Option option = Option$.MODULE$.apply((Object)Http$.MODULE$.postJson(url, (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"username"), (Object)profile.username()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"password"), (Object)profile.password())})), Http$.MODULE$.postJson$default$3()));
        if (None$.MODULE$.equals(option)) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Login with credentials failed."})).s((Seq)Nil$.MODULE$));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Response r = (Response)some.value();
            CLILogger$.MODULE$.logDebug(r);
            int n = r.getStatus();
            switch (n) {
                case 200: 
                case 201: {
                    LoginResponse x = (LoginResponse)Http$.MODULE$.parseResponseJson(r, LoginResponse.class);
                    profile.token_$eq((Option<Token>)new Some((Object)new Token(x.token(), System.currentTimeMillis() / 1000L)));
                    if (profile.organization().isEmpty() && x.organizationId().nonEmpty()) {
                        profile.organization_$eq(x.organizationId());
                    } else if (profile.organization().isEmpty() && x.organizations().nonEmpty()) {
                        profile.organization_$eq((Option<String>)new Some((Object)((LoginResponseOrganizations)x.organizations().head()).id()));
                    }
                    profile.updateProfile();
                    break;
                }
                case 401: {
                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"401 Unauthorized"})).s((Seq)Nil$.MODULE$));
                }
                default: {
                    throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Login failed. Status ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
                }
            }
        } else {
            throw new MatchError((Object)option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        if (profile.token().isEmpty()) {
            throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid token"})).s((Seq)Nil$.MODULE$));
        }
        return (Token)profile.token().get();
    }

    public static final /* synthetic */ char $anonfun$uploadZip$5(byte x$1) {
        return (char)x$1;
    }

    public static final /* synthetic */ boolean $anonfun$scheduleTest$1(Target $) {
        String string = $.transport();
        String string2 = "DUMB";
        return string == null ? string2 != null : !string.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$scheduleTest$3(String desiredTarget$1, Target x) {
        String string = x.name();
        String string2 = desiredTarget$1;
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = x.id();
        String string4 = desiredTarget$1;
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$scheduleTest$6(Target x) {
        return x.organizationId().isEmpty() || x.organizationId() == new Some((Object)"public");
    }

    private CLIXAPI$() {
        MODULE$ = this;
        this.host = "https://bat-cli-xapi.cloudhub.io";
    }
}

