/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.jena.atlas.lib.tuple.TupleMap;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.mem.OrderedTupleTable;
import org.apache.jena.sparql.core.mem.TupleTable;
import org.slf4j.Logger;

public abstract class PMapTupleTable<TupleMapType, TupleType, ConsumerType>
extends OrderedTupleTable<TupleType, ConsumerType>
implements TupleTable<TupleType> {
    private final AtomicReference<TupleMapType> master = new AtomicReference<TupleMapType>(this.initial());
    private final ThreadLocal<TupleMapType> local = ThreadLocal.withInitial(() -> null);
    private final String tableName;

    protected abstract TupleMapType initial();

    protected AtomicReference<TupleMapType> master() {
        return this.master;
    }

    protected ThreadLocal<TupleMapType> local() {
        return this.local;
    }

    public PMapTupleTable(String n, TupleMap order) {
        super(order);
        this.tableName = n;
    }

    protected abstract Logger log();

    protected void debug(String msg, Object ... values) {
        if (this.log().isDebugEnabled()) {
            this.log().debug(this.tableName + ": " + msg, values);
        }
    }

    @Override
    public void begin(ReadWrite rw) {
        this.local.set(this.master().get());
    }

    @Override
    public void end() {
        this.debug("Abandoning transactional reference.", new Object[0]);
        this.local.remove();
    }

    @Override
    public void commit() {
        this.debug("Swapping transactional reference in for shared reference", new Object[0]);
        this.master().set(this.local.get());
        this.end();
    }

    @Override
    public void clear() {
        this.local().set(this.initial());
    }

    protected boolean isConcrete(Node n) {
        return n != null && n.isConcrete();
    }
}

