/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.iterator;

import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryIterUnion
extends QueryIterRepeatApply {
    protected List<Op> subOps;

    public QueryIterUnion(QueryIterator input, List<Op> subOps, ExecutionContext context) {
        super(input, context);
        this.subOps = subOps;
    }

    @Override
    protected QueryIterator nextStage(Binding binding) {
        QueryIterConcat unionQIter = new QueryIterConcat(this.getExecContext());
        for (Op subOp : this.subOps) {
            subOp = QC.substitute(subOp, binding);
            QueryIterSingleton parent = QueryIterSingleton.create(binding, this.getExecContext());
            QueryIterator qIter = QC.execute(subOp, parent, this.getExecContext());
            unionQIter.add(qIter);
        }
        return unionQIter;
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println(Lib.className((Object)this));
        out.incIndent();
        for (Op op : this.subOps) {
            op.output(out, sCxt);
        }
        out.decIndent();
        out.ensureStartOfLine();
    }
}

