/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.arq.SHACLFunctionDriver;
import org.topbraid.shacl.model.SHConstraintComponent;
import org.topbraid.shacl.model.SHFactory;
import org.topbraid.shacl.model.SHNodeShape;
import org.topbraid.shacl.model.SHParameter;
import org.topbraid.shacl.model.SHParameterizableTarget;
import org.topbraid.shacl.model.SHPropertyShape;
import org.topbraid.shacl.model.SHResult;
import org.topbraid.shacl.validation.ConstraintExecutors;
import org.topbraid.shacl.validation.TargetPlugin;
import org.topbraid.shacl.validation.TargetPlugins;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.OntologyOptimizations;
import org.topbraid.spin.util.OptimizedMultiUnion;

public class SHACLUtil {
    public static final Resource[] RESULT_TYPES = new Resource[]{DASH.FailureResult, DASH.SuccessResult, SH.ValidationResult};
    public static final String SHAPES_FILE_PART = ".shapes.";
    public static final String URN_X_SHACL = "urn:x-shacl:";
    private static final Set<Property> SPARQL_PROPERTIES = new HashSet<Property>();
    private static final Set<Resource> classesWithDefaultType;
    private static Query propertyLabelQuery;
    private static boolean jsPreferred;

    public static void addDirectPropertiesOfClass(Resource cls, Collection<Property> results) {
        Resource predicate;
        for (Resource argument : JenaUtil.getResourceProperties(cls, SH.parameter)) {
            predicate = JenaUtil.getPropertyResourceValue(argument, SH.path);
            if (predicate == null || !predicate.isURIResource() || results.contains(predicate)) continue;
            results.add(JenaUtil.asProperty(predicate));
        }
        for (Resource property : JenaUtil.getResourceProperties(cls, SH.property)) {
            predicate = JenaUtil.getPropertyResourceValue(property, SH.path);
            if (predicate == null || !predicate.isURIResource() || results.contains(predicate)) continue;
            results.add(JenaUtil.asProperty(predicate));
        }
    }

    private static void addIncludes(Graph model, String uri, Set<Graph> graphs, Set<String> reachedURIs) {
        graphs.add(model);
        reachedURIs.add(uri);
        for (Triple t : model.find(null, OWL.imports.asNode(), null).toList()) {
            Model includeModel;
            String includeURI;
            if (!t.getObject().isURI() || reachedURIs.contains(includeURI = t.getObject().getURI()) || (includeModel = ARQFactory.getNamedModel(includeURI)) == null) continue;
            Graph includeGraph = includeModel.getGraph();
            SHACLUtil.addIncludes(includeGraph, includeURI, graphs, reachedURIs);
        }
    }

    public static void addNodesInTarget(Resource target, Dataset dataset, Set<Node> results) {
        for (RDFNode focusNode : SHACLUtil.getResourcesInTarget(target, dataset)) {
            results.add(focusNode.asNode());
        }
    }

    public static Model createIncludesModel(Model model, String graphURI) {
        HashSet<Graph> graphs = new HashSet<Graph>();
        Graph baseGraph = model.getGraph();
        SHACLUtil.addIncludes(baseGraph, graphURI, graphs, new HashSet<String>());
        if (graphs.size() == 1) {
            return model;
        }
        MultiUnion union = new MultiUnion(graphs.iterator());
        union.setBaseGraph(baseGraph);
        return ModelFactory.createModelForGraph((Graph)union);
    }

    public static Set<Node> getAllFocusNodes(Dataset dataset, boolean validateShapes) {
        Property predicate;
        HashSet<Node> results = new HashSet<Node>();
        Model model = dataset.getDefaultModel();
        for (Resource shape : JenaUtil.getAllInstances(SH.Shape.inModel(model))) {
            if (!JenaUtil.hasIndirectType(shape, RDFS.Class)) continue;
            for (Resource instance : JenaUtil.getAllInstances(shape)) {
                results.add(instance.asNode());
            }
        }
        for (Statement s : model.listStatements(null, SH.targetClass, (RDFNode)null).toList()) {
            if (!s.getObject().isResource() || !validateShapes && (JenaUtil.hasIndirectType(s.getSubject(), SH.ConstraintComponent) || SH.PropertyShape.equals((Object)s.getObject()) || SH.Constraint.equals((Object)s.getObject()))) continue;
            for (Resource instance : JenaUtil.getAllInstances(s.getResource())) {
                results.add(instance.asNode());
            }
        }
        for (Statement s : model.listStatements(null, SH.targetNode, (RDFNode)null).toList()) {
            results.add(s.getObject().asNode());
        }
        for (Statement s : model.listStatements(null, SH.target, (RDFNode)null).toList()) {
            if (!s.getObject().isResource()) continue;
            Resource target = s.getResource();
            for (RDFNode focusNode : SHACLUtil.getResourcesInTarget(target, dataset)) {
                results.add(focusNode.asNode());
            }
        }
        for (RDFNode property : model.listObjectsOfProperty(SH.targetObjectsOf).toList()) {
            if (!property.isURIResource()) continue;
            predicate = JenaUtil.asProperty((Resource)property);
            for (RDFNode focusNode : model.listObjectsOfProperty(predicate).toList()) {
                results.add(focusNode.asNode());
            }
        }
        for (RDFNode property : model.listObjectsOfProperty(SH.targetSubjectsOf).toList()) {
            if (!property.isURIResource()) continue;
            predicate = JenaUtil.asProperty((Resource)property);
            for (RDFNode focusNode : model.listSubjectsWithProperty(predicate).toList()) {
                results.add(focusNode.asNode());
            }
        }
        return results;
    }

    public static List<SHResult> getAllTopLevelResults(Model model) {
        LinkedList<SHResult> results = new LinkedList<SHResult>();
        for (Resource type : RESULT_TYPES) {
            for (Resource r : model.listResourcesWithProperty(RDF.type, (RDFNode)type).toList()) {
                if (model.contains(null, SH.detail, (RDFNode)r)) continue;
                results.add((SHResult)r.as(SHResult.class));
            }
        }
        return results;
    }

    public static Set<Resource> getAllSuperClassesAndShapesStar(Resource cls) {
        HashSet<Resource> results = new HashSet<Resource>();
        SHACLUtil.getAllSuperClassesAndShapesStarHelper(cls, results);
        return results;
    }

    private static void getAllSuperClassesAndShapesStarHelper(Resource node, Set<Resource> results) {
        if (!results.contains(node)) {
            results.add(node);
            StmtIterator it = node.listProperties(RDFS.subClassOf);
            while (it.hasNext()) {
                Statement s = (Statement)it.next();
                if (!s.getObject().isResource()) continue;
                SHACLUtil.getAllSuperClassesAndShapesStarHelper(s.getResource(), results);
            }
            it = node.getModel().listStatements(null, SH.targetClass, (RDFNode)node);
            while (it.hasNext()) {
                SHACLUtil.getAllSuperClassesAndShapesStarHelper(((Statement)it.next()).getSubject(), results);
            }
        }
    }

    public static SHConstraintComponent getConstraintComponentOfValidator(Resource validator) {
        for (Statement s : validator.getModel().listStatements(null, null, (RDFNode)validator).toList()) {
            if (!SH.validator.equals(s.getPredicate()) && !SH.nodeValidator.equals(s.getPredicate()) && !SH.propertyValidator.equals(s.getPredicate())) continue;
            return (SHConstraintComponent)s.getSubject().as(SHConstraintComponent.class);
        }
        return null;
    }

    public static Resource getDefaultTypeForConstraintPredicate(Property predicate) {
        if (SH.property.equals(predicate)) {
            return SH.PropertyShape;
        }
        if (SH.parameter.equals(predicate)) {
            return SH.Parameter;
        }
        throw new IllegalArgumentException();
    }

    public static SHParameter getParameterAtClass(Resource cls, Property predicate) {
        for (Resource c : JenaUtil.getAllSuperClassesStar(cls)) {
            for (Resource arg : JenaUtil.getResourceProperties(c, SH.parameter)) {
                if (!arg.hasProperty(SH.path, (RDFNode)predicate)) continue;
                return SHFactory.asParameter((RDFNode)arg);
            }
        }
        return null;
    }

    public static SHParameter getParameterAtInstance(Resource instance, Property predicate) {
        for (Resource type : JenaUtil.getTypes(instance)) {
            SHParameter argument = SHACLUtil.getParameterAtClass(type, predicate);
            if (argument == null) continue;
            return argument;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resource getResourceDefaultType(Resource resource) {
        try (StmtIterator it = resource.getModel().listStatements(null, null, (RDFNode)resource);){
            while (it.hasNext()) {
                Statement s = (Statement)it.next();
                Resource defaultValueType = JenaUtil.getResourceProperty((Resource)s.getPredicate(), DASH.defaultValueType);
                if (defaultValueType == null) continue;
                Resource resource2 = defaultValueType;
                return resource2;
            }
        }
        return null;
    }

    public static String getLocalPropertyLabel(Resource property, Resource context) {
        QuerySolutionMap binding = new QuerySolutionMap();
        binding.add("arg1", (RDFNode)property);
        binding.add("arg2", (RDFNode)context);
        try (QueryExecution qexec = ARQFactory.get().createQueryExecution(propertyLabelQuery, property.getModel(), (QuerySolution)binding);){
            ResultSet rs = qexec.execSelect();
            if (rs.hasNext()) {
                String string = rs.next().get("label").asLiteral().getLexicalForm();
                return string;
            }
        }
        return null;
    }

    public static SHPropertyShape getPropertyConstraintAtClass(Resource cls, Property predicate) {
        for (Resource c : JenaUtil.getAllSuperClassesStar(cls)) {
            for (Resource arg : JenaUtil.getResourceProperties(c, SH.property)) {
                if (!arg.hasProperty(SH.path, (RDFNode)predicate)) continue;
                return SHFactory.asPropertyShape((RDFNode)arg);
            }
        }
        return null;
    }

    public static SHPropertyShape getPropertyConstraintAtInstance(Resource instance, Property predicate) {
        for (Resource type : JenaUtil.getTypes(instance)) {
            SHPropertyShape property = SHACLUtil.getPropertyConstraintAtClass(type, predicate);
            if (property == null) continue;
            return property;
        }
        return null;
    }

    public static List<Property> getAllPropertiesOfClass(Resource cls) {
        LinkedList<Property> results = new LinkedList<Property>();
        for (Resource c : SHACLUtil.getAllSuperClassesAndShapesStar(cls)) {
            SHACLUtil.addDirectPropertiesOfClass(c, results);
        }
        return results;
    }

    public static Iterable<RDFNode> getResourcesInTarget(Resource target, Dataset dataset) {
        Resource executable;
        Resource type = JenaUtil.getType(target);
        SHParameterizableTarget parameterizableTarget = null;
        if (SHFactory.isParameterizableInstance((RDFNode)target)) {
            executable = type;
            parameterizableTarget = SHFactory.asParameterizableTarget((RDFNode)target);
        } else {
            executable = target;
        }
        TargetPlugin plugin = TargetPlugins.get().getLanguageForTarget(executable);
        if (plugin != null) {
            return plugin.executeTarget(dataset, executable, parameterizableTarget);
        }
        return new ArrayList<RDFNode>();
    }

    public static List<SHNodeShape> getAllShapesAtNode(RDFNode node) {
        return SHACLUtil.getAllShapesAtNode(node, node instanceof Resource ? JenaUtil.getTypes((Resource)node) : null);
    }

    public static List<SHNodeShape> getAllShapesAtNode(RDFNode node, Iterable<Resource> types) {
        LinkedList<SHNodeShape> results = new LinkedList<SHNodeShape>();
        if (node instanceof Resource) {
            HashSet<Resource> reached = new HashSet<Resource>();
            for (Resource type : types) {
                SHACLUtil.addAllShapesAtClassOrShape(type, results, reached);
            }
        }
        return results;
    }

    public static List<SHNodeShape> getAllShapesAtClassOrShape(Resource clsOrShape) {
        String key = OntologyOptimizations.get().getKeyIfEnabledFor(clsOrShape.getModel().getGraph());
        if (key != null) {
            key = key + ".getAllShapesAtClassOrShape(" + clsOrShape + ")";
            LinkedList<SHNodeShape> results = (LinkedList<SHNodeShape>)OntologyOptimizations.get().getObject(key);
            if (results == null) {
                results = new LinkedList<SHNodeShape>();
                SHACLUtil.addAllShapesAtClassOrShape(clsOrShape, results, new HashSet<Resource>());
                OntologyOptimizations.get().putObject(key, results);
            }
            return results;
        }
        LinkedList<SHNodeShape> results = new LinkedList<SHNodeShape>();
        SHACLUtil.addAllShapesAtClassOrShape(clsOrShape, results, new HashSet<Resource>());
        return results;
    }

    private static void addAllShapesAtClassOrShape(Resource clsOrShape, List<SHNodeShape> results, Set<Resource> reached) {
        SHACLUtil.addDirectShapesAtClassOrShape(clsOrShape, results);
        reached.add(clsOrShape);
        for (Resource superClass : JenaUtil.getSuperClasses(clsOrShape)) {
            if (reached.contains(superClass)) continue;
            SHACLUtil.addAllShapesAtClassOrShape(superClass, results, reached);
        }
    }

    public static Collection<SHNodeShape> getDirectShapesAtClassOrShape(Resource clsOrShape) {
        LinkedList<SHNodeShape> results = new LinkedList<SHNodeShape>();
        SHACLUtil.addDirectShapesAtClassOrShape(clsOrShape, results);
        return results;
    }

    private static void addDirectShapesAtClassOrShape(Resource clsOrShape, List<SHNodeShape> results) {
        SHNodeShape shape;
        if (JenaUtil.hasIndirectType(clsOrShape, SH.Shape) && !results.contains(clsOrShape) && !(shape = SHFactory.asNodeShape((RDFNode)clsOrShape)).isDeactivated()) {
            results.add(shape);
        }
        StmtIterator it = clsOrShape.getModel().listStatements(null, SH.targetClass, (RDFNode)clsOrShape);
        while (it.hasNext()) {
            SHNodeShape shape2;
            Resource subject = ((Statement)it.next()).getSubject();
            if (results.contains(subject) || (shape2 = SHFactory.asNodeShape((RDFNode)subject)).isDeactivated()) continue;
            results.add(shape2);
        }
    }

    public static List<RDFNode> getTargetNodes(Resource shape, Dataset dataset) {
        Model dataModel = dataset.getDefaultModel();
        HashSet<Object> results = new HashSet<Object>();
        if (JenaUtil.hasIndirectType(shape, RDFS.Class)) {
            results.addAll(JenaUtil.getAllInstances(shape.inModel(dataModel)));
        }
        for (Resource targetClass : JenaUtil.getResourceProperties(shape, SH.targetClass)) {
            results.addAll(JenaUtil.getAllInstances(targetClass.inModel(dataModel)));
        }
        for (RDFNode targetNode : shape.getModel().listObjectsOfProperty(shape, SH.targetNode).toList()) {
            results.add(targetNode.inModel(dataModel));
        }
        for (Resource sof : JenaUtil.getResourceProperties(shape, SH.targetSubjectsOf)) {
            for (Statement s : dataModel.listStatements(null, JenaUtil.asProperty(sof), (RDFNode)null).toList()) {
                results.add(s.getSubject());
            }
        }
        for (Resource sof : JenaUtil.getResourceProperties(shape, SH.targetObjectsOf)) {
            for (Statement s : dataModel.listStatements(null, JenaUtil.asProperty(sof), (RDFNode)null).toList()) {
                results.add(s.getObject());
            }
        }
        for (Resource target : JenaUtil.getResourceProperties(shape, SH.target)) {
            for (RDFNode targetNode : SHACLUtil.getResourcesInTarget(target, dataset)) {
                results.add(targetNode);
            }
        }
        return new ArrayList<RDFNode>(results);
    }

    public static List<Resource> getTypes(Resource subject) {
        Resource defaultType;
        List<Resource> types = JenaUtil.getTypes(subject);
        if (types.isEmpty() && (defaultType = SHACLUtil.getResourceDefaultType(subject)) != null) {
            return Collections.singletonList(defaultType);
        }
        return types;
    }

    public static boolean hasMinSeverity(Resource severity, Resource minSeverity) {
        if (minSeverity == null || SH.Info.equals((Object)minSeverity)) {
            return true;
        }
        if (SH.Warning.equals((Object)minSeverity)) {
            return !SH.Info.equals((Object)severity);
        }
        return SH.Violation.equals((Object)severity);
    }

    public static boolean isClassWithDefaultType(Resource cls) {
        return classesWithDefaultType.contains(cls);
    }

    public static boolean isParameterAtInstance(Resource subject, Property predicate) {
        for (Resource type : SHACLUtil.getTypes(subject)) {
            SHParameter arg = SHACLUtil.getParameterAtClass(type, predicate);
            if (arg == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isSPARQLProperty(Property property) {
        return SPARQL_PROPERTIES.contains(property);
    }

    public static boolean exists(Model model) {
        return model != null && SHACLUtil.exists(model.getGraph());
    }

    public static boolean exists(Graph graph) {
        if (graph instanceof OptimizedMultiUnion) {
            return ((OptimizedMultiUnion)graph).getIncludesSHACL();
        }
        return graph != null && "http://www.w3.org/ns/shacl#".equals(graph.getPrefixMapping().getNsPrefixURI("sh")) && graph.contains(SH.Shape.asNode(), RDF.type.asNode(), Node.ANY);
    }

    public static Model withDefaultValueTypeInferences(Model model) {
        return ModelFactory.createModelForGraph((Graph)new MultiUnion(new Graph[]{model.getGraph(), DASH.createDefaultValueTypesModel(model).getGraph()}));
    }

    public static URI withShapesGraph(Dataset dataset) {
        URI shapesGraphURI = URI.create(URN_X_SHACL + UUID.randomUUID());
        Model shapesModel = SHACLUtil.createShapesModel(dataset);
        dataset.addNamedModel(shapesGraphURI.toString(), shapesModel);
        return shapesGraphURI;
    }

    private static Model createShapesModel(Dataset dataset) {
        Model model = dataset.getDefaultModel();
        HashSet<Graph> graphs = new HashSet<Graph>();
        Graph baseGraph = model.getGraph();
        graphs.add(baseGraph);
        for (Statement s : model.listStatements(null, SH.shapesGraph, (RDFNode)null).toList()) {
            if (!s.getObject().isURIResource()) continue;
            String graphURI = s.getResource().getURI();
            Model sm = dataset.getNamedModel(graphURI);
            graphs.add(sm.getGraph());
        }
        if (graphs.size() > 1) {
            MultiUnion union = new MultiUnion(graphs.iterator());
            union.setBaseGraph(baseGraph);
            return ModelFactory.createModelForGraph((Graph)union);
        }
        return model;
    }

    public static boolean isInTarget(RDFNode focusNode, Dataset dataset, Resource target) {
        TargetPlugin plugin;
        SHParameterizableTarget parameterizableTarget = null;
        Resource executable = target;
        if (SHFactory.isParameterizableInstance((RDFNode)target)) {
            parameterizableTarget = SHFactory.asParameterizableTarget((RDFNode)target);
            executable = parameterizableTarget.getParameterizable();
        }
        if ((plugin = TargetPlugins.get().getLanguageForTarget(executable)) != null) {
            return plugin.isNodeInTarget(focusNode, dataset, executable, parameterizableTarget);
        }
        return false;
    }

    public static boolean isJSPreferred() {
        return jsPreferred;
    }

    public static void setJSPreferred(boolean value) {
        jsPreferred = value;
        ConstraintExecutors.get().setJSPreferred(value);
        SHACLFunctionDriver.setJSPreferred(value);
        TargetPlugins.get().setJSPreferred(value);
    }

    static {
        SPARQL_PROPERTIES.add(SH.ask);
        SPARQL_PROPERTIES.add(SH.construct);
        SPARQL_PROPERTIES.add(SH.select);
        SPARQL_PROPERTIES.add(SH.update);
        classesWithDefaultType = new HashSet<Resource>();
        classesWithDefaultType.add(SH.NodeShape);
        classesWithDefaultType.add(SH.Parameter);
        classesWithDefaultType.add(SH.PropertyShape);
        classesWithDefaultType.add(SH.SPARQLConstraint);
        propertyLabelQuery = ARQFactory.get().createQuery("PREFIX rdfs: <" + RDFS.getURI() + ">\nPREFIX sh: <" + "http://www.w3.org/ns/shacl#" + ">\nSELECT ?label\nWHERE {\n    ?arg2 a ?type .\n    ?type rdfs:subClassOf* ?class .\n    ?shape <" + SH.targetClass + ">* ?class .\n    ?shape <" + SH.property + ">|<" + SH.parameter + "> ?p .\n    ?p <" + SH.path + "> ?arg1 .\n    ?p rdfs:label ?label .\n}");
    }
}

