/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TranslationTable<X> {
    Map<String, X> map = new HashMap<String, X>();
    boolean ignoreCase = false;

    public TranslationTable() {
        this(false);
    }

    public TranslationTable(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public X lookup(String name) {
        if (name == null) {
            return null;
        }
        for (Map.Entry<String, X> entry : this.map.entrySet()) {
            String k = entry.getKey();
            if (!(this.ignoreCase ? k.equalsIgnoreCase(name) : k.equals(name))) continue;
            return entry.getValue();
        }
        return null;
    }

    public void put(String k, X v) {
        this.map.put(k, v);
    }

    public Iterator<String> keys() {
        return this.map.keySet().iterator();
    }

    public Iterator<X> values() {
        return this.map.values().iterator();
    }
}

