/*
 * Decompiled with CFR 0.152.
 */
package spire.math.prime;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.prime.BitSet;
import spire.math.prime.BitSet$;
import spire.math.prime.FactorHeap;
import spire.math.prime.SieveSegment;
import spire.math.prime.SieveUtil;
import spire.math.prime.SieveUtil$FastFactors$;
import spire.math.prime.Siever$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0001\u0003\u0001&\u0011aaU5fm\u0016\u0014(BA\u0002\u0005\u0003\u0015\u0001(/[7f\u0015\t)a!\u0001\u0003nCRD'\"A\u0004\u0002\u000bM\u0004\u0018N]3\u0004\u0001M!\u0001A\u0003\t\u0014!\tYa\"D\u0001\r\u0015\u0005i\u0011!B:dC2\f\u0017BA\b\r\u0005\u0019\te.\u001f*fMB\u00111\"E\u0005\u0003%1\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\f)%\u0011Q\u0003\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t/\u0001\u0011)\u001a!C\u00011\u0005I1\r[;oWNK'0Z\u000b\u00023A\u00111BG\u0005\u000371\u00111!\u00138u\u0011!i\u0002A!E!\u0002\u0013I\u0012AC2ik:\\7+\u001b>fA!Aq\u0004\u0001BK\u0002\u0013\u0005\u0001%\u0001\u0004dkR|gMZ\u000b\u0002CA\u0011!eI\u0007\u0002\t%\u0011A\u0005\u0002\u0002\t'\u00064W\rT8oO\"Aa\u0005\u0001B\tB\u0003%\u0011%A\u0004dkR|gM\u001a\u0011\t\u000b!\u0002A\u0011A\u0015\u0002\rqJg.\u001b;?)\rQC&\f\t\u0003W\u0001i\u0011A\u0001\u0005\u0006/\u001d\u0002\r!\u0007\u0005\u0006?\u001d\u0002\r!\t\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0003\r\t'O]\u000b\u0002cA\u00111FM\u0005\u0003g\t\u0011aAQ5u'\u0016$\bBB\u001b\u0001A\u0003%\u0011'\u0001\u0003beJ\u0004\u0003bB\u001c\u0001\u0001\u0004%\t\u0001I\u0001\u0006gR\f'\u000f\u001e\u0005\bs\u0001\u0001\r\u0011\"\u0001;\u0003%\u0019H/\u0019:u?\u0012*\u0017\u000f\u0006\u0002<}A\u00111\u0002P\u0005\u0003{1\u0011A!\u00168ji\"9q\bOA\u0001\u0002\u0004\t\u0013a\u0001=%c!1\u0011\t\u0001Q!\n\u0005\naa\u001d;beR\u0004\u0003bB\"\u0001\u0001\u0004%\t\u0001I\u0001\u0006Y&l\u0017\u000e\u001e\u0005\b\u000b\u0002\u0001\r\u0011\"\u0001G\u0003%a\u0017.\\5u?\u0012*\u0017\u000f\u0006\u0002<\u000f\"9q\bRA\u0001\u0002\u0004\t\u0003BB%\u0001A\u0003&\u0011%\u0001\u0004mS6LG\u000f\t\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0003\u00151\u0017m\u001d;r+\u0005i\u0005C\u0001(R\u001d\tYs*\u0003\u0002Q\u0005\u0005I1+[3wKV#\u0018\u000e\\\u0005\u0003%N\u00131BR1ti\u001a\u000b7\r^8sg*\u0011\u0001K\u0001\u0005\u0007+\u0002\u0001\u000b\u0011B'\u0002\r\u0019\f7\u000f^9!\u0011\u001d9\u0006A1A\u0005\u0002a\u000bQa\u001d7poF,\u0012!\u0017\t\u0003WiK!a\u0017\u0002\u0003\u0015\u0019\u000b7\r^8s\u0011\u0016\f\u0007\u000f\u0003\u0004^\u0001\u0001\u0006I!W\u0001\u0007g2|w/\u001d\u0011\t\u000f}\u0003\u0001\u0019!C\u0001A\u0006)1/[3wKV\t\u0011\r\u0005\u0002,E&\u00111M\u0001\u0002\r'&,g/Z*fO6,g\u000e\u001e\u0005\bK\u0002\u0001\r\u0011\"\u0001g\u0003%\u0019\u0018.\u001a<f?\u0012*\u0017\u000f\u0006\u0002<O\"9q\bZA\u0001\u0002\u0004\t\u0007BB5\u0001A\u0003&\u0011-\u0001\u0004tS\u00164X\r\t\u0005\u0006W\u0002!\t\u0001\\\u0001\rY\u0006\u0014x-Z:u\u0005\u0016dwn\u001e\u000b\u0003C5DQA\u001c6A\u0002\u0005\n\u0011A\u001c\u0005\u0006a\u0002!\t!]\u0001\u0004]RDGCA\u0011s\u0011\u0015qw\u000e1\u0001t!\tYA/\u0003\u0002v\u0019\t!Aj\u001c8h\u0011\u00159\b\u0001\"\u0003y\u00035Ig.\u001b;OKb$8+[3wKR\t1\bC\u0003{\u0001\u0011\u000510A\u0005oKb$\u0018I\u001a;feR\u0011\u0011\u0005 \u0005\u0006]f\u0004\r!\t\u0005\u0006}\u0002!\ta`\u0001\fgR\u0014X-Y7BMR,'\u000f\u0006\u0003\u0002\u0002\u0005e\u0001#BA\u0002\u0003'\tc\u0002BA\u0003\u0003\u001fqA!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017A\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\r\t\t\u0002D\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)\"a\u0006\u0003\rM#(/Z1n\u0015\r\t\t\u0002\u0004\u0005\u0007\u00037i\b\u0019A\u0011\u0002\u0005A\u0004\u0004bBA\u0010\u0001\u0011\u0005\u0011\u0011E\u0001\bCJ\u0014\u0018-_!u)\u0019\t\u0019#!\u000b\u0002.A!1\"!\n\"\u0013\r\t9\u0003\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003W\ti\u00021\u0001\"\u0003\u0005\u0001\bbBA\u0018\u0003;\u0001\r!G\u0001\u0005g&TX\rC\u0005\u00024\u0001\t\t\u0011\"\u0001\u00026\u0005!1m\u001c9z)\u0015Q\u0013qGA\u001d\u0011!9\u0012\u0011\u0007I\u0001\u0002\u0004I\u0002\u0002C\u0010\u00022A\u0005\t\u0019A\u0011\t\u0013\u0005u\u0002!%A\u0005\u0002\u0005}\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0003R3!GA\"W\t\t)\u0005\u0005\u0003\u0002H\u0005ESBAA%\u0015\u0011\tY%!\u0014\u0002\u0013Ut7\r[3dW\u0016$'bAA(\u0019\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005M\u0013\u0011\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA,\u0001E\u0005I\u0011AA-\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0017+\u0007\u0005\n\u0019\u0005C\u0005\u0002`\u0001\t\t\u0011\"\u0011\u0002b\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0019\u0011\t\u0005\u0015\u0014qN\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005!A.\u00198h\u0015\t\ti'\u0001\u0003kCZ\f\u0017\u0002BA9\u0003O\u0012aa\u0015;sS:<\u0007\u0002CA;\u0001\u0005\u0005I\u0011\u0001\r\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\u0005e\u0004!!A\u0005\u0002\u0005m\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003{\n\u0019\tE\u0002\f\u0003\u007fJ1!!!\r\u0005\r\te.\u001f\u0005\t\u007f\u0005]\u0014\u0011!a\u00013!I\u0011q\u0011\u0001\u0002\u0002\u0013\u0005\u0013\u0011R\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0012\t\u0007\u0003\u001b\u000b\u0019*! \u000e\u0005\u0005=%bAAI\u0019\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0015q\u0012\u0002\t\u0013R,'/\u0019;pe\"I\u0011\u0011\u0014\u0001\u0002\u0002\u0013\u0005\u00111T\u0001\tG\u0006tW)];bYR!\u0011QTAR!\rY\u0011qT\u0005\u0004\u0003Cc!a\u0002\"p_2,\u0017M\u001c\u0005\n\u007f\u0005]\u0015\u0011!a\u0001\u0003{B\u0011\"a*\u0001\u0003\u0003%\t%!+\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012!\u0007\u0005\n\u0003[\u0003\u0011\u0011!C!\u0003_\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003GB\u0011\"a-\u0001\u0003\u0003%\t%!.\u0002\r\u0015\fX/\u00197t)\u0011\ti*a.\t\u0013}\n\t,!AA\u0002\u0005ut!CA^\u0005\u0005\u0005\t\u0012AA_\u0003\u0019\u0019\u0016.\u001a<feB\u00191&a0\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003\u0003\u001cR!a0\u0002DN\u0001r!!2\u0002Lf\t#&\u0004\u0002\u0002H*\u0019\u0011\u0011\u001a\u0007\u0002\u000fI,h\u000e^5nK&!\u0011QZAd\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bQ\u0005}F\u0011AAi)\t\ti\f\u0003\u0006\u0002.\u0006}\u0016\u0011!C#\u0003_C!\"a6\u0002@\u0006\u0005I\u0011QAm\u0003\u0015\t\u0007\u000f\u001d7z)\u0015Q\u00131\\Ao\u0011\u00199\u0012Q\u001ba\u00013!1q$!6A\u0002\u0005B!\"!9\u0002@\u0006\u0005I\u0011QAr\u0003\u001d)h.\u00199qYf$B!!:\u0002rB)1\"a:\u0002l&\u0019\u0011\u0011\u001e\u0007\u0003\r=\u0003H/[8o!\u0015Y\u0011Q^\r\"\u0013\r\ty\u000f\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005M\u0018q\\A\u0001\u0002\u0004Q\u0013a\u0001=%a!Q\u0011q_A`\u0003\u0003%I!!?\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003w\u0004B!!\u001a\u0002~&!\u0011q`A4\u0005\u0019y%M[3di\u0002")
public class Siever
implements Product,
scala.Serializable {
    private final int chunkSize;
    private final SafeLong cutoff;
    private final BitSet arr;
    private SafeLong start;
    private SafeLong limit;
    private final SieveUtil.FastFactors fastq;
    private final FactorHeap slowq;
    private SieveSegment sieve;

    public static Option<Tuple2<Object, SafeLong>> unapply(Siever siever) {
        return Siever$.MODULE$.unapply(siever);
    }

    public static Siever apply(int n, SafeLong safeLong) {
        return Siever$.MODULE$.apply(n, safeLong);
    }

    public static Function1<Tuple2<Object, SafeLong>, Siever> tupled() {
        return Siever$.MODULE$.tupled();
    }

    public static Function1<Object, Function1<SafeLong, Siever>> curried() {
        return Siever$.MODULE$.curried();
    }

    public int chunkSize() {
        return this.chunkSize;
    }

    public SafeLong cutoff() {
        return this.cutoff;
    }

    public BitSet arr() {
        return this.arr;
    }

    public SafeLong start() {
        return this.start;
    }

    public void start_$eq(SafeLong x$1) {
        this.start = x$1;
    }

    public SafeLong limit() {
        return this.limit;
    }

    public void limit_$eq(SafeLong x$1) {
        this.limit = x$1;
    }

    public SieveUtil.FastFactors fastq() {
        return this.fastq;
    }

    public FactorHeap slowq() {
        return this.slowq;
    }

    public SieveSegment sieve() {
        return this.sieve;
    }

    public void sieve_$eq(SieveSegment x$1) {
        this.sieve = x$1;
    }

    public SafeLong largestBelow(SafeLong n) {
        if (n.$less((Object)SafeLong$.MODULE$.apply(3L))) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("invalid argument: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        if (BoxesRunTime.equalsNumObject((Number)((Object)n), (Object)BoxesRunTime.boxToInteger((int)3))) {
            return SafeLong$.MODULE$.apply(2L);
        }
        int i = 3;
        SafeLong k = n.$minus(1L);
        SafeLong last = SafeLong$.MODULE$.apply(2L);
        while (true) {
            int i2;
            BitSet primes = this.sieve().primes();
            int len = primes.length();
            if (n.$minus(this.start()).$less((Object)SafeLong$.MODULE$.apply(len))) {
                int goal = n.$minus(this.start()).toInt();
                for (int i3 = 1; i3 < goal; i3 += 2) {
                    if (!primes.apply(i3)) continue;
                    last = this.start().$plus(i3);
                }
                return last;
            }
            for (i2 = len - 1; 1 <= i2 && !primes.apply(i2); i2 -= 2) {
            }
            if (1 <= i2) {
                last = this.start().$plus(i2);
            }
            this.initNextSieve();
            i = 1;
        }
    }

    public SafeLong nth(long n) {
        if (n == 1L) {
            return SafeLong$.MODULE$.apply(2L);
        }
        int i = 3;
        long k = n - 1L;
        while (true) {
            BitSet primes = this.sieve().primes();
            int len = primes.length();
            while (i < len) {
                if (primes.apply(i) && --k < 1L) {
                    return this.sieve().start().$plus(i);
                }
                i += 2;
            }
            this.initNextSieve();
            i = 1;
        }
    }

    private void initNextSieve() {
        this.start_$eq(this.start().$plus(this.chunkSize()));
        this.limit_$eq(this.limit().$plus(this.chunkSize()));
        SafeLong csq = this.cutoff().$times$times(2);
        if (this.limit().$greater$eq((Object)csq)) {
            throw package$.MODULE$.error(new StringOps(Predef$.MODULE$.augmentString("too big: %s > %s (%s)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.limit(), csq, this.cutoff()})));
        }
        this.arr().clear();
        this.sieve_$eq(new SieveSegment(this.start(), this.arr(), this.cutoff()));
        this.sieve().init(this.fastq(), this.slowq());
    }

    /*
     * WARNING - void declaration
     */
    public SafeLong nextAfter(SafeLong n) {
        void var2_2;
        SafeLong nn = this.sieve().nextAfter(n);
        while (BoxesRunTime.equalsNumObject((Number)((Object)nn), (Object)BoxesRunTime.boxToLong((long)-1L))) {
            this.initNextSieve();
            nn = this.sieve().nextAfter(this.start().$minus(1L));
        }
        return var2_2;
    }

    public Stream<SafeLong> streamAfter(SafeLong p0) {
        SafeLong p;
        SafeLong safeLong = p = this.nextAfter(p0);
        return Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> this.streamAfter(p)).$hash$colon$colon((Object)safeLong);
    }

    /*
     * WARNING - void declaration
     */
    public SafeLong[] arrayAt(SafeLong p, int size) {
        void var3_3;
        SafeLong[] arr = new SafeLong[size];
        this.loop$1(0, p, arr);
        return var3_3;
    }

    public Siever copy(int chunkSize, SafeLong cutoff) {
        return new Siever(chunkSize, cutoff);
    }

    public int copy$default$1() {
        return this.chunkSize();
    }

    public SafeLong copy$default$2() {
        return this.cutoff();
    }

    public String productPrefix() {
        return "Siever";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.chunkSize());
                break;
            }
            case 1: {
                object = this.cutoff();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Siever;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.chunkSize());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)((Object)this.cutoff())));
        return Statics.finalizeHash((int)n, (int)2);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Siever)) return false;
        boolean bl = true;
        if (!bl) return false;
        Siever siever = (Siever)x$1;
        if (this.chunkSize() != siever.chunkSize()) return false;
        if (!BoxesRunTime.equalsNumNum((Number)((Object)this.cutoff()), (Number)((Object)siever.cutoff()))) return false;
        if (!siever.canEqual(this)) return false;
        return true;
    }

    private final void loop$1(int i, SafeLong p, SafeLong[] arr$1) {
        while (i < arr$1.length) {
            arr$1[i] = p;
            p = this.nextAfter(p);
            ++i;
        }
    }

    public Siever(int chunkSize, SafeLong cutoff) {
        this.chunkSize = chunkSize;
        this.cutoff = cutoff;
        Product.$init$((Product)this);
        Predef$.MODULE$.require(chunkSize % 480 == 0, (Function0 & Serializable & scala.Serializable)() -> "chunkSize must be a multiple of 480");
        this.arr = BitSet$.MODULE$.alloc(chunkSize);
        this.start = SafeLong$.MODULE$.apply(0L);
        this.limit = this.start().$plus(chunkSize);
        this.fastq = SieveUtil$FastFactors$.MODULE$.empty();
        this.slowq = new FactorHeap();
        this.sieve = new SieveSegment(this.start(), this.arr(), cutoff);
        this.sieve().init(this.fastq(), this.slowq());
    }
}

