/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.util.ArrayList;
import java.util.List;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.ValidationFailureReporter;

class CollectingFailureReporter
extends ValidationFailureReporter {
    private List<ValidationException> failures = new ArrayList<ValidationException>(1);

    CollectingFailureReporter(Schema schema) {
        super(schema);
    }

    @Override
    public void failure(ValidationException exc) {
        this.failures.add(exc);
    }

    @Override
    public void validationFinished() {
        ValidationException.throwFor(this.schema, this.failures);
    }

    @Override
    public ValidationException inContextOfSchema(Schema schema, Runnable task) {
        int failureCountBefore = this.failures.size();
        super.inContextOfSchema(schema, task);
        int failureCountAfter = this.failures.size();
        int newFailureCount = failureCountAfter - failureCountBefore;
        if (newFailureCount == 0) {
            return null;
        }
        if (newFailureCount == 1) {
            return this.failures.remove(this.failures.size() - 1);
        }
        ArrayList<ValidationException> newFailures = new ArrayList<ValidationException>(this.failures.subList(failureCountBefore, this.failures.size()));
        int toBeRemoved = newFailureCount;
        int lastIndex = failureCountAfter;
        while (toBeRemoved-- > 0) {
            this.failures.remove(--lastIndex);
        }
        return ValidationException.createWrappingException(schema, newFailures);
    }

    int failureCount() {
        return this.failures.size();
    }
}

