/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.nio.ByteBuffer;
import java.security.AccessController;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.xnio.AutomaticReference;
import org.xnio.BufferAllocator;
import org.xnio.Pool;
import org.xnio.Pooled;
import org.xnio.ReadPropertyAction;
import org.xnio._private.Messages;

public final class ByteBufferSlicePool
implements Pool<ByteBuffer> {
    private static final int LOCAL_LENGTH;
    private final Set<Ref> refSet = Collections.synchronizedSet(new HashSet());
    private final Queue<Slice> sliceQueue;
    private final BufferAllocator<ByteBuffer> allocator;
    private final int bufferSize;
    private final int buffersPerRegion;
    private final int threadLocalQueueSize;
    private final ThreadLocal<ThreadLocalCache> localQueueHolder = new ThreadLocal<ThreadLocalCache>(){

        @Override
        protected ThreadLocalCache initialValue() {
            return new ThreadLocalCache();
        }

        @Override
        public void remove() {
            ArrayDeque<Slice> deque = ((ThreadLocalCache)this.get()).queue;
            Slice slice = deque.poll();
            while (slice != null) {
                ByteBufferSlicePool.this.doFree(slice);
                slice = deque.poll();
            }
            super.remove();
        }
    };

    public ByteBufferSlicePool(BufferAllocator<ByteBuffer> allocator, int bufferSize, int maxRegionSize, int threadLocalQueueSize) {
        if (bufferSize <= 0) {
            throw Messages.msg.parameterOutOfRange("bufferSize");
        }
        if (maxRegionSize < bufferSize) {
            throw Messages.msg.parameterOutOfRange("bufferSize");
        }
        this.buffersPerRegion = maxRegionSize / bufferSize;
        this.bufferSize = bufferSize;
        this.allocator = allocator;
        this.sliceQueue = new ConcurrentLinkedQueue<Slice>();
        this.threadLocalQueueSize = threadLocalQueueSize;
    }

    public ByteBufferSlicePool(BufferAllocator<ByteBuffer> allocator, int bufferSize, int maxRegionSize) {
        this(allocator, bufferSize, maxRegionSize, LOCAL_LENGTH);
    }

    public ByteBufferSlicePool(int bufferSize, int maxRegionSize) {
        this(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, bufferSize, maxRegionSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pooled<ByteBuffer> allocate() {
        Queue<Slice> sliceQueue;
        Slice slice;
        if (this.threadLocalQueueSize > 0) {
            ThreadLocalCache localCache = this.localQueueHolder.get();
            if (localCache.outstanding != this.threadLocalQueueSize) {
                ++localCache.outstanding;
            }
            if ((slice = localCache.queue.poll()) != null) {
                return new PooledByteBuffer(slice, slice.slice());
            }
        }
        if ((slice = (sliceQueue = this.sliceQueue).poll()) != null) {
            return new PooledByteBuffer(slice, slice.slice());
        }
        Queue<Slice> queue = sliceQueue;
        synchronized (queue) {
            slice = sliceQueue.poll();
            if (slice != null) {
                return new PooledByteBuffer(slice, slice.slice());
            }
            int bufferSize = this.bufferSize;
            int buffersPerRegion = this.buffersPerRegion;
            ByteBuffer region = this.allocator.allocate(buffersPerRegion * bufferSize);
            int idx = bufferSize;
            for (int i = 1; i < buffersPerRegion; ++i) {
                sliceQueue.add(new Slice(region, idx, bufferSize));
                idx += bufferSize;
            }
            Slice newSlice = new Slice(region, 0, bufferSize);
            return new PooledByteBuffer(newSlice, newSlice.slice());
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    private void doFree(Slice region) {
        if (this.threadLocalQueueSize > 0) {
            ArrayDeque<Slice> localQueue;
            ThreadLocalCache localCache = this.localQueueHolder.get();
            boolean cacheOk = false;
            if (localCache.outstanding > 0) {
                --localCache.outstanding;
                cacheOk = true;
            }
            if ((localQueue = localCache.queue).size() == this.threadLocalQueueSize || !cacheOk) {
                this.sliceQueue.add(region);
            } else {
                localQueue.add(region);
            }
        } else {
            this.sliceQueue.add(region);
        }
    }

    static {
        int val;
        String value = AccessController.doPrivileged(new ReadPropertyAction("xnio.bufferpool.threadlocal.size", "12"));
        try {
            val = Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            val = 12;
        }
        LOCAL_LENGTH = val;
    }

    private final class ThreadLocalCache {
        final ArrayDeque<Slice> queue;
        int outstanding;

        ThreadLocalCache() {
            this.queue = new ArrayDeque<Slice>(ByteBufferSlicePool.this.threadLocalQueueSize){

                protected void finalize() {
                    ArrayDeque<Slice> deque = ThreadLocalCache.this.queue;
                    Slice slice = deque.poll();
                    while (slice != null) {
                        ByteBufferSlicePool.this.doFree(slice);
                        slice = deque.poll();
                    }
                }
            };
            this.outstanding = 0;
        }
    }

    final class Ref
    extends AutomaticReference<ByteBuffer> {
        private final Slice region;

        private Ref(ByteBuffer referent, Slice region) {
            super(referent, AutomaticReference.PERMIT);
            this.region = region;
        }

        @Override
        protected void free() {
            ByteBufferSlicePool.this.doFree(this.region);
            ByteBufferSlicePool.this.refSet.remove(this);
        }
    }

    private final class Slice {
        private final ByteBuffer parent;

        private Slice(ByteBuffer parent, int start, int size) {
            this.parent = (ByteBuffer)parent.duplicate().position(start).limit(start + size);
        }

        ByteBuffer slice() {
            return this.parent.slice();
        }
    }

    private final class PooledByteBuffer
    implements Pooled<ByteBuffer> {
        private final Slice region;
        ByteBuffer buffer;

        PooledByteBuffer(Slice region, ByteBuffer buffer) {
            this.region = region;
            this.buffer = buffer;
        }

        @Override
        public void discard() {
            ByteBuffer buffer = this.buffer;
            this.buffer = null;
            if (buffer != null) {
                ByteBufferSlicePool.this.refSet.add(new Ref(buffer, this.region));
            }
        }

        @Override
        public void free() {
            ByteBuffer buffer = this.buffer;
            this.buffer = null;
            if (buffer != null) {
                ByteBufferSlicePool.this.doFree(this.region);
            }
        }

        @Override
        public ByteBuffer getResource() {
            ByteBuffer buffer = this.buffer;
            if (buffer == null) {
                throw Messages.msg.bufferFreed();
            }
            return buffer;
        }

        @Override
        public void close() {
            this.free();
        }

        public String toString() {
            return "Pooled buffer " + this.buffer;
        }
    }
}

