/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.modify;

import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.modify.UpdateProcessRemoteBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateRequest;

public class UpdateProcessRemote
extends UpdateProcessRemoteBase {
    public UpdateProcessRemote(UpdateRequest request, String endpoint, Context context) {
        super(request, endpoint, context);
    }

    public UpdateProcessRemote(UpdateRequest request, String endpoint, Context context, HttpClient client, HttpContext httpContext) {
        this(request, endpoint, context);
        if (client != null) {
            this.setClient(client);
        }
        if (httpContext != null) {
            this.setHttpContext(httpContext);
        }
    }

    @Override
    public void execute() {
        if (this.getEndpoint() == null) {
            throw new ARQException("Null endpoint for remote update");
        }
        if (this.getUpdateRequest() == null) {
            throw new ARQException("Null update request for remote update");
        }
        String endpoint = this.getEndpoint();
        String querystring = this.getUpdateString();
        if (querystring != null && !querystring.equals("")) {
            endpoint = endpoint.contains("?") ? endpoint + "&" + querystring : endpoint + "?" + querystring;
        }
        String reqStr = this.getUpdateRequest().toString();
        HttpOp.execHttpPost(endpoint, "application/sparql-update", reqStr, this.getClient(), this.getHttpContext());
    }
}

