/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.HttpContinue;
import java.io.IOException;

public class HttpContinueAcceptingHandler
implements HttpHandler {
    private final HttpHandler next;
    private final Predicate accept;

    public HttpContinueAcceptingHandler(HttpHandler next, Predicate accept) {
        this.next = next;
        this.accept = accept;
    }

    public HttpContinueAcceptingHandler(HttpHandler next) {
        this(next, Predicates.truePredicate());
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (HttpContinue.requiresContinueResponse(exchange)) {
            if (this.accept.resolve(exchange)) {
                HttpContinue.sendContinueResponse(exchange, new IoCallback(){

                    @Override
                    public void onComplete(HttpServerExchange exchange, Sender sender) {
                        exchange.dispatch(HttpContinueAcceptingHandler.this.next);
                    }

                    @Override
                    public void onException(HttpServerExchange exchange, Sender sender, IOException exception) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(exception);
                        exchange.endExchange();
                    }
                });
            } else {
                HttpContinue.rejectExchange(exchange);
            }
        } else {
            this.next.handleRequest(exchange);
        }
    }
}

