/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.util.NoSuchElementException;

public class Tokenizer {
    protected String source;
    protected int p;
    protected String delim;
    protected boolean returnDelims;
    protected String literalDelim;
    protected int state;
    protected String lookahead;
    protected static final int NORMAL = 1;
    protected static final int LITERAL_START = 2;
    protected static final int LITERAL_END = 3;

    public Tokenizer(String str, String delim, String literalDelim, boolean returnDelims) {
        this.source = str;
        this.delim = delim;
        this.literalDelim = literalDelim;
        this.returnDelims = returnDelims;
        this.p = 0;
        this.state = 1;
    }

    public String nextToken() {
        char c;
        String result = null;
        if (this.lookahead != null) {
            result = this.lookahead;
            this.lookahead = null;
        } else {
            result = this.getNextToken();
        }
        if (result == null) {
            throw new NoSuchElementException("No more elements in tokenized string");
        }
        if (!(this.returnDelims || result.length() != 1 || this.delim.indexOf(c = result.charAt(0)) == -1 && this.literalDelim.indexOf(c) == -1)) {
            return this.nextToken();
        }
        return result;
    }

    public boolean hasMoreTokens() {
        if (this.lookahead == null) {
            this.lookahead = this.getNextToken();
        }
        return this.lookahead != null;
    }

    private String getNextToken() {
        if (this.p >= this.source.length()) {
            return null;
        }
        switch (this.state) {
            case 1: {
                if (this.is(this.literalDelim)) {
                    this.state = 2;
                    ++this.p;
                    return this.source.substring(this.p - 1, this.p);
                }
                if (this.is(this.delim)) {
                    ++this.p;
                    return this.source.substring(this.p - 1, this.p);
                }
                int start = this.p++;
                while (this.p < this.source.length() && !this.is(this.delim)) {
                    ++this.p;
                }
                return this.source.substring(start, this.p);
            }
            case 2: {
                char delim = this.source.charAt(this.p - 1);
                StringBuilder literal = new StringBuilder();
                while (this.p < this.source.length()) {
                    char c = this.source.charAt(this.p);
                    if (c == '\\') {
                        ++this.p;
                        if (this.p >= this.source.length()) break;
                        c = this.source.charAt(this.p);
                    } else if (c == delim) break;
                    literal.append(c);
                    ++this.p;
                }
                this.state = 3;
                return literal.toString();
            }
            case 3: {
                this.state = 1;
                ++this.p;
                return this.source.substring(this.p - 1, this.p);
            }
        }
        return null;
    }

    private boolean is(String classification) {
        return classification.indexOf(this.source.charAt(this.p)) != -1;
    }
}

