/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat.commands;

import com.mulesoft.bat.APIs.Http$;
import com.mulesoft.bat.APIs.WorkerAPI$;
import com.mulesoft.bat.CLIArguments;
import com.mulesoft.bat.CLILogger$;
import com.mulesoft.bat.CLIXAPI$;
import com.mulesoft.bat.CredentialsProfile;
import com.mulesoft.bat.Settings$;
import com.mulesoft.bat.Token;
import com.mulesoft.bat.lambda.Response;
import com.mulesoft.bat.types.CurrentWorker;
import com.mulesoft.bat.types.EnvironmentData;
import com.mulesoft.bat.types.EnvironmentResponse;
import com.mulesoft.bat.types.Target;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.UUID;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class BatWorkerCommands$ {
    public static BatWorkerCommands$ MODULE$;

    static {
        new BatWorkerCommands$();
    }

    public void registerWorker(CLIArguments cfg) {
        String string;
        CredentialsProfile tok = cfg.ensureCredentialsProfile();
        String organizationId = tok.ensureOrganizationId();
        Option<String> option = Settings$.MODULE$.read("machine.id");
        if (option instanceof Some) {
            String value;
            Some some = (Some)option;
            string = value = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            Settings$.MODULE$.write("machine.id", UUID.randomUUID().toString());
            string = (String)Settings$.MODULE$.read("machine.id").get();
        } else {
            throw new MatchError(option);
        }
        String machineId = string;
        String targetId = CLIXAPI$.MODULE$.createDumbTarget(cfg, organizationId, cfg.name(), machineId);
        Settings$.MODULE$.write(new StringBuilder(10).append(tok.name()).append(".target.id").toString(), targetId);
        Settings$.MODULE$.write(new StringBuilder(12).append(tok.name()).append(".target.name").toString(), cfg.name());
        Settings$.MODULE$.write(new StringBuilder(22).append(tok.name()).append(".target.organizationId").toString(), organizationId);
        CLILogger$.MODULE$.logInfo("worker:");
        CLILogger$.MODULE$.logInfo(new StringBuilder(12).append("  targetId: ").append(targetId).toString());
        CLILogger$.MODULE$.logInfo(new StringBuilder(14).append("  targetName: ").append(cfg.name()).toString());
        CLILogger$.MODULE$.logInfo(new StringBuilder(13).append("  machineId: ").append(machineId).toString());
        CLILogger$.MODULE$.logInfo(new StringBuilder(11).append("  profile: ").append(tok.name()).toString());
        CLILogger$.MODULE$.logInfo(new StringBuilder(18).append("  organizationId: ").append(organizationId).toString());
    }

    public void printWorker(CLIArguments cfg) {
        CurrentWorker target = this.ensureCurrentWorker(cfg);
        CLILogger$.MODULE$.logInfo(target.targetId());
    }

    public void unregisterWorker(CLIArguments cfg) {
        CredentialsProfile tok = cfg.ensureCredentialsProfile();
        this.ensureCurrentWorker(cfg);
        Settings$.MODULE$.delete(new StringBuilder(10).append(tok.name()).append(".target.id").toString());
        Settings$.MODULE$.delete(new StringBuilder(12).append(tok.name()).append(".target.name").toString());
        Settings$.MODULE$.delete(new StringBuilder(22).append(tok.name()).append(".target.organizationId").toString());
    }

    public Option<CurrentWorker> getCurrentWorker(CLIArguments cfg) {
        CredentialsProfile tok = cfg.ensureCredentialsProfile();
        if (Settings$.MODULE$.read(new StringBuilder(10).append(tok.name()).append(".target.id").toString()).isEmpty()) {
            this.registerWorker(cfg);
        }
        return Settings$.MODULE$.read(new StringBuilder(10).append(tok.name()).append(".target.id").toString()).isEmpty() ? None$.MODULE$ : new Some((Object)new CurrentWorker((String)Settings$.MODULE$.read(new StringBuilder(22).append(tok.name()).append(".target.organizationId").toString()).get(), (String)Settings$.MODULE$.read(new StringBuilder(10).append(tok.name()).append(".target.id").toString()).get(), (String)Settings$.MODULE$.read(new StringBuilder(12).append(tok.name()).append(".target.name").toString()).get()));
    }

    public CurrentWorker ensureCurrentWorker(CLIArguments cfg) {
        Option<CurrentWorker> worker = this.getCurrentWorker(cfg);
        if (worker.isEmpty()) {
            throw new Exception(new StringBuilder(68).append("This machine is doesn't have a registered worker for the profile `").append(cfg.ensureCredentialsProfile().name()).append("`.").toString());
        }
        return (CurrentWorker)worker.get();
    }

    /*
     * Unable to fully structure code
     */
    public String ensureEnvironmentId(CLIArguments cfg) {
        environmentId = "";
        if (cfg.ANYPOINT_ENV().isDefined()) {
            environmentId = this.getEnvironmentIdByName(((UUID)cfg.organizationId().get()).toString(), ((String)cfg.ANYPOINT_ENV().get()).toString(), (CredentialsProfile)cfg.credentialsProfile().get());
        } else if (cfg.ensureCredentialsProfile().environment().isDefined()) {
            environmentId = (String)cfg.ensureCredentialsProfile().environment().get();
        }
        if (!new StringOps(Predef$.MODULE$.augmentString(environmentId)).nonEmpty()) ** GOTO lbl-1000
        v0 = environmentId;
        var3_3 = "";
        if (v0 == null ? var3_3 != null : v0.equals(var3_3) == false) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Predef$.MODULE$.require(v1, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$ensureEnvironmentId$1(), ()Ljava/lang/String;)());
        return var2_2;
    }

    public String ensureOrgId(CLIArguments cfg) {
        Option orgId = cfg.ANYPOINT_ORG_ID().orElse((Function0 & Serializable & scala.Serializable)() -> cfg.ensureCredentialsProfile().organizationId());
        Predef$.MODULE$.require(orgId.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "organization Id is missing.");
        return (String)orgId.get();
    }

    public String getEnvironmentIdByName(String organizationId, String environmentName, CredentialsProfile cfg) {
        EnvironmentData environmentSelected;
        if (environmentName == null) {
            throw new Exception("Environment name is missing.");
        }
        String url = new StringBuilder(50).append(WorkerAPI$.MODULE$.coreServicesEndpoint()).append("/apitesting/cli/api/v1/organizations/").append(organizationId).append("/environments").toString();
        Option option = Option$.MODULE$.apply((Object)Http$.MODULE$.get(url, ((Token)cfg.token().get()).token()));
        if (None$.MODULE$.equals(option)) {
            throw new Exception("Login with credentials failed.");
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Response r = (Response)some.value();
            int n = r.getStatus();
            switch (n) {
                case 200: {
                    Seq<EnvironmentData> environments = ((EnvironmentResponse)Http$.MODULE$.parseResponseJson(r, EnvironmentResponse.class)).data();
                    environmentSelected = (EnvironmentData)environments.find((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)BatWorkerCommands$.$anonfun$getEnvironmentIdByName$1(environmentName, p))).orNull(Predef$.MODULE$.$conforms());
                    if (environmentSelected != null) break;
                    throw new Exception(new StringBuilder(23).append("Environment ").append(environmentName).append(" not found.").toString());
                }
                case 401: {
                    throw new Exception("401 Unauthorized");
                }
                default: {
                    throw new Exception(new StringBuilder(22).append("Login failed.  Status ").append(n).toString());
                }
            }
        } else {
            throw new MatchError((Object)option);
        }
        String string = environmentSelected.id().toString();
        return string;
    }

    public void createLocation(CLIArguments cfg, Option<String> name) {
        block5: {
            String string;
            CredentialsProfile tok = cfg.ensureCredentialsProfile();
            String organizationId = this.ensureOrgId(cfg);
            String environmentId = this.ensureEnvironmentId(cfg);
            Option<String> region = cfg.ANYPOINT_REGION();
            if (name.isEmpty()) {
                throw new IllegalArgumentException("Missing location name");
            }
            Option<String> option = Settings$.MODULE$.read("machine.id");
            if (option instanceof Some) {
                String value;
                Some some = (Some)option;
                string = value = (String)some.value();
            } else if (None$.MODULE$.equals(option)) {
                Settings$.MODULE$.write("machine.id", UUID.randomUUID().toString());
                string = (String)Settings$.MODULE$.read("machine.id").get();
            } else {
                throw new MatchError(option);
            }
            String machineId = string;
            CLILogger$.MODULE$.logInfo("Creating location, please wait...");
            String targetId = CLIXAPI$.MODULE$.createMuleTarget(cfg, organizationId, environmentId.toString(), (String)name.get(), region, machineId);
            Settings$.MODULE$.write(new StringBuilder(10).append(tok.name()).append(".target.id").toString(), targetId);
            Settings$.MODULE$.write(new StringBuilder(12).append(tok.name()).append(".target.name").toString(), (String)name.get());
            Settings$.MODULE$.write(new StringBuilder(17).append(tok.name()).append(".target.machineId").toString(), machineId);
            Settings$.MODULE$.write(new StringBuilder(22).append(tok.name()).append(".target.organizationId").toString(), organizationId);
            Settings$.MODULE$.write(new StringBuilder(21).append(tok.name()).append(".target.environmentId").toString(), environmentId.toString());
            Settings$.MODULE$.write(new StringBuilder(14).append(tok.name()).append(".target.region").toString(), region.toString());
            CLILogger$.MODULE$.logInfo("\nLocation Created:");
            CLILogger$.MODULE$.logInfo(new StringBuilder(8).append("  Name: ").append(name.get()).toString());
            CLILogger$.MODULE$.logInfo(new StringBuilder(15).append("  Location Id: ").append(targetId).toString());
            CLILogger$.MODULE$.logInfo(new StringBuilder(16).append("  Organization: ").append(organizationId).toString());
            CLILogger$.MODULE$.logInfo(new StringBuilder(18).append("  Environment Id: ").append(environmentId).toString());
            if (!region.isDefined()) break block5;
            CLILogger$.MODULE$.logInfo(new StringBuilder(10).append("  Region: ").append(region).toString());
        }
    }

    private Target getTarget(CLIArguments cfg, String organizationId, String targetId) {
        Option<Target> target = CLIXAPI$.MODULE$.getTarget(cfg, organizationId, targetId);
        Predef$.MODULE$.require(target.isDefined(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Could not find location ").append(targetId).toString());
        return (Target)target.get();
    }

    public void deleteLocation(CLIArguments cfg, Option<String> targetId) {
        block1: {
            if (targetId.isEmpty()) {
                throw new IllegalArgumentException("Missing location id");
            }
            CredentialsProfile profile = cfg.ensureCredentialsProfile();
            Target target = this.getTarget(cfg, (String)profile.organizationId().get(), (String)targetId.get());
            CLILogger$.MODULE$.logInfo(new StringBuilder(18).append("Deleting location ").append(target.name()).toString());
            Predef$.MODULE$.require(target.transport().equals("MULE"), (Function0 & Serializable & scala.Serializable)() -> "The location type is not supported for this opperation.");
            Predef$.MODULE$.require(((String)profile.organizationId().get()).equals(target.organizationId().get()), (Function0 & Serializable & scala.Serializable)() -> "The location does not belong to your organization.");
            boolean removed = CLIXAPI$.MODULE$.deleteMuleTarget(cfg, (String)profile.organizationId().get(), target.id());
            if (!removed) break block1;
            CLILogger$.MODULE$.logInfo("Location removed.");
        }
    }

    public static final /* synthetic */ String $anonfun$ensureEnvironmentId$1() {
        return "environmentId is missing.";
    }

    public static final /* synthetic */ boolean $anonfun$getEnvironmentIdByName$1(String environmentName$1, EnvironmentData p) {
        String string = p.name().toString().toUpperCase();
        String string2 = environmentName$1.toString().toUpperCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private BatWorkerCommands$() {
        MODULE$ = this;
    }
}

