/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;

public abstract class FunctionBase
implements Function {
    protected FunctionEnv functionEnv = null;
    private Binding binding = null;

    @Override
    public final void build(String uri, ExprList args) {
        this.checkBuild(uri, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        if (args == null) {
            throw new ARQInternalErrorException("FunctionBase: Null args list");
        }
        ArrayList<NodeValue> evalArgs = new ArrayList<NodeValue>();
        for (Expr e2 : args) {
            NodeValue x = e2.eval(binding, env);
            evalArgs.add(x);
        }
        try {
            NodeValue nv;
            this.functionEnv = env;
            this.binding = binding;
            NodeValue nodeValue = nv = this.exec(evalArgs);
            return nodeValue;
        }
        finally {
            this.functionEnv = null;
            this.binding = null;
        }
    }

    public abstract NodeValue exec(List<NodeValue> var1);

    public abstract void checkBuild(String var1, ExprList var2);
}

