/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.topbraid.jenax.functions.OptionalArgsFunction;
import org.topbraid.jenax.util.RDFLabels;
import org.topbraid.shacl.expr.AppendContext;
import org.topbraid.shacl.expr.ComplexNodeExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.NodeExpressionContext;

public class FunctionExpression
extends ComplexNodeExpression {
    private List<NodeExpression> args;
    private Expr expr;
    private Resource function;

    public FunctionExpression(Resource function, List<NodeExpression> args) {
        this.args = args;
        this.function = function;
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(function);
        sb.append(">(");
        for (int i = 0; i < args.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?a" + i);
        }
        sb.append(")");
        this.expr = ExprUtils.parse((String)sb.toString());
    }

    public String appendBindings(AppendContext context) {
        String varName = null;
        for (int i = 0; i < this.args.size(); ++i) {
            NodeExpression arg = this.args.get(i);
            if (!(arg instanceof ComplexNodeExpression)) continue;
            if (varName == null) {
                varName = context.getNextVarName();
            }
            ((ComplexNodeExpression)arg).appendLabel(context, varName + (i + 1));
        }
        return varName;
    }

    private void appendCall(AppendContext context, String varName) {
        context.append(RDFLabels.get().getLabel(this.function));
        context.append("(");
        for (int i = 0; i < this.args.size(); ++i) {
            NodeExpression arg = this.args.get(i);
            if (i > 0) {
                context.append(", ");
            }
            if (arg instanceof ComplexNodeExpression) {
                context.append("?" + varName + (i + 1));
                continue;
            }
            context.append(arg.toString());
        }
        context.append(")");
    }

    @Override
    public void appendLabel(AppendContext context, String targetVarName) {
        String varName = this.appendBindings(context);
        context.indent();
        context.append("BIND(");
        this.appendCall(context, varName);
        context.append(" AS ?");
        context.append(targetVarName);
        context.append(") .\n");
    }

    @Override
    public List<RDFNode> eval(RDFNode focusNode, NodeExpressionContext context) {
        Function arq;
        LinkedList<RDFNode> results = new LinkedList<RDFNode>();
        Context cxt = ARQ.getContext().copy();
        cxt.set(ARQConstants.sysCurrentTime, (Object)NodeFactoryExtra.nowAsDateTime());
        OptionalArgsFunction opt = null;
        FunctionFactory ff = FunctionRegistry.get().get(this.function.getURI());
        if (ff != null && (arq = ff.create(this.function.getURI())) instanceof OptionalArgsFunction) {
            opt = (OptionalArgsFunction)arq;
        }
        int total = 1;
        LinkedList<List<RDFNode>> as = new LinkedList<List<RDFNode>>();
        for (int i = 0; i < this.args.size(); ++i) {
            NodeExpression expr = this.args.get(i);
            List<RDFNode> a = expr.eval(focusNode, context);
            if (a.isEmpty()) {
                if (opt == null || !opt.isOptionalArg(i)) {
                    return results;
                }
            } else {
                total *= a.size();
            }
            as.add(a);
        }
        for (int x = 0; x < total; ++x) {
            int y = x;
            BindingHashMap binding = new BindingHashMap();
            for (int i = 0; i < this.args.size(); ++i) {
                List a = (List)as.get(i);
                if (a.isEmpty()) continue;
                int m = y % a.size();
                binding.add(Var.alloc((String)("a" + i)), ((RDFNode)a.get(m)).asNode());
                y /= a.size();
            }
            Dataset dataset = context.getDataset();
            DatasetGraph dsg = dataset.asDatasetGraph();
            ExecutionContext env = new ExecutionContext(cxt, dsg.getDefaultGraph(), dsg, null);
            try {
                Model defaultModel;
                RDFNode rdfNode;
                NodeValue r = this.expr.eval((Binding)binding, (FunctionEnv)env);
                if (r == null || results.contains(rdfNode = (defaultModel = dataset.getDefaultModel()).asRDFNode(r.asNode()))) continue;
                results.add(rdfNode);
                continue;
            }
            catch (ExprEvalException exprEvalException) {
                // empty catch block
            }
        }
        return results;
    }
}

