/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVars;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementVisitor;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.ElementWalker;
import org.apache.jena.sparql.util.VarUtils;

public class VarFinder {
    public static Set<String> varsMentioned(Query query) {
        HashSet<String> results = new HashSet<String>();
        if (query.isSelectType()) {
            for (Object var : query.getResultVars()) {
                results.add((String)var);
            }
        } else if (query.isConstructType()) {
            for (Triple t : query.getConstructTemplate().getTriples()) {
                if (t.getMatchSubject().isVariable()) {
                    results.add(t.getMatchSubject().getName());
                }
                if (t.getMatchPredicate().isVariable()) {
                    results.add(t.getMatchPredicate().getName());
                }
                if (!t.getMatchObject().isVariable()) continue;
                results.add(t.getMatchObject().getName());
            }
        }
        final HashSet vars = new HashSet();
        ElementVisitorBase v = new ElementVisitorBase(){

            public void visit(ElementTriplesBlock el) {
                Iterator iter = el.patternElts();
                while (iter.hasNext()) {
                    Triple t = (Triple)iter.next();
                    VarUtils.addVarsFromTriple((Collection)vars, (Triple)t);
                }
            }

            public void visit(ElementPathBlock el) {
                Iterator iter = el.patternElts();
                while (iter.hasNext()) {
                    TriplePath tp = (TriplePath)iter.next();
                    if (tp.isTriple()) {
                        VarUtils.addVarsFromTriple((Collection)vars, (Triple)tp.asTriple());
                        continue;
                    }
                    VarUtils.addVarsFromTriplePath((Collection)vars, (TriplePath)tp);
                }
            }

            public void visit(ElementFilter el) {
                ExprVars.varsMentioned((Collection)vars, (Expr)el.getExpr());
            }

            public void visit(ElementNamedGraph el) {
                VarUtils.addVar((Collection)vars, (Node)el.getGraphNameNode());
            }

            public void visit(ElementService el) {
                VarUtils.addVar((Collection)vars, (Node)el.getServiceNode());
            }

            public void visit(ElementSubQuery el) {
                el.getQuery().setResultVars();
                VarExprList x = el.getQuery().getProject();
                vars.addAll(x.getVars());
            }

            public void visit(ElementAssign el) {
                vars.add(el.getVar());
                ExprVars.varsMentioned((Collection)vars, (Expr)el.getExpr());
            }
        };
        ElementWalker.walk((Element)query.getQueryPattern(), (ElementVisitor)v);
        for (Var var : vars) {
            results.add(var.getName());
        }
        return results;
    }
}

