/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Service;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.impl.ElementImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.visitor.ElementVisitor;
import org.topbraid.spin.vocabulary.SP;

public class ServiceImpl
extends ElementImpl
implements Service {
    public ServiceImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    @Override
    public String getServiceURI() {
        Variable variable;
        Statement s = this.getProperty(SP.serviceURI);
        if (s != null && s.getObject().isURIResource() && (variable = SPINFactory.asVariable((RDFNode)s.getResource())) == null) {
            return s.getResource().getURI();
        }
        return null;
    }

    @Override
    public Variable getServiceVariable() {
        Variable variable;
        Statement s = this.getProperty(SP.serviceURI);
        if (s != null && s.getObject().isResource() && (variable = SPINFactory.asVariable((RDFNode)s.getResource())) != null) {
            return variable;
        }
        return null;
    }

    @Override
    public void print(PrintContext p) {
        p.printKeyword("SERVICE");
        Variable var = this.getServiceVariable();
        if (var != null) {
            p.print(" ");
            p.printVariable(var.getName());
        } else {
            String uri = this.getServiceURI();
            if (uri != null) {
                p.print(" ");
                p.printURIResource(this.getModel().getResource(uri));
            }
        }
        this.printNestedElementList(p);
    }

    @Override
    public void visit(ElementVisitor visitor) {
        visitor.visit(this);
    }
}

