/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import cats.kernel.Eq;
import cats.kernel.Order;
import java.io.Serializable;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.math.ScalaNumericConversions;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import spire.algebra.Field;
import spire.algebra.GCDRing;
import spire.algebra.IsReal;
import spire.algebra.NRoot;
import spire.algebra.Signed;
import spire.algebra.Trig;
import spire.implicits$;
import spire.std.package$bigDecimal$;
import spire.syntax.LiteralIntAdditiveSemigroupOps$;

public final class package$ {
    public static package$ MODULE$;
    private final int radix;

    static {
        new package$();
    }

    public final byte abs(byte n) {
        return (byte)Math.abs(n);
    }

    public final short abs(short n) {
        return (short)Math.abs(n);
    }

    public final int abs(int n) {
        return Math.abs(n);
    }

    public final long abs(long n) {
        return Math.abs(n);
    }

    public final float abs(float n) {
        return Math.abs(n);
    }

    public final double abs(double n) {
        return Math.abs(n);
    }

    public final <A> A abs(A a, Signed<A> ev) {
        return ev.abs(a);
    }

    public final float ceil(float n) {
        return (float)Math.ceil(n);
    }

    public final double ceil(double n) {
        return Math.ceil(n);
    }

    public final BigDecimal ceil(BigDecimal n) {
        return n.setScale(0, BigDecimal.RoundingMode$.MODULE$.CEILING());
    }

    public final <A> A ceil(A a, IsReal<A> ev) {
        return ev.ceil(a);
    }

    public BigInt choose(long n, long k) {
        if (n < 0L || k < 0L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n=", ", k=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)n), BoxesRunTime.boxToLong((long)k)})));
        }
        if (k == 0L || k == n) {
            return scala.package$.MODULE$.BigInt().apply(1);
        }
        if (k > n) {
            return scala.package$.MODULE$.BigInt().apply(0);
        }
        if (n - k > k) {
            return this.choose(n, n - k);
        }
        return (n - k & 1L) == 1L ? this.loop$1(k + 1L, n - 1L, scala.package$.MODULE$.BigInt().apply(n)).$div(this.fact(n - k)) : this.loop$1(k + 1L, n, scala.package$.MODULE$.BigInt().apply(1)).$div(this.fact(n - k));
    }

    public BigInt fact(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToLong((long)n)).toString());
        }
        return n == 0L ? scala.package$.MODULE$.BigInt().apply(1) : ((n & 1L) == 1L ? this.loop$2(1L, n - 1L, scala.package$.MODULE$.BigInt().apply(n)) : this.loop$2(2L, n - 1L, scala.package$.MODULE$.BigInt().apply(n)));
    }

    public BigInt fib(long n) {
        int i;
        if (n < 0L) {
            throw new IllegalArgumentException(((Object)BoxesRunTime.boxToLong((long)n)).toString());
        }
        for (i = 63; (n >>> i & 1L) == 0L && i >= 0; --i) {
        }
        return this.loop$3(scala.package$.MODULE$.BigInt().apply(1), scala.package$.MODULE$.BigInt().apply(0), i, n);
    }

    public final float floor(float n) {
        return (float)Math.floor(n);
    }

    public final double floor(double n) {
        return Math.floor(n);
    }

    public final BigDecimal floor(BigDecimal n) {
        return n.setScale(0, BigDecimal.RoundingMode$.MODULE$.FLOOR());
    }

    public final <A> A floor(A a, IsReal<A> ev) {
        return ev.floor(a);
    }

    public final float round(float a) {
        return Math.abs(a) >= 1.6777216E7f ? a : (float)Math.round(a);
    }

    public final double round(double a) {
        return Math.abs(a) >= 4.503599627370496E15 ? a : (double)Math.round(a);
    }

    public final BigDecimal round(BigDecimal a) {
        return a.setScale(0, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
    }

    public final <A> A round(A a, IsReal<A> ev) {
        return ev.round(a);
    }

    public final double exp(double n) {
        return Math.exp(n);
    }

    public final BigDecimal exp(int k, int precision) {
        MathContext mc = new MathContext(precision + 1, RoundingMode.HALF_UP);
        int i = 2;
        BigInt num = scala.package$.MODULE$.BigInt().apply(2);
        BigInt denom = scala.package$.MODULE$.BigInt().apply(1);
        BigInt limit = scala.package$.MODULE$.BigInt().apply(10).pow(precision);
        while (denom.$less((Object)limit)) {
            denom = denom.$times(BigInt$.MODULE$.int2bigInt(i));
            num = num.$times(BigInt$.MODULE$.int2bigInt(i)).$plus(scala.package$.MODULE$.BigInt().apply(1));
            ++i;
        }
        BigDecimal sum = scala.package$.MODULE$.BigDecimal().apply(num, mc).$div(scala.package$.MODULE$.BigDecimal().apply(denom, mc));
        return sum.setScale(precision - sum.precision() + sum.scale(), BigDecimal.RoundingMode$.MODULE$.FLOOR()).pow(k);
    }

    public final BigDecimal exp(BigDecimal k) {
        if (k.signum() == 0) {
            return scala.package$.MODULE$.BigDecimal().apply(1);
        }
        if (k.signum() == -1) {
            return scala.package$.MODULE$.BigDecimal().apply(1).$div(this.exp(k.unary_$minus()));
        }
        BigDecimal whole = k.setScale(0, BigDecimal.RoundingMode$.MODULE$.FLOOR());
        if (whole.signum() > 1) {
            BigDecimal part = this.exp(scala.package$.MODULE$.BigDecimal().apply(1).$plus(k.$minus(whole).$div(whole)));
            return this.power$1(scala.package$.MODULE$.BigDecimal().apply(1), part, whole.toBigInt());
        }
        int precision = k.mc().getPrecision() + 3;
        int leeway = 1000;
        BigDecimal r = this.doit$1(k.mc().getPrecision() + 3, 1000, k);
        return new BigDecimal(r.bigDecimal(), k.mc());
    }

    public final <A> A exp(A a, Trig<A> t) {
        return t.exp(a);
    }

    public final double log(double n) {
        return Math.log(n);
    }

    public final double log(double n, int base) {
        return Math.log(n) / Math.log(base);
    }

    public final BigDecimal log(BigDecimal n) {
        int scale = n.mc().getPrecision();
        if (n.signum() < 1) {
            throw new IllegalArgumentException("argument <= 0");
        }
        Tuple2 tuple2 = this.rescale$1(n, 0);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigDecimal x = (BigDecimal)tuple2._1();
        int i = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)i));
        Tuple2 tuple23 = tuple22;
        BigDecimal x2 = (BigDecimal)tuple23._1();
        int i2 = tuple23._2$mcI$sp();
        return this.ln$1(x2, scale).$times(scala.package$.MODULE$.BigDecimal().apply(2).pow(i2)).setScale(scale, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
    }

    public BigDecimal log(BigDecimal n, int base) {
        return this.log(n).$div(this.log(scala.package$.MODULE$.BigDecimal().apply(base)));
    }

    public final <A> A log(A a, Trig<A> t) {
        return t.log(a);
    }

    public final <A> A log(A a, int base, Field<A> f, Trig<A> t) {
        return (A)f.div(t.log(a), t.log(f.fromInt(base)));
    }

    public final BigDecimal pow(BigDecimal base, BigDecimal exponent) {
        return exponent.abs().$less$eq((Object)BigDecimal$.MODULE$.int2bigDecimal(99999999)) && exponent.isWhole() ? base.pow(exponent.toInt()) : this.exp(this.log(base).$times(exponent));
    }

    public final BigInt pow(BigInt base, BigInt ex) {
        BigInt bigInt;
        if (ex.signum() < 0) {
            if (base.signum() == 0) {
                throw new ArithmeticException("zero can't be raised to negative power");
            }
            bigInt = BoxesRunTime.equalsNumObject((Number)base, (Object)BoxesRunTime.boxToInteger((int)1)) ? base : (BoxesRunTime.equalsNumObject((Number)base, (Object)BoxesRunTime.boxToInteger((int)-1)) ? (ex.testBit(0) ? scala.package$.MODULE$.BigInt().apply(1) : base) : scala.package$.MODULE$.BigInt().apply(0));
        } else {
            bigInt = ex.isValidInt() ? base.pow(ex.toInt()) : this.bigIntPow$1(scala.package$.MODULE$.BigInt().apply(1), base, ex);
        }
        return bigInt;
    }

    public final long pow(long base, long exponent) {
        long l;
        if (exponent < 0L) {
            if (base == 0L) {
                throw new ArithmeticException("zero can't be raised to negative power");
            }
            l = base == 1L ? 1L : (base == -1L ? ((exponent & 1L) == 0L ? -1L : 1L) : 0L);
        } else {
            l = this.longPow$1(1L, base, exponent);
        }
        return l;
    }

    public final double pow(double base, double exponent) {
        return Math.pow(base, exponent);
    }

    public final long gcd(long _x, long _y) {
        if (_x == 0L) {
            return Math.abs(_y);
        }
        if (_x == 1L) {
            return 1L;
        }
        if (_y == 0L) {
            return Math.abs(_x);
        }
        if (_y == 1L) {
            return 1L;
        }
        long x = _x;
        int xz = Long.numberOfTrailingZeros(x);
        x = Math.abs(x >> xz);
        long y = _y;
        int yz = Long.numberOfTrailingZeros(y);
        y = Math.abs(y >> yz);
        while (x != y) {
            if (x > y) {
                x -= y;
                x >>= Long.numberOfTrailingZeros(x);
                continue;
            }
            y -= x;
            y >>= Long.numberOfTrailingZeros(y);
        }
        return xz < yz ? x << xz : x << yz;
    }

    public final BigInt gcd(BigInt a, BigInt b) {
        return a.gcd(b);
    }

    public final <A> A gcd(A x, A y, Eq<A> evidence$1, GCDRing<A> ev) {
        return ev.gcd(x, y, evidence$1);
    }

    public final <A> A gcd(Seq<A> xs, Eq<A> evidence$2, GCDRing<A> ev) {
        return (A)xs.reduceLeft((Function2 & Serializable & scala.Serializable)(a, b) -> ev.gcd(a, b, evidence$2));
    }

    public final <A> A gcd(A x, A y, A z, Seq<A> rest, Eq<A> evidence$3, GCDRing<A> ev) {
        return rest.isEmpty() ? ev.gcd(ev.gcd(x, y, evidence$3), z, evidence$3) : ev.gcd(ev.gcd(ev.gcd(x, y, evidence$3), z, evidence$3), this.gcd(rest, evidence$3, ev), evidence$3);
    }

    public final long lcm(long x, long y) {
        return x == 0L || y == 0L ? 0L : x / this.gcd(x, y) * y;
    }

    public final BigInt lcm(BigInt a, BigInt b) {
        return a.signum() == 0 || b.signum() == 0 ? BigInt$.MODULE$.int2bigInt(0) : a.$div(a.gcd(b)).$times(b);
    }

    public final <A> A lcm(A x, A y, Eq<A> evidence$4, GCDRing<A> ev) {
        return ev.lcm(x, y, evidence$4);
    }

    public final byte min(byte x, byte y) {
        return (byte)Math.min(x, y);
    }

    public final short min(short x, short y) {
        return (short)Math.min(x, y);
    }

    public final int min(int x, int y) {
        return Math.min(x, y);
    }

    public final long min(long x, long y) {
        return Math.min(x, y);
    }

    public final float min(float x, float y) {
        return Math.min(x, y);
    }

    public final double min(double x, double y) {
        return Math.min(x, y);
    }

    public final <A> A min(A x, A y, Order<A> ev) {
        return (A)ev.min(x, y);
    }

    public final byte max(byte x, byte y) {
        return (byte)Math.max(x, y);
    }

    public final short max(short x, short y) {
        return (short)Math.max(x, y);
    }

    public final int max(int x, int y) {
        return Math.max(x, y);
    }

    public final long max(long x, long y) {
        return Math.max(x, y);
    }

    public final float max(float x, float y) {
        return Math.max(x, y);
    }

    public final double max(double x, double y) {
        return Math.max(x, y);
    }

    public final <A> A max(A x, A y, Order<A> ev) {
        return (A)ev.max(x, y);
    }

    public final double signum(double x) {
        return Math.signum(x);
    }

    public final float signum(float x) {
        return Math.signum(x);
    }

    public final <A> int signum(A a, Signed<A> ev) {
        return ev.signum(a);
    }

    public final double sqrt(double x) {
        return Math.sqrt(x);
    }

    public final <A> A sqrt(A a, NRoot<A> ev) {
        return ev.sqrt(a);
    }

    public final double e() {
        return Math.E;
    }

    public final <A> A e(Trig<A> ev) {
        return ev.e();
    }

    public final double pi() {
        return Math.PI;
    }

    public final <A> A pi(Trig<A> ev) {
        return ev.pi();
    }

    public final <A> A sin(A a, Trig<A> ev) {
        return ev.sin(a);
    }

    public final <A> A cos(A a, Trig<A> ev) {
        return ev.cos(a);
    }

    public final <A> A tan(A a, Trig<A> ev) {
        return ev.tan(a);
    }

    public final <A> A asin(A a, Trig<A> ev) {
        return ev.asin(a);
    }

    public final <A> A acos(A a, Trig<A> ev) {
        return ev.acos(a);
    }

    public final <A> A atan(A a, Trig<A> ev) {
        return ev.atan(a);
    }

    public final <A> A atan2(A y, A x, Trig<A> ev) {
        return ev.atan2(y, x);
    }

    public final <A> A sinh(A x, Trig<A> ev) {
        return ev.sinh(x);
    }

    public final <A> A cosh(A x, Trig<A> ev) {
        return ev.cosh(x);
    }

    public final <A> A tanh(A x, Trig<A> ev) {
        return ev.tanh(x);
    }

    public final double cbrt(double x) {
        return Math.cbrt(x);
    }

    public final double copySign(double m, double s) {
        return Math.copySign(m, s);
    }

    public final float copySign(float m, float s) {
        return Math.copySign(m, s);
    }

    public final double cosh(double x) {
        return Math.cosh(x);
    }

    public final double expm1(double x) {
        return Math.expm1(x);
    }

    public final int getExponent(double x) {
        return Math.getExponent(x);
    }

    public final int getExponent(float x) {
        return Math.getExponent(x);
    }

    public final double IEEEremainder(double x, double d) {
        return Math.IEEEremainder(x, d);
    }

    public final double log10(double x) {
        return Math.log10(x);
    }

    public final double log1p(double x) {
        return Math.log1p(x);
    }

    public final double nextAfter(double x, double y) {
        return Math.nextAfter(x, y);
    }

    public final float nextAfter(float x, float y) {
        return Math.nextAfter(x, (double)y);
    }

    public final double nextUp(double x) {
        return Math.nextUp(x);
    }

    public final float nextUp(float x) {
        return Math.nextUp(x);
    }

    public final double random() {
        return Math.random();
    }

    public final double rint(double x) {
        return Math.rint(x);
    }

    public final double scalb(double d, int s) {
        return Math.scalb(d, s);
    }

    public final float scalb(float d, int s) {
        return Math.scalb(d, s);
    }

    public final double toDegrees(double a) {
        return Math.toDegrees(a);
    }

    public final double toRadians(double a) {
        return Math.toRadians(a);
    }

    public final double ulp(double x) {
        return Math.ulp(x);
    }

    public final double ulp(float x) {
        return Math.ulp(x);
    }

    public final <A> A hypot(A x, A y, Field<A> f, NRoot<A> n, Signed<A> s) {
        return (A)(s.gt(x, y) ? f.times(package$.abs$1(x, f, s), n.sqrt(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), f.pow(f.div(y, x), 2), f))) : f.times(package$.abs$1(y, f, s), n.sqrt(LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), f.pow(f.div(x, y), 2), f))));
    }

    private int intSearch(Function1<Object, Object> f) {
        int n;
        int ceil = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 32).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> !f.apply$mcZI$sp(1 << i)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 33));
        if (ceil == 0) {
            n = 0;
        } else {
            int n2 = 0;
            n = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(ceil - 1), 0).by(-1).$div$colon((Object)BoxesRunTime.boxToInteger((int)n2), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x, i) -> {
                int y = x | 1 << i;
                return f.apply$mcZI$sp(y) ? y : x;
            }));
        }
        return n;
    }

    private Stream<BigInt> decDiv(BigInt x, BigInt y, int r) {
        BigInt quot;
        BigInt expanded = x.$times(BigInt$.MODULE$.int2bigInt(r));
        BigInt rem = expanded.$minus((quot = expanded.$div(y)).$times(y));
        return BoxesRunTime.equalsNumObject((Number)rem, (Object)BoxesRunTime.boxToInteger((int)0)) ? Stream.cons$.MODULE$.apply((Object)quot, (Function0 & Serializable & scala.Serializable)() -> scala.package$.MODULE$.Stream().empty()) : Stream.cons$.MODULE$.apply((Object)quot, (Function0 & Serializable & scala.Serializable)() -> this.decDiv(rem, y, r));
    }

    private List<Object> digitize(BigInt x, int r, List<Object> prev) {
        while (!BoxesRunTime.equalsNumObject((Number)x, (Object)BoxesRunTime.boxToInteger((int)0))) {
            BigInt bigInt = x.$div(BigInt$.MODULE$.int2bigInt(r));
            int n = x.$percent(BigInt$.MODULE$.int2bigInt(r)).toInt();
            prev = prev.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n));
            x = bigInt;
        }
        return prev;
    }

    private List<Object> digitize$default$3() {
        return Nil$.MODULE$;
    }

    private BigInt undigitize(Seq<Object> digits, int r) {
        BigInt bigInt = scala.package$.MODULE$.BigInt().apply(0);
        return (BigInt)digits.$div$colon((Object)bigInt, (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> package$.$anonfun$undigitize$1(r, x$5, BoxesRunTime.unboxToInt((Object)x$6)));
    }

    private int radix() {
        return this.radix;
    }

    public BigDecimal nroot(BigDecimal a, int k, MathContext ctxt) {
        BigDecimal bigDecimal;
        if (k == 0) {
            bigDecimal = scala.package$.MODULE$.BigDecimal().apply(1);
        } else if (a.signum() < 0) {
            if (k % 2 == 0) {
                throw new ArithmeticException(new StringOps(Predef$.MODULE$.augmentString("%d-root of negative number")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)k)})));
            }
            bigDecimal = this.nroot(a.unary_$minus(), k, ctxt).unary_$minus();
        } else {
            BigInt underlying = scala.package$.MODULE$.BigInt().apply(a.bigDecimal().unscaledValue().toByteArray());
            BigInt scale = scala.package$.MODULE$.BigInt().apply(10).pow(a.scale());
            List<Object> intPart = this.digitize(underlying.$div(scale), this.radix(), this.digitize$default$3());
            Stream fracPart = (Stream)this.decDiv(underlying.$percent(scale), scale, this.radix()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.toInt()), Stream$.MODULE$.canBuildFrom());
            Stream leader = intPart.size() % k == 0 ? scala.package$.MODULE$.Stream().empty() : scala.package$.MODULE$.Stream().fill(k - intPart.size() % k, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
            Stream digits = (Stream)((Stream)((Stream)leader.$plus$plus((GenTraversableOnce)intPart.toStream(), Stream$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)fracPart, Stream$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)scala.package$.MODULE$.Stream().continually((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0), Stream$.MODULE$.canBuildFrom());
            BigInt radixPowK = scala.package$.MODULE$.BigInt().apply(this.radix()).pow(k);
            int maxSize = (ctxt.getPrecision() + 8) / 9 + 2;
            Tuple2 tuple2 = this.findRoot$1(digits, BigInt$.MODULE$.int2bigInt(0), BigInt$.MODULE$.int2bigInt(0), 1, k, radixPowK, maxSize);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int size = tuple2._1$mcI$sp();
            BigInt unscaled = (BigInt)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)size), (Object)unscaled);
            Tuple2 tuple23 = tuple22;
            int size2 = tuple23._1$mcI$sp();
            BigInt unscaled2 = (BigInt)tuple23._2();
            int newscale = (size2 - (intPart.size() + k - 1) / k) * 9;
            bigDecimal = scala.package$.MODULE$.BigDecimal().apply(unscaled2, newscale, ctxt);
        }
        return bigDecimal;
    }

    public boolean anyIsZero(Object n) {
        ScalaNumericConversions scalaNumericConversions;
        Object object = n;
        boolean bl = BoxesRunTime.equals((Object)object, (Object)BoxesRunTime.boxToInteger((int)0)) ? true : (object instanceof ScalaNumericConversions ? (scalaNumericConversions = (ScalaNumericConversions)object).isValidInt() && scalaNumericConversions.toInt() == 0 : false);
        return bl;
    }

    public double anyToDouble(Object n) {
        double d;
        Object object = n;
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            d = by;
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            d = s;
        } else if (object instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object);
            d = c;
        } else if (object instanceof Integer) {
            int n2 = BoxesRunTime.unboxToInt((Object)object);
            d = n2;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            d = l;
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            d = f;
        } else if (object instanceof Double) {
            double d2;
            d = d2 = BoxesRunTime.unboxToDouble((Object)object);
        } else if (object instanceof ScalaNumericConversions) {
            ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)object;
            d = scalaNumericConversions.toDouble();
        } else {
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        return d;
    }

    public long anyToLong(Object n) {
        long l;
        Object object = n;
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            l = by;
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            l = s;
        } else if (object instanceof Character) {
            char c = BoxesRunTime.unboxToChar((Object)object);
            l = c;
        } else if (object instanceof Integer) {
            int n2 = BoxesRunTime.unboxToInt((Object)object);
            l = n2;
        } else if (object instanceof Long) {
            long l2;
            l = l2 = BoxesRunTime.unboxToLong((Object)object);
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            l = (long)f;
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            l = (long)d;
        } else if (object instanceof ScalaNumericConversions) {
            ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)object;
            l = scalaNumericConversions.toLong();
        } else {
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        return l;
    }

    public boolean anyIsWhole(Object n) {
        boolean bl;
        Object object = n;
        if (object instanceof Byte) {
            bl = true;
        } else if (object instanceof Short) {
            bl = true;
        } else if (object instanceof Character) {
            bl = true;
        } else if (object instanceof Integer) {
            bl = true;
        } else if (object instanceof Long) {
            bl = true;
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            bl = RichFloat$.MODULE$.isWhole$extension(Predef$.MODULE$.floatWrapper(f));
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            bl = RichDouble$.MODULE$.isWhole$extension(Predef$.MODULE$.doubleWrapper(d));
        } else if (object instanceof ScalaNumericConversions) {
            ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)object;
            bl = scalaNumericConversions.isWhole();
        } else {
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        return bl;
    }

    public boolean anyIsValidInt(Object n) {
        boolean bl;
        Object object = n;
        if (object instanceof Byte) {
            bl = true;
        } else if (object instanceof Short) {
            bl = true;
        } else if (object instanceof Character) {
            bl = true;
        } else if (object instanceof Integer) {
            bl = true;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            bl = RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(l));
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            bl = RichFloat$.MODULE$.isValidInt$extension(Predef$.MODULE$.floatWrapper(f));
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            bl = RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(d));
        } else if (object instanceof ScalaNumericConversions) {
            ScalaNumericConversions scalaNumericConversions = (ScalaNumericConversions)object;
            bl = scalaNumericConversions.isValidInt();
        } else {
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a ScalaNumber"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        return bl;
    }

    public final double e$mDc$sp(Trig<Object> ev) {
        return ev.e$mcD$sp();
    }

    public final float e$mFc$sp(Trig<Object> ev) {
        return ev.e$mcF$sp();
    }

    public final double pi$mDc$sp(Trig<Object> ev) {
        return ev.pi$mcD$sp();
    }

    public final float pi$mFc$sp(Trig<Object> ev) {
        return ev.pi$mcF$sp();
    }

    public final double sin$mDc$sp(double a, Trig<Object> ev) {
        return ev.sin$mcD$sp(a);
    }

    public final float sin$mFc$sp(float a, Trig<Object> ev) {
        return ev.sin$mcF$sp(a);
    }

    public final double cos$mDc$sp(double a, Trig<Object> ev) {
        return ev.cos$mcD$sp(a);
    }

    public final float cos$mFc$sp(float a, Trig<Object> ev) {
        return ev.cos$mcF$sp(a);
    }

    public final double tan$mDc$sp(double a, Trig<Object> ev) {
        return ev.tan$mcD$sp(a);
    }

    public final float tan$mFc$sp(float a, Trig<Object> ev) {
        return ev.tan$mcF$sp(a);
    }

    public final double asin$mDc$sp(double a, Trig<Object> ev) {
        return ev.asin$mcD$sp(a);
    }

    public final float asin$mFc$sp(float a, Trig<Object> ev) {
        return ev.asin$mcF$sp(a);
    }

    public final double acos$mDc$sp(double a, Trig<Object> ev) {
        return ev.acos$mcD$sp(a);
    }

    public final float acos$mFc$sp(float a, Trig<Object> ev) {
        return ev.acos$mcF$sp(a);
    }

    public final double atan$mDc$sp(double a, Trig<Object> ev) {
        return ev.atan$mcD$sp(a);
    }

    public final float atan$mFc$sp(float a, Trig<Object> ev) {
        return ev.atan$mcF$sp(a);
    }

    public final double atan2$mDc$sp(double y, double x, Trig<Object> ev) {
        return ev.atan2$mcD$sp(y, x);
    }

    public final float atan2$mFc$sp(float y, float x, Trig<Object> ev) {
        return ev.atan2$mcF$sp(y, x);
    }

    public final double sinh$mDc$sp(double x, Trig<Object> ev) {
        return ev.sinh$mcD$sp(x);
    }

    public final float sinh$mFc$sp(float x, Trig<Object> ev) {
        return ev.sinh$mcF$sp(x);
    }

    public final double cosh$mDc$sp(double x, Trig<Object> ev) {
        return ev.cosh$mcD$sp(x);
    }

    public final float cosh$mFc$sp(float x, Trig<Object> ev) {
        return ev.cosh$mcF$sp(x);
    }

    public final double tanh$mDc$sp(double x, Trig<Object> ev) {
        return ev.tanh$mcD$sp(x);
    }

    public final float tanh$mFc$sp(float x, Trig<Object> ev) {
        return ev.tanh$mcF$sp(x);
    }

    public final double hypot$mDc$sp(double x, double y, Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return s.gt$mcD$sp(x, y) ? f.times$mcD$sp(package$.abs$2(x, f, s), n.sqrt$mcD$sp(BoxesRunTime.unboxToDouble((Object)LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToDouble((double)f.pow$mcD$sp(f.div$mcD$sp(y, x), 2)), f)))) : f.times$mcD$sp(package$.abs$2(y, f, s), n.sqrt$mcD$sp(BoxesRunTime.unboxToDouble((Object)LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToDouble((double)f.pow$mcD$sp(f.div$mcD$sp(x, y), 2)), f))));
    }

    public final float hypot$mFc$sp(float x, float y, Field<Object> f, NRoot<Object> n, Signed<Object> s) {
        return s.gt$mcF$sp(x, y) ? f.times$mcF$sp(package$.abs$3(x, f, s), n.sqrt$mcF$sp(BoxesRunTime.unboxToFloat((Object)LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToFloat((float)f.pow$mcF$sp(f.div$mcF$sp(y, x), 2)), f)))) : f.times$mcF$sp(package$.abs$3(y, f, s), n.sqrt$mcF$sp(BoxesRunTime.unboxToFloat((Object)LiteralIntAdditiveSemigroupOps$.MODULE$.$plus$extension(implicits$.MODULE$.literalIntAdditiveSemigroupOps(1), BoxesRunTime.boxToFloat((float)f.pow$mcF$sp(f.div$mcF$sp(x, y), 2)), f))));
    }

    private final BigInt loop$1(long lo, long hi, BigInt prod) {
        while (lo <= hi) {
            prod = scala.package$.MODULE$.BigInt().apply(lo).$times(scala.package$.MODULE$.BigInt().apply(hi)).$times(prod);
            --hi;
            ++lo;
        }
        return prod;
    }

    private final BigInt loop$2(long lo, long hi, BigInt prod) {
        while (lo <= hi) {
            prod = scala.package$.MODULE$.BigInt().apply(lo).$times(scala.package$.MODULE$.BigInt().apply(hi)).$times(prod);
            --hi;
            ++lo;
        }
        return prod;
    }

    private final BigInt loop$3(BigInt a, BigInt b, int i, long n$1) {
        while (true) {
            BigInt c = a.$plus(b);
            if (i < 0) break;
            if ((n$1 >>> i & 1L) == 1L) {
                BigInt bigInt = a.$plus(c).$times(b);
                --i;
                b = b.$times(b).$plus(c.$times(c));
                a = bigInt;
                continue;
            }
            BigInt bigInt = a.$times(a).$plus(b.$times(b));
            --i;
            b = a.$plus(c).$times(b);
            a = bigInt;
        }
        return b;
    }

    private final BigDecimal power$1(BigDecimal result, BigDecimal base, BigInt exponent) {
        while (exponent.signum() != 0) {
            if (exponent.testBit(0)) {
                BigDecimal bigDecimal = result.$times(base);
                exponent = exponent.$greater$greater(1);
                base = base.$times(base);
                result = bigDecimal;
                continue;
            }
            exponent = exponent.$greater$greater(1);
            base = base.$times(base);
        }
        return result;
    }

    private final BigDecimal doit$1(int precision, int leeway, BigDecimal k$1) {
        BigDecimal sum;
        while (true) {
            MathContext mc = new MathContext(precision, RoundingMode.HALF_UP);
            int i = 2;
            sum = scala.package$.MODULE$.BigDecimal().apply(1, mc).$plus(k$1);
            BigDecimal factorial = scala.package$.MODULE$.BigDecimal().apply(2, mc);
            BigDecimal kpow = k$1.$times(k$1);
            BigDecimal term = kpow.$div(factorial).setScale(precision, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
            while (term.signum() != 0 && i < leeway) {
                sum = sum.$plus(term);
                factorial = factorial.$times(BigDecimal$.MODULE$.int2bigDecimal(++i));
                kpow = kpow.$times(k$1);
                term = kpow.$div(factorial).setScale(precision, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
            }
            if (i <= leeway) break;
            leeway *= 1000;
            precision += 3;
        }
        return sum.setScale(k$1.mc().getPrecision() - sum.precision() + sum.scale(), BigDecimal.RoundingMode$.MODULE$.FLOOR());
    }

    private final BigDecimal loop$4(BigDecimal x, BigDecimal n$2, BigDecimal limit$1) {
        BigDecimal xp;
        BigDecimal term;
        while ((term = (xp = this.exp(x)).$minus(n$2).$div(xp)).$greater((Object)limit$1)) {
            x = x.$minus(term);
        }
        return x.$minus(term);
    }

    private final BigDecimal ln$1(BigDecimal n, int scale$1) {
        int scale2 = scale$1 + 1;
        BigDecimal limit = scala.package$.MODULE$.BigDecimal().apply(5).$times(scala.package$.MODULE$.BigDecimal().apply(10).pow(-scale2));
        return this.loop$4(n.setScale(scale2, BigDecimal.RoundingMode$.MODULE$.HALF_UP()), n, limit).setScale(scale$1, BigDecimal.RoundingMode$.MODULE$.HALF_UP());
    }

    private final Tuple2 rescale$1(BigDecimal x, int n) {
        while (!x.$less((Object)BigDecimal$.MODULE$.int2bigDecimal(64))) {
            ++n;
            x = package$bigDecimal$.MODULE$.BigDecimalAlgebra().sqrt(x);
        }
        return new Tuple2((Object)x, (Object)BoxesRunTime.boxToInteger((int)n));
    }

    private final BigInt bigIntPow$1(BigInt t, BigInt b, BigInt e) {
        while (e.signum() != 0) {
            if (e.testBit(0)) {
                BigInt bigInt = t.$times(b);
                e = e.$greater$greater(1);
                b = b.$times(b);
                t = bigInt;
                continue;
            }
            e = e.$greater$greater(1);
            b = b.$times(b);
        }
        return t;
    }

    private final long longPow$1(long t, long b, long e) {
        while (e != 0L) {
            if ((e & 1L) == 1L) {
                long l = t * b;
                e >>= (int)1L;
                b *= b;
                t = l;
                continue;
            }
            e >>= (int)1L;
            b *= b;
        }
        return t;
    }

    private static final Object abs$1(Object n, Field f$1, Signed s$1) {
        return s$1.lt(n, f$1.zero()) ? f$1.negate(n) : n;
    }

    public static final /* synthetic */ BigInt $anonfun$undigitize$1(int r$2, BigInt x$5, int x$6) {
        return x$5.$times(BigInt$.MODULE$.int2bigInt(r$2)).$plus(BigInt$.MODULE$.int2bigInt(x$6));
    }

    private final Tuple2 findRoot$1(Stream digits, BigInt y, BigInt r, int i, int k$2, BigInt radixPowK$1, int maxSize$1) {
        BigInt ny;
        while (true) {
            BigInt y_ = y.$times(BigInt$.MODULE$.int2bigInt(this.radix()));
            BigInt a = this.undigitize((Seq<Object>)digits.take(k$2), this.radix());
            BigInt target = radixPowK$1.$times(r).$plus(a).$plus(y_.pow(k$2));
            int b2 = this.intSearch((Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)b -> y_.$plus(BigInt$.MODULE$.int2bigInt(b)).pow(k$2).$less$eq((Object)target));
            ny = y_.$plus(BigInt$.MODULE$.int2bigInt(b2));
            if (i == maxSize$1) break;
            BigInt nr = target.$minus(ny.pow(k$2));
            ++i;
            r = nr;
            y = ny;
            digits = digits.drop(k$2);
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)i), (Object)ny);
    }

    private static final double abs$2(double n, Field f$3, Signed s$2) {
        return s$2.lt$mcD$sp(n, f$3.zero$mcD$sp()) ? f$3.negate$mcD$sp(n) : n;
    }

    private static final float abs$3(float n, Field f$4, Signed s$3) {
        return s$3.lt$mcF$sp(n, f$4.zero$mcF$sp()) ? f$4.negate$mcF$sp(n) : n;
    }

    private package$() {
        MODULE$ = this;
        this.radix = 1000000000;
    }
}

