/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.expr;

import java.util.LinkedList;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.expr.ConstantTermExpression;
import org.topbraid.shacl.expr.FilterShapeExpression;
import org.topbraid.shacl.expr.FocusNodeExpression;
import org.topbraid.shacl.expr.FunctionExpression;
import org.topbraid.shacl.expr.IntersectionExpression;
import org.topbraid.shacl.expr.NodeExpression;
import org.topbraid.shacl.expr.PathExpression;
import org.topbraid.shacl.expr.UnionExpression;
import org.topbraid.shacl.vocabulary.SH;

public class NodeExpressionFactory {
    private static NodeExpressionFactory singleton = new NodeExpressionFactory();

    public static NodeExpressionFactory get() {
        return singleton;
    }

    public static void set(NodeExpressionFactory value) {
        singleton = value;
    }

    public NodeExpression create(RDFNode node) {
        if (SH.this_.equals((Object)node)) {
            return new FocusNodeExpression();
        }
        if (node.isURIResource() || node.isLiteral()) {
            return new ConstantTermExpression(node);
        }
        Resource resource = node.asResource();
        Resource filterShape = JenaUtil.getResourceProperty(resource, SH.filterShape);
        Statement nodesS = resource.getProperty(SH.nodes);
        if (filterShape != null && nodesS != null) {
            NodeExpression nodes = this.create(nodesS.getObject());
            return new FilterShapeExpression(nodes, filterShape);
        }
        Resource path = JenaUtil.getResourceProperty(resource, SH.path);
        if (path != null) {
            NodeExpression nodes = nodesS != null ? this.create(nodesS.getObject()) : null;
            return new PathExpression(path, nodes);
        }
        Resource union = JenaUtil.getResourceProperty(resource, SH.union);
        if (union != null) {
            LinkedList<NodeExpression> inputs = new LinkedList<NodeExpression>();
            RDFList list = (RDFList)union.as(RDFList.class);
            for (RDFNode member : list.iterator().toList()) {
                inputs.add(this.create(member));
            }
            return new UnionExpression(inputs);
        }
        Resource intersection = JenaUtil.getResourceProperty(resource, SH.intersection);
        if (intersection != null) {
            LinkedList<NodeExpression> inputs = new LinkedList<NodeExpression>();
            RDFList list = (RDFList)intersection.as(RDFList.class);
            for (RDFNode member : list.iterator().toList()) {
                inputs.add(this.create(member));
            }
            return new IntersectionExpression(inputs);
        }
        Statement s = this.getFunctionStatement(resource);
        if (s != null) {
            LinkedList<NodeExpression> args = new LinkedList<NodeExpression>();
            RDFList list = (RDFList)s.getResource().as(RDFList.class);
            for (RDFNode member : list.iterator().toList()) {
                args.add(this.create(member));
            }
            return new FunctionExpression((Resource)s.getPredicate(), args);
        }
        throw new IllegalArgumentException("Malformed SHACL node expression");
    }

    public Statement getFunctionStatement(Resource resource) {
        for (Statement sc : resource.listProperties().toList()) {
            if (!RDF.nil.equals((Object)sc.getObject()) && (!sc.getObject().isAnon() || !sc.getResource().hasProperty(RDF.first))) continue;
            return sc;
        }
        return null;
    }
}

