/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.bat.APIs;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.cache.CacheBuilder;
import com.mulesoft.bat.APIs.Http$;
import com.mulesoft.bat.APIs.Secret;
import com.mulesoft.bat.lambda.HttpLink;
import com.mulesoft.bat.lambda.Response;
import com.mulesoft.bat.runner.BATLoggingService;
import com.mulesoft.bat.runner.BATLoggingService$;
import com.mulesoft.bat.runner.BatSecret;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class WorkerAPI$ {
    public static WorkerAPI$ MODULE$;
    private BATLoggingService logger;
    private String coreServicesEndpoint;
    private String workerAPIEndpoint;
    private final HttpLink http;
    private final scala.collection.concurrent.Map<String, File> artifactsCache;

    static {
        new WorkerAPI$();
    }

    public BATLoggingService logger() {
        return this.logger;
    }

    public void logger_$eq(BATLoggingService x$1) {
        this.logger = x$1;
    }

    public String coreServicesEndpoint() {
        return this.coreServicesEndpoint;
    }

    public void coreServicesEndpoint_$eq(String x$1) {
        this.coreServicesEndpoint = x$1;
    }

    public String workerAPIEndpoint() {
        return this.workerAPIEndpoint;
    }

    public void workerAPIEndpoint_$eq(String x$1) {
        this.workerAPIEndpoint = x$1;
    }

    public HttpLink http() {
        return this.http;
    }

    public scala.collection.immutable.Map<String, BatSecret> getSecrets(scala.collection.immutable.Map<String, BatSecret> secretsInfo) {
        scala.collection.immutable.Map map;
        try {
            map = (scala.collection.immutable.Map)secretsInfo.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x0$1;
                if (tuple22 != null) {
                    String alias = (String)tuple22._1();
                    BatSecret info = (BatSecret)tuple22._2();
                    String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/environments/", "/secretGroups/", "/secrets/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.workerAPIEndpoint(), info.getOrg(), info.getEnv(), info.getGroup(), info.getSecretId()}));
                    MODULE$.logger().logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
                    Response response = MODULE$.http().get(new URL(url), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"X-Anypoint-Access-Grant"), (Object)info.getGrant())}))).asJava());
                    MODULE$.logger().logDebug(response);
                    if (response.getStatus() != 200) {
                        MODULE$.logger().logError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error getting secret for secretId: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{info.getSecretId()})));
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)alias), (Object)info);
                    } else {
                        Secret s = Http$.MODULE$.parseResponseJson(response, new TypeReference<Secret>(){});
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)alias), (Object)new BatSecret(info.getName(), info.getEnv(), info.getOrg(), info.getGroup(), info.getSecretId(), info.getGrant(), s.key()));
                    }
                } else {
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple23 = tuple2;
                return tuple23;
            }, Map$.MODULE$.canBuildFrom());
        }
        catch (Throwable e) {
            this.logger().logError(e);
            throw e;
        }
        return map;
    }

    public scala.collection.concurrent.Map<String, File> artifactsCache() {
        return this.artifactsCache;
    }

    public <K, V> ConcurrentMap<K, V> buildCache() {
        return CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(60L, TimeUnit.MINUTES).concurrencyLevel(10).build().asMap();
    }

    public File getArtifact(String organizationId, String artifactId, String executionId, String testId, String token, Option<String> targetId, Option<String> targetSecret) {
        File file;
        File localFile = File.createTempFile("bat-executable", artifactId);
        localFile.deleteOnExit();
        try {
            File file2;
            String string = artifactId;
            if (this.artifactsCache().get((Object)artifactId).isDefined()) {
                this.setStatus(organizationId, executionId, testId, token, "RUNNING");
                file2 = (File)Option$.MODULE$.option2Iterable(this.artifactsCache().get((Object)artifactId)).head();
            } else {
                file2 = this.getArtifactNow(localFile, organizationId, artifactId, executionId, testId, token, targetId, targetSecret);
            }
            file = file2;
        }
        catch (Throwable e) {
            this.logger().logError(e);
            this.setStatus(organizationId, executionId, testId, token, "ERROR");
            throw e;
        }
        return file;
    }

    public Option<String> getArtifact$default$6() {
        return None$.MODULE$;
    }

    public Option<String> getArtifact$default$7() {
        return None$.MODULE$;
    }

    public File getArtifactNow(File localFile, String organizationId, String artifactId, String executionId, String testId, String token, Option<String> targetId, Option<String> targetSecret) {
        File file;
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/tests/", "/executions/", "/artifacts/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.workerAPIEndpoint(), organizationId, testId, executionId, artifactId}));
        this.logger().logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GET ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        if (targetId.isDefined() && targetSecret.isDefined()) {
            java.util.Map headers = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"X-TARGET-SECRET"), targetSecret.get()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"X-TARGET-ID"), targetId.get())}))).asJava();
            file = this.http().downloadWithHeaders(new URL(url), localFile, token, headers);
        } else {
            file = this.http().download(new URL(url), localFile, token);
        }
        Predef$.MODULE$.assert(localFile.length() > 0L, (Function0 & Serializable & scala.Serializable)() -> "Downloaded artifact must have content");
        this.setStatus(organizationId, executionId, testId, token, "RUNNING");
        Object object = localFile.length() > 0L ? this.artifactsCache().put((Object)artifactId, (Object)localFile) : BoxedUnit.UNIT;
        return localFile;
    }

    public Option<String> getArtifactNow$default$7() {
        return None$.MODULE$;
    }

    public Option<String> getArtifactNow$default$8() {
        return None$.MODULE$;
    }

    public boolean uploadResult(String organizationId, String executionId, String testId, byte[] result, Option<byte[]> analytics, String token, Option<String> targetId, Option<String> targetSecret) {
        boolean bl;
        scala.collection.immutable.Map map = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"result"), (Object)result)}));
        if (analytics.isDefined()) {
            map = map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"analytics"), analytics.get()));
        }
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/tests/", "/executions/", "/result"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.workerAPIEndpoint(), organizationId, testId, executionId}));
        this.logger().logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"POST ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        if (targetId.isDefined() && targetSecret.isDefined()) {
            java.util.Map headers = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"X-TARGET-SECRET"), targetSecret.get()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"X-TARGET-ID"), targetId.get())}))).asJava();
            Response res = this.http().uploadWithHeaders(new URL(url), JavaConverters$.MODULE$.mapAsJavaMap((Map)map), token, headers);
            boolean success = res.getStatus() == 200 || res.getStatus() == 201;
            this.logger().logDebug(res);
            bl = success;
        } else {
            Response res = this.http().upload(new URL(url), JavaConverters$.MODULE$.mapAsJavaMap((Map)map), token);
            boolean success = res.getStatus() == 200 || res.getStatus() == 201;
            this.logger().logDebug(res);
            bl = success;
        }
        return bl;
    }

    public Option<String> uploadResult$default$7() {
        return None$.MODULE$;
    }

    public Option<String> uploadResult$default$8() {
        return None$.MODULE$;
    }

    public boolean setStatus(String organizationId, String executionId, String testId, String token, String status) {
        scala.collection.immutable.Map valueToSend = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status"), (Object)status)}));
        String url = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/v1/organizations/", "/tests/", "/executions/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.workerAPIEndpoint(), organizationId, testId, executionId}));
        this.logger().logDebug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PUT ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url})));
        Response res = Http$.MODULE$.putJson(url, valueToSend, token);
        boolean success = res.getStatus() == 200 || res.getStatus() == 201;
        this.logger().logDebug(res);
        return success;
    }

    private WorkerAPI$() {
        MODULE$ = this;
        this.logger = BATLoggingService$.MODULE$;
        this.coreServicesEndpoint = "https://anypoint.mulesoft.com";
        this.workerAPIEndpoint = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https://bat-worker.cloudhub.io"})).s((Seq)Nil$.MODULE$);
        this.http = new HttpLink();
        this.artifactsCache = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.buildCache()).asScala();
    }
}

