/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpWalker;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.optimize.ExprTransformConstantFold;
import org.apache.jena.sparql.algebra.optimize.OpVisitorExprPrepare;
import org.apache.jena.sparql.algebra.optimize.Optimize;
import org.apache.jena.sparql.algebra.optimize.Rewrite;
import org.apache.jena.sparql.algebra.optimize.TransformDistinctToReduced;
import org.apache.jena.sparql.algebra.optimize.TransformEliminateAssignments;
import org.apache.jena.sparql.algebra.optimize.TransformExpandOneOf;
import org.apache.jena.sparql.algebra.optimize.TransformExtendCombine;
import org.apache.jena.sparql.algebra.optimize.TransformFilterConjunction;
import org.apache.jena.sparql.algebra.optimize.TransformFilterDisjunction;
import org.apache.jena.sparql.algebra.optimize.TransformFilterEquality;
import org.apache.jena.sparql.algebra.optimize.TransformFilterImplicitJoin;
import org.apache.jena.sparql.algebra.optimize.TransformFilterInequality;
import org.apache.jena.sparql.algebra.optimize.TransformFilterPlacement;
import org.apache.jena.sparql.algebra.optimize.TransformFilterPlacementConservative;
import org.apache.jena.sparql.algebra.optimize.TransformImplicitLeftJoin;
import org.apache.jena.sparql.algebra.optimize.TransformJoinStrategy;
import org.apache.jena.sparql.algebra.optimize.TransformMergeBGPs;
import org.apache.jena.sparql.algebra.optimize.TransformOrderByDistinctApplication;
import org.apache.jena.sparql.algebra.optimize.TransformPathFlattern;
import org.apache.jena.sparql.algebra.optimize.TransformPromoteTableEmpty;
import org.apache.jena.sparql.algebra.optimize.TransformPropertyFunction;
import org.apache.jena.sparql.algebra.optimize.TransformReorder;
import org.apache.jena.sparql.algebra.optimize.TransformScopeRename;
import org.apache.jena.sparql.algebra.optimize.TransformTopN;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizerStd
implements Rewrite {
    private static Logger log = LoggerFactory.getLogger(Optimize.class);
    private final Context context;
    public static final Symbol filterPlacementOldName = SystemARQ.allocSymbol("filterPlacement");

    public OptimizerStd(Context context) {
        this.context = context;
    }

    @Override
    public Op rewrite(Op op) {
        if (this.context.get(ARQConstants.sysOptimizer) == null) {
            this.context.set(ARQConstants.sysOptimizer, this);
        }
        if (this.context.isDefined(filterPlacementOldName) && this.context.isUndef(ARQ.optFilterPlacement)) {
            this.context.set(ARQ.optFilterPlacement, this.context.get(filterPlacementOldName));
        }
        op = TransformScopeRename.transform(op);
        OpWalker.walk(op, new OpVisitorExprPrepare(this.context));
        if (this.context.isTrueOrUndef(ARQ.optPathFlatten)) {
            op = OptimizerStd.apply("Path flattening", new TransformPathFlattern(), op);
            if (this.context.isTrueOrUndef(ARQ.optMergeBGPs)) {
                op = OptimizerStd.apply("Merge BGPs", new TransformMergeBGPs(), op);
            }
        }
        if (this.context.isTrueOrUndef(ARQ.optExprConstantFolding)) {
            op = this.transformExprConstantFolding(op);
        }
        if (this.context.isTrueOrUndef(ARQ.propertyFunctions)) {
            op = this.transformPropertyFunctions(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optFilterConjunction)) {
            op = this.transformFilterConjunction(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optFilterExpandOneOf)) {
            op = this.transformFilterExpandOneOf(op);
        }
        if (this.context.isTrue(ARQ.optInlineAssignments)) {
            op = this.transformInlineAssignments(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optFilterImplicitJoin)) {
            op = this.transformFilterImplicitJoin(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optImplicitLeftJoin)) {
            op = this.transformFilterImplicitLeftJoin(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optFilterDisjunction)) {
            op = this.transformFilterDisjunction(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optTopNSorting)) {
            op = this.transformTopNSorting(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optOrderByDistinctApplication)) {
            op = this.transformOrderByDistinctApplication(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optDistinctToReduced)) {
            op = this.transformDistinctToReduced(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optIndexJoinStrategy)) {
            op = this.transformJoinStrategy(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optFilterPlacement)) {
            op = this.transformFilterPlacement(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optFilterEquality)) {
            op = this.transformFilterEquality(op);
        }
        if (this.context.isTrue(ARQ.optFilterInequality)) {
            op = this.transformFilterInequality(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optPromoteTableEmpty)) {
            op = this.transformPromoteTableEmpty(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optMergeBGPs)) {
            op = this.transformMergeBGPs(op);
        }
        if (this.context.isTrue(ARQ.optReorderBGP)) {
            op = this.transformReorder(op);
        }
        if (this.context.isTrueOrUndef(ARQ.optMergeExtends)) {
            op = this.transformExtendCombine(op);
        }
        return op;
    }

    protected Op transformExprConstantFolding(Op op) {
        return Transformer.transform(new TransformCopy(), new ExprTransformConstantFold(), op);
    }

    protected Op transformPropertyFunctions(Op op) {
        return OptimizerStd.apply("Property Functions", new TransformPropertyFunction(this.context), op);
    }

    protected Op transformFilterConjunction(Op op) {
        return OptimizerStd.apply("filter conjunctions to ExprLists", new TransformFilterConjunction(), op);
    }

    protected Op transformFilterExpandOneOf(Op op) {
        return OptimizerStd.apply("Break up IN and NOT IN", new TransformExpandOneOf(), op);
    }

    protected Op transformInlineAssignments(Op op) {
        return TransformEliminateAssignments.eliminate(op, this.context.isTrue(ARQ.optInlineAssignmentsAggressive));
    }

    protected Op transformFilterImplicitJoin(Op op) {
        return OptimizerStd.apply("Filter Implicit Join", new TransformFilterImplicitJoin(), op);
    }

    protected Op transformFilterImplicitLeftJoin(Op op) {
        return OptimizerStd.apply("Implicit Left Join", new TransformImplicitLeftJoin(), op);
    }

    protected Op transformFilterDisjunction(Op op) {
        return OptimizerStd.apply("Filter Disjunction", new TransformFilterDisjunction(), op);
    }

    protected Op transformTopNSorting(Op op) {
        return OptimizerStd.apply("TopN Sorting", new TransformTopN(), op);
    }

    protected Op transformOrderByDistinctApplication(Op op) {
        return OptimizerStd.apply("Apply DISTINCT prior to ORDER BY where possible", new TransformOrderByDistinctApplication(), op);
    }

    protected Op transformDistinctToReduced(Op op) {
        return OptimizerStd.apply("Distinct replaced with reduced", new TransformDistinctToReduced(), op);
    }

    protected Op transformJoinStrategy(Op op) {
        return OptimizerStd.apply("Index Join strategy", new TransformJoinStrategy(), op);
    }

    protected Op transformFilterPlacement(Op op) {
        if (this.context.isTrue(ARQ.optFilterPlacementConservative)) {
            op = OptimizerStd.apply("Filter Placement (conservative)", new TransformFilterPlacementConservative(), op);
        } else {
            boolean b = this.context.isTrueOrUndef(ARQ.optFilterPlacementBGP);
            op = OptimizerStd.apply("Filter Placement", new TransformFilterPlacement(b), op);
        }
        return op;
    }

    protected Op transformFilterEquality(Op op) {
        return OptimizerStd.apply("Filter Equality", new TransformFilterEquality(), op);
    }

    protected Op transformFilterInequality(Op op) {
        return OptimizerStd.apply("Filter Inequality", new TransformFilterInequality(), op);
    }

    protected Op transformPromoteTableEmpty(Op op) {
        return OptimizerStd.apply("Table Empty Promotion", new TransformPromoteTableEmpty(), op);
    }

    protected Op transformMergeBGPs(Op op) {
        return OptimizerStd.apply("Merge BGPs", new TransformMergeBGPs(), op);
    }

    protected Op transformReorder(Op op) {
        return OptimizerStd.apply("ReorderMerge BGPs", new TransformReorder(), op);
    }

    protected Op transformExtendCombine(Op op) {
        return OptimizerStd.apply("Combine BIND/LET", new TransformExtendCombine(), op);
    }

    public static Op apply(Transform transform, Op op) {
        Op op2 = Transformer.transformSkipService(transform, op);
        if (op2 != op) {
            return op2;
        }
        return op;
    }

    public static Op apply(String label, Transform transform, Op op) {
        Op op2 = Transformer.transformSkipService(transform, op);
        boolean debug2 = false;
        if (op2 != op) {
            return op2;
        }
        return op;
    }
}

