/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.rules;

import java.util.List;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.rules.RuleEngine;
import org.topbraid.shacl.vocabulary.SH;

public abstract class Rule {
    private Number order;
    private Resource resource;

    protected Rule(Resource resource) {
        this.resource = resource;
        this.order = 0;
        Statement s = resource.getProperty(SH.order);
        if (s != null && s.getObject().isLiteral()) {
            this.order = (Number)s.getLiteral().getValue();
        }
    }

    public abstract void execute(RuleEngine var1, List<RDFNode> var2, Shape var3);

    public String getLabel() {
        Statement s = this.resource.getProperty(RDFS.label);
        if (s != null && s.getObject().isLiteral()) {
            return s.getString();
        }
        return null;
    }

    public String getLabelStart(String type) {
        Number index = this.getOrder();
        return type + " rule (" + (index.doubleValue() == 0.0 ? "0" : index) + "): ";
    }

    public Number getOrder() {
        return this.order;
    }

    public Resource getResource() {
        return this.resource;
    }
}

