/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateRequest;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.Ask;
import org.topbraid.spin.model.Command;
import org.topbraid.spin.model.CommandWithWhere;
import org.topbraid.spin.model.Construct;
import org.topbraid.spin.model.Query;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Template;
import org.topbraid.spin.model.TemplateCall;
import org.topbraid.spin.system.SPINLabels;
import org.topbraid.spin.util.CommandWrapper;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.util.NestedQueries;
import org.topbraid.spin.util.QueryWrapper;
import org.topbraid.spin.util.SPINUtil;
import org.topbraid.spin.util.UpdateWrapper;
import org.topbraid.spin.vocabulary.SPIN;

public class SPINQueryFinder {
    public static void add(Map<Resource, List<CommandWrapper>> class2Query, Statement s, Model model, boolean withClass, boolean allowAsk) {
        if (!s.getObject().isResource()) {
            return;
        }
        String spinQueryText = null;
        String label = null;
        TemplateCall templateCall = SPINFactory.asTemplateCall((RDFNode)s.getResource());
        if (templateCall != null) {
            Template baseTemplate = templateCall.getTemplate();
            if (baseTemplate != null) {
                for (Resource superClass : JenaUtil.getAllSuperClassesStar(baseTemplate)) {
                    Map<String, RDFNode> bindings;
                    CommandWrapper wrapper;
                    if (!JenaUtil.hasIndirectType(superClass, SPIN.Template)) continue;
                    Template template = SPINFactory.asTemplate(superClass);
                    Command body = template.getBody();
                    Command spinCommand = null;
                    if (body instanceof Construct || allowAsk && body instanceof Ask) {
                        spinCommand = body;
                    } else if (body instanceof org.topbraid.spin.model.update.Update) {
                        spinCommand = body;
                    }
                    if (spinCommand == null || (wrapper = SPINQueryFinder.createCommandWrapper(class2Query, s, withClass, allowAsk, spinQueryText, label = (spinQueryText = SPINLabels.get().getLabel(templateCall)), spinCommand, templateCall)) == null || !SPINQueryFinder.hasAllNonOptionalArguments(template, bindings = templateCall.getArgumentsMapByVarNames())) continue;
                    if (!bindings.isEmpty()) {
                        wrapper.setTemplateBinding(bindings);
                    }
                    SPINQueryFinder.addCommandWrapper(class2Query, s, wrapper);
                }
            }
        } else {
            CommandWrapper wrapper;
            Command spinCommand = SPINFactory.asCommand(s.getResource());
            if (spinCommand != null && (wrapper = SPINQueryFinder.createCommandWrapper(class2Query, s, withClass, allowAsk, spinQueryText, label = spinCommand.getComment(), spinCommand, spinCommand)) != null) {
                SPINQueryFinder.addCommandWrapper(class2Query, s, wrapper);
            }
        }
    }

    private static void addCommandWrapper(Map<Resource, List<CommandWrapper>> class2Query, Statement s, CommandWrapper wrapper) {
        Resource type = s.getSubject();
        List<CommandWrapper> list = class2Query.get(type);
        if (list == null) {
            list = new LinkedList<CommandWrapper>();
            class2Query.put(type, list);
        }
        list.add(wrapper);
    }

    private static CommandWrapper createCommandWrapper(Map<Resource, List<CommandWrapper>> class2Query, Statement s, boolean withClass, boolean allowAsk, String spinQueryText, String label, Command spinCommand, Resource source) {
        String queryString = ARQFactory.get().createCommandString(spinCommand);
        boolean thisUnbound = spinCommand.hasProperty(SPIN.thisUnbound, (RDFNode)JenaDatatypes.TRUE);
        if (spinQueryText == null) {
            spinQueryText = queryString;
        }
        CommandWrapper wrapper = null;
        if (spinCommand instanceof Query) {
            org.apache.jena.query.Query arqQuery = ARQFactory.get().createQuery(queryString);
            if (arqQuery.isConstructType() || allowAsk && arqQuery.isAskType()) {
                boolean thisDeep = NestedQueries.hasNestedBlocksUsingThis(arqQuery.getQueryPattern());
                if (!thisUnbound && withClass && !thisDeep && SPINUtil.containsThis((CommandWithWhere)spinCommand)) {
                    queryString = SPINUtil.addThisTypeClause(queryString);
                    arqQuery = ARQFactory.get().createQuery(queryString);
                }
                wrapper = new QueryWrapper(arqQuery, source, spinQueryText, (Query)spinCommand, label, s, thisUnbound, thisDeep);
            }
        } else if (spinCommand instanceof org.topbraid.spin.model.update.Update) {
            UpdateRequest updateRequest = ARQFactory.get().createUpdateRequest(queryString);
            Update operation = (Update)updateRequest.getOperations().get(0);
            boolean thisDeep = NestedQueries.hasNestedBlocksUsingThis(operation);
            if (!thisUnbound && withClass && !thisDeep && SPINUtil.containsThis((CommandWithWhere)spinCommand)) {
                queryString = SPINUtil.addThisTypeClause(queryString);
                updateRequest = ARQFactory.get().createUpdateRequest(queryString);
                operation = (Update)updateRequest.getOperations().get(0);
            }
            wrapper = new UpdateWrapper(operation, source, spinQueryText, (org.topbraid.spin.model.update.Update)spinCommand, label, s, thisUnbound, thisDeep);
        }
        return wrapper;
    }

    public static Map<Resource, List<CommandWrapper>> getClass2QueryMap(Model model, Model queryModel, Property predicate, boolean withClass, boolean allowAsk) {
        return SPINQueryFinder.getClass2QueryMap(model, queryModel, predicate, withClass, allowAsk, null);
    }

    public static Map<Resource, List<CommandWrapper>> getClass2QueryMap(Model model, Model queryModel, Property predicate, boolean withClass, boolean allowAsk, Predicate<Resource> filter) {
        predicate = model.getProperty(predicate.getURI());
        HashMap<Resource, List<CommandWrapper>> class2Query = new HashMap<Resource, List<CommandWrapper>>();
        for (Statement s : JenaUtil.listAllProperties(null, predicate).toList()) {
            if (!s.getObject().isResource() || filter != null && !filter.test(s.getResource())) continue;
            SPINQueryFinder.add(class2Query, s, model, withClass, allowAsk);
        }
        return class2Query;
    }

    private static boolean hasAllNonOptionalArguments(Template template, Map<String, RDFNode> bindings) {
        for (Argument arg : template.getArguments(false)) {
            if (arg.isOptional() || bindings.containsKey(arg.getVarName())) continue;
            return false;
        }
        return true;
    }
}

