/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.builders;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.E_Add;
import org.apache.jena.sparql.expr.E_BNode;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_Call;
import org.apache.jena.sparql.expr.E_Coalesce;
import org.apache.jena.sparql.expr.E_Conditional;
import org.apache.jena.sparql.expr.E_Datatype;
import org.apache.jena.sparql.expr.E_DateTimeDay;
import org.apache.jena.sparql.expr.E_DateTimeHours;
import org.apache.jena.sparql.expr.E_DateTimeMinutes;
import org.apache.jena.sparql.expr.E_DateTimeMonth;
import org.apache.jena.sparql.expr.E_DateTimeSeconds;
import org.apache.jena.sparql.expr.E_DateTimeTZ;
import org.apache.jena.sparql.expr.E_DateTimeTimezone;
import org.apache.jena.sparql.expr.E_DateTimeYear;
import org.apache.jena.sparql.expr.E_Divide;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.E_GreaterThan;
import org.apache.jena.sparql.expr.E_GreaterThanOrEqual;
import org.apache.jena.sparql.expr.E_IRI;
import org.apache.jena.sparql.expr.E_IsBlank;
import org.apache.jena.sparql.expr.E_IsIRI;
import org.apache.jena.sparql.expr.E_IsLiteral;
import org.apache.jena.sparql.expr.E_IsNumeric;
import org.apache.jena.sparql.expr.E_IsURI;
import org.apache.jena.sparql.expr.E_Lang;
import org.apache.jena.sparql.expr.E_LangMatches;
import org.apache.jena.sparql.expr.E_LessThan;
import org.apache.jena.sparql.expr.E_LessThanOrEqual;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_MD5;
import org.apache.jena.sparql.expr.E_Multiply;
import org.apache.jena.sparql.expr.E_NotEquals;
import org.apache.jena.sparql.expr.E_NotExists;
import org.apache.jena.sparql.expr.E_NotOneOf;
import org.apache.jena.sparql.expr.E_Now;
import org.apache.jena.sparql.expr.E_NumAbs;
import org.apache.jena.sparql.expr.E_NumCeiling;
import org.apache.jena.sparql.expr.E_NumFloor;
import org.apache.jena.sparql.expr.E_NumRound;
import org.apache.jena.sparql.expr.E_OneOf;
import org.apache.jena.sparql.expr.E_Random;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.E_SHA1;
import org.apache.jena.sparql.expr.E_SHA224;
import org.apache.jena.sparql.expr.E_SHA256;
import org.apache.jena.sparql.expr.E_SHA384;
import org.apache.jena.sparql.expr.E_SHA512;
import org.apache.jena.sparql.expr.E_SameTerm;
import org.apache.jena.sparql.expr.E_Str;
import org.apache.jena.sparql.expr.E_StrAfter;
import org.apache.jena.sparql.expr.E_StrBefore;
import org.apache.jena.sparql.expr.E_StrConcat;
import org.apache.jena.sparql.expr.E_StrContains;
import org.apache.jena.sparql.expr.E_StrDatatype;
import org.apache.jena.sparql.expr.E_StrEncodeForURI;
import org.apache.jena.sparql.expr.E_StrEndsWith;
import org.apache.jena.sparql.expr.E_StrLang;
import org.apache.jena.sparql.expr.E_StrLength;
import org.apache.jena.sparql.expr.E_StrLowerCase;
import org.apache.jena.sparql.expr.E_StrReplace;
import org.apache.jena.sparql.expr.E_StrStartsWith;
import org.apache.jena.sparql.expr.E_StrSubstring;
import org.apache.jena.sparql.expr.E_StrUUID;
import org.apache.jena.sparql.expr.E_StrUpperCase;
import org.apache.jena.sparql.expr.E_Subtract;
import org.apache.jena.sparql.expr.E_URI;
import org.apache.jena.sparql.expr.E_UUID;
import org.apache.jena.sparql.expr.E_UnaryMinus;
import org.apache.jena.sparql.expr.E_UnaryPlus;
import org.apache.jena.sparql.expr.E_Version;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorFactory;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.builders.BuilderLib;
import org.apache.jena.sparql.sse.builders.BuilderNode;
import org.apache.jena.sparql.sse.builders.BuilderOp;
import org.apache.jena.sparql.util.NodeUtils;

public class BuilderExpr {
    protected Map<String, Build> dispatch = new HashMap<String, Build>();
    protected final Build buildRegex = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, 4, list, "Regex: wanted 2 or 3 arguments");
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            Expr pattern = BuilderExpr.buildExpr(list.get(2));
            Expr flags = null;
            if (list.size() != 3) {
                flags = BuilderExpr.buildExpr(list.get(3));
            }
            return new E_Regex(expr, pattern, flags);
        }
    };
    protected final Build buildPlus = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, 3, list, "+: wanted 1 or 2 arguments");
            if (list.size() == 2) {
                Expr ex = BuilderExpr.buildExpr(list.get(1));
                return new E_UnaryPlus(ex);
            }
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Add(left, right);
        }
    };
    protected final Build buildUnaryPlus = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "unaryplus: wanted 1 argument");
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_UnaryPlus(ex);
        }
    };
    protected final Build buildMinus = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, 3, list, "-: wanted 1 or 2 arguments");
            if (list.size() == 2) {
                Expr ex = BuilderExpr.buildExpr(list.get(1));
                return new E_UnaryMinus(ex);
            }
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Subtract(left, right);
        }
    };
    protected final Build buildUnaryMinus = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "unaryminus: wanted 1 argument");
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_UnaryMinus(ex);
        }
    };
    protected final Build buildEQ = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "=: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Equals(left, right);
        }
    };
    protected final Build buildNE = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "!=: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_NotEquals(left, right);
        }
    };
    protected final Build buildGT = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, ">: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_GreaterThan(left, right);
        }
    };
    protected final Build buildLT = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "<: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LessThan(left, right);
        }
    };
    protected final Build buildLE = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "<=: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LessThanOrEqual(left, right);
        }
    };
    protected final Build buildGE = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, ">=: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_GreaterThanOrEqual(left, right);
        }
    };
    protected final Build buildOr = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "||: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LogicalOr(left, right);
        }
    };
    protected final Build buildAnd = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "&&: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LogicalAnd(left, right);
        }
    };
    protected final Build buildMult = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "*: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Multiply(left, right);
        }
    };
    protected final Build buildDiv = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "/: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_Divide(left, right);
        }
    };
    protected final Build buildNot = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "!: wanted 1 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_LogicalNot(ex);
        }
    };
    protected final Build buildStr = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "str: wanted 1 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_Str(ex);
        }
    };
    protected final Build buildStrLang = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "strlang: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrLang(ex1, ex2);
        }
    };
    protected final Build buildStrDatatype = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "strlang: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrDatatype(ex1, ex2);
        }
    };
    protected final Build buildRand = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(1, list, "rand: wanted 0 arguments: got: " + BuilderExpr.numArgs(list));
            return new E_Random();
        }
    };
    protected final Build buildYear = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "year: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeYear(ex);
        }
    };
    protected final Build buildMonth = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "month: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeMonth(ex);
        }
    };
    protected final Build buildDay = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "day: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeDay(ex);
        }
    };
    protected final Build buildHours = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "hours: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeHours(ex);
        }
    };
    protected final Build buildMinutes = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "minutes: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeMinutes(ex);
        }
    };
    protected final Build buildSeconds = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "seconds: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeSeconds(ex);
        }
    };
    protected final Build buildTimezone = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "timezone: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeTimezone(ex);
        }
    };
    protected final Build buildTZ = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "TZ: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_DateTimeTZ(ex);
        }
    };
    protected final Build buildNow = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(1, list, "now: wanted 0 arguments: got: " + BuilderExpr.numArgs(list));
            return new E_Now();
        }
    };
    protected final Build buildUUID = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(1, list, "uuid: wanted 0 arguments: got: " + BuilderExpr.numArgs(list));
            return new E_UUID();
        }
    };
    protected final Build buildStrUUID = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(1, list, "struuid: wanted 0 arguments: got: " + BuilderExpr.numArgs(list));
            return new E_StrUUID();
        }
    };
    protected final Build buildVersion = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(1, list, "version: wanted 0 arguments: got: " + BuilderExpr.numArgs(list));
            return new E_Version();
        }
    };
    protected final Build buildMD5 = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "md5: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_MD5(ex);
        }
    };
    protected final Build buildSHA1 = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "md5: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_SHA1(ex);
        }
    };
    protected final Build buildSHA224 = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "md5: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_SHA224(ex);
        }
    };
    protected final Build buildSHA256 = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "md5: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_SHA256(ex);
        }
    };
    protected final Build buildSHA384 = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "md5: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_SHA384(ex);
        }
    };
    protected final Build buildSHA512 = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "md5: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_SHA512(ex);
        }
    };
    protected final Build buildStrlen = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "strlen: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_StrLength(ex);
        }
    };
    protected final Build buildSubstr = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, 4, list, "substr: wanted 2 or 3 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            Expr x = BuilderExpr.buildExpr(list.get(2));
            Expr y = null;
            if (list.size() == 4) {
                y = BuilderExpr.buildExpr(list.get(3));
            }
            return new E_StrSubstring(ex, x, y);
        }
    };
    protected final Build buildStrReplace = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(4, 5, list, "replace: wanted 3 or 4 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            Expr x = BuilderExpr.buildExpr(list.get(2));
            Expr y = BuilderExpr.buildExpr(list.get(3));
            Expr z = null;
            if (list.size() == 5) {
                z = BuilderExpr.buildExpr(list.get(4));
            }
            return new E_StrReplace(ex, x, y, z);
        }
    };
    protected final Build buildStrUppercase = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "ucase: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_StrUpperCase(ex);
        }
    };
    protected final Build buildStrLowercase = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "lcase: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_StrLowerCase(ex);
        }
    };
    protected final Build buildStrEnds = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "strends: wanted 2 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrEndsWith(ex1, ex2);
        }
    };
    protected final Build buildStrStarts = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "strstarts: wanted 2 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrStartsWith(ex1, ex2);
        }
    };
    protected final Build buildStrBefore = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "strbefore: wanted 2 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrBefore(ex1, ex2);
        }
    };
    protected final Build buildStrAfter = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "strafter: wanted 2 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrAfter(ex1, ex2);
        }
    };
    protected final Build buildStrContains = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "contains: wanted 2 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            return new E_StrContains(ex1, ex2);
        }
    };
    protected final Build buildStrEncode = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "encode: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_StrEncodeForURI(ex);
        }
    };
    protected final Build buildNumAbs = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "abs: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_NumAbs(ex);
        }
    };
    protected final Build buildNumRound = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "round: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_NumRound(ex);
        }
    };
    protected final Build buildNumCeiling = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "ceiling: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_NumCeiling(ex);
        }
    };
    protected final Build buildNumFloor = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "floor: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_NumFloor(ex);
        }
    };
    protected final Build buildLang = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "lang: wanted 1 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_Lang(ex);
        }
    };
    protected final Build buildLangMatches = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "langmatches: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_LangMatches(left, right);
        }
    };
    protected final Build buildSameTerm = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(3, list, "sameterm: wanted 2 arguments: got :" + BuilderExpr.numArgs(list));
            Expr left = BuilderExpr.buildExpr(list.get(1));
            Expr right = BuilderExpr.buildExpr(list.get(2));
            return new E_SameTerm(left, right);
        }
    };
    protected final Build buildDatatype = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "datatype: wanted 1 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_Datatype(ex);
        }
    };
    protected final Build buildBound = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "bound: wanted 1 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_Bound(ex);
        }
    };
    protected final Build buildCoalesce = new Build(){

        @Override
        public Expr make(ItemList list) {
            ExprList exprs = BuilderExpr.buildExprListUntagged(list, 1);
            return new E_Coalesce(exprs);
        }
    };
    protected final Build buildConcat = new Build(){

        @Override
        public Expr make(ItemList list) {
            ExprList exprs = BuilderExpr.buildExprListUntagged(list, 1);
            return new E_StrConcat(exprs);
        }
    };
    protected final Build buildConditional = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(4, list, "IF: wanted 3 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex1 = BuilderExpr.buildExpr(list.get(1));
            Expr ex2 = BuilderExpr.buildExpr(list.get(2));
            Expr ex3 = BuilderExpr.buildExpr(list.get(3));
            return new E_Conditional(ex1, ex2, ex3);
        }
    };
    protected final Build buildIsIRI = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "isIRI: wanted 1 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsIRI(ex);
        }
    };
    protected final Build buildIsURI = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "isURI: wanted 1 arguments: got :" + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsURI(ex);
        }
    };
    protected final Build buildIsBlank = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "isBlank: wanted 1 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsBlank(ex);
        }
    };
    protected final Build buildIsLiteral = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "isLiteral: wanted 1 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsLiteral(ex);
        }
    };
    protected final Build buildIsNumeric = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "isNumeric: wanted 1 arguments: got: " + BuilderExpr.numArgs(list));
            Expr ex = BuilderExpr.buildExpr(list.get(1));
            return new E_IsNumeric(ex);
        }
    };
    protected final Build buildExists = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "exists: wanted 1 arguments: got: " + BuilderExpr.numArgs(list));
            Op op = BuilderOp.build(list.get(1));
            return new E_Exists(op);
        }
    };
    protected final Build buildNotExists = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "notexists: wanted 1 arguments: got: " + BuilderExpr.numArgs(list));
            Op op = BuilderOp.build(list.get(1));
            return new E_NotExists(op);
        }
    };
    protected final Build buildBNode = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(1, 2, list, "bnode: wanted 0 or 1 arguments: got: " + BuilderExpr.numArgs(list));
            if (list.size() == 1) {
                return new E_BNode();
            }
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            return new E_BNode(expr);
        }
    };
    protected final Build buildIri = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "iri: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            return new E_IRI(expr);
        }
    };
    protected final Build buildUri = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(2, list, "uri: wanted 1 argument: got: " + BuilderExpr.numArgs(list));
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            return new E_URI(expr);
        }
    };
    protected final Build buildIn = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLengthAtLeast(1, list, "in: wanted 1 or more arguments: got: " + BuilderExpr.numArgs(list));
            Item lhs = list.car();
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            ExprList eList = BuilderExpr.buildExprListUntagged(list, 2);
            return new E_OneOf(expr, eList);
        }
    };
    protected final Build buildNotIn = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLengthAtLeast(1, list, "notin: wanted 1 or more arguments: got: " + BuilderExpr.numArgs(list));
            Item lhs = list.car();
            Expr expr = BuilderExpr.buildExpr(list.get(1));
            ExprList eList = BuilderExpr.buildExprListUntagged(list, 2);
            return new E_NotOneOf(expr, eList);
        }
    };
    protected final Build buildCall = new Build(){

        @Override
        public Expr make(ItemList list) {
            ExprList args = BuilderExpr.buildExprListUntagged(list, 1);
            return new E_Call(args);
        }
    };
    protected final Build buildCount = new Build(){

        @Override
        public Expr make(ItemList list) {
            ItemList x = list.cdr();
            boolean distinct = BuilderExpr.startsWithDistinct(x);
            if (distinct) {
                x = x.cdr();
            }
            BuilderLib.checkLength(0, 1, x, "Broken syntax: " + list.shortString());
            Aggregator agg = null;
            if (x.size() == 0) {
                agg = AggregatorFactory.createCount(distinct);
            } else {
                Expr expr = BuilderExpr.buildExpr(x.get(0));
                agg = AggregatorFactory.createCountExpr(distinct, expr);
            }
            return new ExprAggregator(null, agg);
        }
    };
    protected final Build buildSum = new BuildAggCommon(){

        @Override
        public Expr make(boolean distinct, Expr expr) {
            Aggregator agg = AggregatorFactory.createSum(distinct, expr);
            return new ExprAggregator(null, agg);
        }
    };
    protected final Build buildMin = new BuildAggCommon(){

        @Override
        public Expr make(boolean distinct, Expr expr) {
            Aggregator agg = AggregatorFactory.createMin(distinct, expr);
            return new ExprAggregator(null, agg);
        }
    };
    protected final Build buildMax = new BuildAggCommon(){

        @Override
        public Expr make(boolean distinct, Expr expr) {
            Aggregator agg = AggregatorFactory.createMax(distinct, expr);
            return new ExprAggregator(null, agg);
        }
    };
    protected final Build buildAvg = new BuildAggCommon(){

        @Override
        public Expr make(boolean distinct, Expr expr) {
            Aggregator agg = AggregatorFactory.createAvg(distinct, expr);
            return new ExprAggregator(null, agg);
        }
    };
    protected final Build buildSample = new BuildAggCommon(){

        @Override
        public Expr make(boolean distinct, Expr expr) {
            Aggregator agg = AggregatorFactory.createSample(distinct, expr);
            return new ExprAggregator(null, agg);
        }
    };
    protected final Build buildGroupConcat = new Build(){

        @Override
        public Expr make(ItemList list) {
            ItemList x = list.cdr();
            boolean distinct = BuilderExpr.startsWithDistinct(x);
            if (distinct) {
                x = x.cdr();
            }
            if (x.size() == 0) {
                BuilderLib.broken(list, "Broken syntax: " + list.shortString());
            }
            String separator = null;
            if (x.get(0).isTagged("separator")) {
                ItemList y = x.get(0).getList();
                BuilderLib.checkLength(2, y, "Broken syntax: " + list);
                Node n = y.get(1).getNode();
                if (!NodeUtils.isSimpleString(n)) {
                    BuilderLib.broken(y, "Need string for separator: " + y);
                }
                separator = n.getLiteralLexicalForm();
                x = x.cdr();
            }
            Expr expr = BuilderExpr.buildExpr(x.get(0));
            Aggregator agg = AggregatorFactory.createGroupConcat(distinct, expr, separator, null);
            return new ExprAggregator(null, agg);
        }
    };
    protected final Build buildCustomAggregate = new Build(){

        @Override
        public Expr make(ItemList list) {
            boolean distinct;
            Item z;
            ItemList x = list.cdr();
            if (x.size() == 0) {
                BuilderLib.broken(list, "Missing IRI for aggregate");
            }
            if (!(z = x.car()).isNodeURI()) {
                BuilderLib.broken(list, "Not an IRI for aggregate: " + z);
            }
            if (distinct = BuilderExpr.startsWithDistinct(x = x.cdr())) {
                x = x.cdr();
            }
            ExprList e2 = BuilderExpr.buildExprListUntagged(x, 0);
            Aggregator agg = AggregatorFactory.createCustom(z.getNode().getURI(), distinct, e2);
            return new ExprAggregator(null, agg);
        }
    };
    protected final Build buildAggNull = new Build(){

        @Override
        public Expr make(ItemList list) {
            BuilderLib.checkLength(1, list, "Broken syntax: " + list.shortString());
            return new ExprAggregator(null, AggregatorFactory.createAggNull());
        }
    };

    public static ExprList buildExprOrExprList(Item item) {
        if (item.isTagged("exprlist")) {
            return BuilderExpr.buildExprList(item);
        }
        if (BuilderExpr.listOfLists(item)) {
            return BuilderExpr.buildExprListUntagged(item.getList(), 0);
        }
        Expr expr = BuilderExpr.buildExpr(item);
        ExprList exprList = new ExprList(expr);
        return exprList;
    }

    private static boolean listOfLists(Item item) {
        if (!item.isList()) {
            return false;
        }
        return item.getList().car().isList();
    }

    public static ExprList buildExprList(Item item) {
        if (!item.isTagged("exprlist")) {
            BuilderLib.broken(item, "Not tagged exprlist");
        }
        ItemList list = item.getList();
        return BuilderExpr.buildExprListUntagged(list, 1);
    }

    private static ExprList buildExprListUntagged(Item item) {
        return BuilderExpr.buildExprListUntagged(item.getList(), 0);
    }

    private static ExprList buildExprListUntagged(ItemList list, int idx) {
        ExprList exprList = new ExprList();
        for (int i = idx; i < list.size(); ++i) {
            Item item = list.get(i);
            exprList.add(BuilderExpr.buildExpr(item));
        }
        return exprList;
    }

    public static Expr buildExpr(Item item) {
        BuilderExpr bob = new BuilderExpr();
        return bob.buildItem(item);
    }

    public static VarExprList buildNamedExprOrExprList(Item item) {
        ItemList list;
        if (!item.isList()) {
            BuilderLib.broken(item, "Not a var expr list");
        }
        if ((list = item.getList()).isEmpty()) {
            return new VarExprList();
        }
        if (list.car().isList()) {
            return BuilderExpr.buildNamedExprList(list);
        }
        return BuilderExpr.buildNamedExpr(item);
    }

    public static VarExprList buildNamedExprList(ItemList list) {
        VarExprList x = new VarExprList();
        for (Item item : list) {
            BuilderExpr.buildNamedExpr(item, x);
        }
        return x;
    }

    public static VarExprList buildNamedExpr(Item item) {
        VarExprList varExprList = new VarExprList();
        BuilderExpr.buildNamedExpr(item, varExprList);
        return varExprList;
    }

    private static void buildNamedExpr(Item item, VarExprList varExprList) {
        ItemList list;
        if (item.isNode()) {
            Var v = BuilderNode.buildVar(item);
            varExprList.add(v);
            return;
        }
        if (!item.isList() || item.getList().size() != 2) {
            BuilderLib.broken(item, "Not a var or var/expression pair");
        }
        if ((list = item.getList()).size() == 1) {
            Var v = BuilderNode.buildVar(list.car());
            varExprList.add(v);
            return;
        }
        if (list.size() != 2) {
            BuilderLib.broken(list, "Not a var or var/expression pair");
        }
        Var var = BuilderNode.buildVar(list.get(0));
        Expr expr = BuilderExpr.buildExpr(list.get(1));
        varExprList.add(var, expr);
    }

    public Expr buildItem(Item item) {
        Object expr = null;
        if (item.isList()) {
            Item head;
            ItemList list = item.getList();
            if (list.size() == 0) {
                BuilderLib.broken(item, "Empty list for expression");
            }
            if ((head = list.get(0)).isNode()) {
                if (head.getNode().isVariable() && list.size() == 1) {
                    return new ExprVar(Var.alloc(head.getNode()));
                }
                return BuilderExpr.buildFunctionCall(list);
            }
            if (head.isList()) {
                BuilderLib.broken(item, "Head is a list");
            } else if (head.isSymbol()) {
                if (item.isTagged("expr")) {
                    BuilderLib.checkLength(2, list, "Wrong length: " + item.shortString());
                    item = list.get(1);
                    return this.buildItem(item);
                }
                return this.buildKnownFunction(list);
            }
            throw new ARQInternalErrorException();
        }
        if (item.isNode()) {
            if (Var.isVar(item.getNode())) {
                return new ExprVar(Var.alloc(item.getNode()));
            }
            return NodeValue.makeNode(item.getNode());
        }
        if (item.isSymbolIgnoreCase("true")) {
            return NodeValue.TRUE;
        }
        if (item.isSymbolIgnoreCase("false")) {
            return NodeValue.FALSE;
        }
        BuilderLib.broken(item, "Not a list or a node or recognized symbol: " + item);
        return null;
    }

    public BuilderExpr() {
        this.dispatch.put("regex", this.buildRegex);
        this.dispatch.put("=", this.buildEQ);
        this.dispatch.put("eq", this.buildEQ);
        this.dispatch.put("!=", this.buildNE);
        this.dispatch.put("ne", this.buildNE);
        this.dispatch.put(">", this.buildGT);
        this.dispatch.put("gt", this.buildGT);
        this.dispatch.put("<", this.buildLT);
        this.dispatch.put("lt", this.buildLT);
        this.dispatch.put("<=", this.buildLE);
        this.dispatch.put("le", this.buildLE);
        this.dispatch.put(">=", this.buildGE);
        this.dispatch.put("ge", this.buildGE);
        this.dispatch.put("||", this.buildOr);
        this.dispatch.put("or", this.buildOr);
        this.dispatch.put("&&", this.buildAnd);
        this.dispatch.put("and", this.buildAnd);
        this.dispatch.put("+", this.buildPlus);
        this.dispatch.put("add", this.buildPlus);
        this.dispatch.put("-", this.buildMinus);
        this.dispatch.put("subtract", this.buildMinus);
        this.dispatch.put("minus", this.buildMinus);
        this.dispatch.put("unaryplus", this.buildUnaryPlus);
        this.dispatch.put("unaryminus", this.buildUnaryMinus);
        this.dispatch.put("*", this.buildMult);
        this.dispatch.put("multiply", this.buildMult);
        this.dispatch.put("/", this.buildDiv);
        this.dispatch.put("divide", this.buildDiv);
        this.dispatch.put("not", this.buildNot);
        this.dispatch.put("!", this.buildNot);
        this.dispatch.put("str", this.buildStr);
        this.dispatch.put("strlang", this.buildStrLang);
        this.dispatch.put("strdt", this.buildStrDatatype);
        this.dispatch.put("str", this.buildStr);
        this.dispatch.put("rand", this.buildRand);
        this.dispatch.put("year", this.buildYear);
        this.dispatch.put("month", this.buildMonth);
        this.dispatch.put("day", this.buildDay);
        this.dispatch.put("hours", this.buildHours);
        this.dispatch.put("minutes", this.buildMinutes);
        this.dispatch.put("seconds", this.buildSeconds);
        this.dispatch.put("timezone", this.buildTimezone);
        this.dispatch.put("tz", this.buildTZ);
        this.dispatch.put("now", this.buildNow);
        this.dispatch.put("uuid", this.buildUUID);
        this.dispatch.put("struuid", this.buildStrUUID);
        this.dispatch.put("version", this.buildVersion);
        this.dispatch.put("md5", this.buildMD5);
        this.dispatch.put("sha1", this.buildSHA1);
        this.dispatch.put("sha224", this.buildSHA224);
        this.dispatch.put("sha256", this.buildSHA256);
        this.dispatch.put("sha384", this.buildSHA384);
        this.dispatch.put("sha512", this.buildSHA512);
        this.dispatch.put("strlen", this.buildStrlen);
        this.dispatch.put("substr", this.buildSubstr);
        this.dispatch.put("replace", this.buildStrReplace);
        this.dispatch.put("ucase", this.buildStrUppercase);
        this.dispatch.put("lcase", this.buildStrLowercase);
        this.dispatch.put("strends", this.buildStrEnds);
        this.dispatch.put("strstarts", this.buildStrStarts);
        this.dispatch.put("strbefore", this.buildStrBefore);
        this.dispatch.put("strafter", this.buildStrAfter);
        this.dispatch.put("contains", this.buildStrContains);
        this.dispatch.put("encode_for_uri", this.buildStrEncode);
        this.dispatch.put("concat", this.buildConcat);
        this.dispatch.put("abs", this.buildNumAbs);
        this.dispatch.put("round", this.buildNumRound);
        this.dispatch.put("ceil", this.buildNumCeiling);
        this.dispatch.put("floor", this.buildNumFloor);
        this.dispatch.put("isNumeric", this.buildIsNumeric);
        this.dispatch.put("lang", this.buildLang);
        this.dispatch.put("langMatches", this.buildLangMatches);
        this.dispatch.put("sameTerm", this.buildSameTerm);
        this.dispatch.put("datatype", this.buildDatatype);
        this.dispatch.put("bound", this.buildBound);
        this.dispatch.put("coalesce", this.buildCoalesce);
        this.dispatch.put("concat", this.buildConcat);
        this.dispatch.put("if", this.buildConditional);
        this.dispatch.put("isIRI", this.buildIsIRI);
        this.dispatch.put("isURI", this.buildIsURI);
        this.dispatch.put("isBlank", this.buildIsBlank);
        this.dispatch.put("isLiteral", this.buildIsLiteral);
        this.dispatch.put("exists", this.buildExists);
        this.dispatch.put("notexists", this.buildNotExists);
        this.dispatch.put("bnode", this.buildBNode);
        this.dispatch.put("iri", this.buildIri);
        this.dispatch.put("uri", this.buildUri);
        this.dispatch.put("in", this.buildIn);
        this.dispatch.put("notin", this.buildNotIn);
        this.dispatch.put("call", this.buildCall);
        this.dispatch.put("count", this.buildCount);
        this.dispatch.put("sum", this.buildSum);
        this.dispatch.put("min", this.buildMin);
        this.dispatch.put("max", this.buildMax);
        this.dispatch.put("avg", this.buildAvg);
        this.dispatch.put("sample", this.buildSample);
        this.dispatch.put("group_concat", this.buildGroupConcat);
        this.dispatch.put("agg", this.buildCustomAggregate);
    }

    protected Build findBuild(String str2) {
        for (String key : this.dispatch.keySet()) {
            if (!str2.equalsIgnoreCase(key)) continue;
            return this.dispatch.get(key);
        }
        return null;
    }

    protected Expr buildKnownFunction(ItemList list) {
        Build b;
        Item item;
        String tag;
        if (list.size() == 0) {
            BuilderLib.broken(list, "Empty list for expression");
        }
        if ((tag = (item = list.get(0)).getSymbol()) == null) {
            BuilderLib.broken(item, "Null tag");
        }
        if ((b = this.findBuild(tag)) == null) {
            BuilderLib.broken(item, "No known symbol for " + tag);
        }
        return b.make(list);
    }

    protected static Expr buildFunctionCall(ItemList list) {
        Item head = list.get(0);
        Node node = head.getNode();
        if (node.isBlank()) {
            BuilderLib.broken(head, "Blank node for function call!");
        }
        if (node.isLiteral()) {
            BuilderLib.broken(head, "Literal node for function call!");
        }
        ExprList args = BuilderExpr.buildExprListUntagged(list, 1);
        return new E_Function(node.getURI(), args);
    }

    private static int numArgs(ItemList list) {
        return list.size() - 1;
    }

    static boolean startsWithDistinct(ItemList x) {
        return x.size() > 0 && x.car().isSymbol("distinct");
    }

    static abstract class BuildAggCommon
    implements Build {
        BuildAggCommon() {
        }

        @Override
        public final Expr make(ItemList list) {
            ItemList x = list.cdr();
            boolean distinct = BuilderExpr.startsWithDistinct(x);
            if (distinct) {
                x = x.cdr();
            }
            BuilderLib.checkLength(1, x, "Broken syntax: " + list.shortString());
            Expr expr = BuilderExpr.buildExpr(x.get(0));
            return this.make(distinct, expr);
        }

        public abstract Expr make(boolean var1, Expr var2);
    }

    public static interface Build {
        public Expr make(ItemList var1);
    }
}

