/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.jenax.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphMatcher;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.jenax.util.TransparentWrappedGraph;

public class DiffGraph
extends TransparentWrappedGraph {
    private GraphWithPerform addedGraph = new GraphMem();
    protected Set<Triple> deletedTriples = new HashSet<Triple>();
    private PrefixMapping pm;

    public DiffGraph(Graph base) {
        super(base);
    }

    public void add(Triple t) {
        this.performAdd(t);
    }

    public void delete(Triple t) {
        this.performDelete(t);
    }

    public Graph getAddedGraph() {
        return this.addedGraph;
    }

    public boolean contains(Node s, Node p, Node o) {
        return this.contains(Triple.create((Node)s, (Node)p, (Node)o));
    }

    public boolean contains(Triple t) {
        if (this.addedGraph.contains(t)) {
            return true;
        }
        ExtendedIterator it = this.base.find(t);
        while (it.hasNext()) {
            Triple n = (Triple)it.next();
            if (this.deletedTriples.contains(n)) continue;
            it.close();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsByEquals(Graph g, Triple t) {
        try (ExtendedIterator it = g.find(t);){
            while (it.hasNext()) {
                if (!t.equals(it.next())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        ExtendedIterator added;
        ExtendedIterator base = super.find(s, p, o);
        if (this.deletedTriples.size() > 0) {
            base = base.filterDrop(this.deletedTriples::contains);
        }
        if ((added = this.addedGraph.find(s, p, o)).hasNext()) {
            return base.andThen((Iterator)added);
        }
        return base;
    }

    public ExtendedIterator<Triple> find(Triple m) {
        return this.find(m.getMatchSubject(), m.getMatchPredicate(), m.getMatchObject());
    }

    public Set<Triple> getDeletedTriples() {
        return this.deletedTriples;
    }

    public PrefixMapping getPrefixMapping() {
        if (this.pm == null) {
            this.pm = new PrefixMappingImpl().setNsPrefixes(this.base.getPrefixMapping());
        }
        return this.pm;
    }

    public boolean isEmpty() {
        if (!this.addedGraph.isEmpty()) {
            return false;
        }
        if (this.deletedTriples.isEmpty()) {
            return this.base.isEmpty();
        }
        return this.find(Triple.ANY).hasNext();
    }

    public boolean isIsomorphicWith(Graph g) {
        return g != null && GraphMatcher.equals((Graph)this, (Graph)g);
    }

    public void performAdd(Triple t) {
        if (this.deletedTriples.contains(t)) {
            this.deletedTriples.remove(t);
            this.getEventManager().notifyAddTriple((Graph)this, t);
        } else if (this.containsByEquals((Graph)this.addedGraph, t) || this.containsByEquals(this.base, t)) {
            this.getEventManager().notifyAddTriple((Graph)this, t);
        } else {
            this.addedGraph.add(t);
        }
    }

    public void performDelete(Triple t) {
        if (this.containsByEquals((Graph)this.addedGraph, t)) {
            this.addedGraph.delete(t);
        } else if (this.containsByEquals(this.base, t)) {
            this.deletedTriples.add(t);
            this.getEventManager().notifyDeleteTriple((Graph)this, t);
        } else {
            this.getEventManager().notifyDeleteTriple((Graph)this, t);
            return;
        }
    }

    public int size() {
        return super.size() - this.deletedTriples.size() + this.addedGraph.size();
    }
}

