/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.coercion;

import java.io.Serializable;
import java.math.RoundingMode;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Locale;
import org.mule.weave.v2.exception.UnsupportedBasePropertyException;
import org.mule.weave.v2.exception.UnsupportedTypeCoercionException;
import org.mule.weave.v2.exception.UnsupportedTypeCoercionException$;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.structure.schema.Schema$;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.LocalTimeType$;
import org.mule.weave.v2.model.types.NameType$;
import org.mule.weave.v2.model.types.NamespaceType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.PeriodType$;
import org.mule.weave.v2.model.types.RegexType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.types.TimeZoneType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.types.TypeType$;
import org.mule.weave.v2.model.types.UriType$;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.StringValue;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.coercion.ValueCoercer;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.util.BinaryHelper$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.matching.Regex;
import spire.math.Number;

public final class StringCoercer$
implements ValueCoercer<StringValue> {
    public static StringCoercer$ MODULE$;

    static {
        new StringCoercer$();
    }

    @Override
    public Option<StringValue> coerceMaybe(Value<?> value, Type targetType, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        return ValueCoercer.coerceMaybe$(this, value, targetType, locationCapable, evaluationContext);
    }

    @Override
    public StringValue coerce(Value<?> value, Type targetType, LocationCapable locationCapable, EvaluationContext ctx) {
        Type type;
        Type type2;
        Type type3;
        Type type4;
        Type type5;
        Type type6;
        Type type7;
        Type type8;
        Type type9;
        Type type10;
        Type type11;
        Type type12;
        Type type13;
        Type type14;
        Type type15;
        Type type16;
        String string;
        Type type17;
        Type type18 = value.valueType(ctx);
        if (type18 != null && (type17 = type18).isInstanceOf(StringType$.MODULE$, ctx)) {
            string = (String)value.evaluate(ctx);
        } else if (type18 != null && (type16 = type18).isInstanceOf(DateTimeType$.MODULE$, ctx)) {
            string = this.formatTemporal((ZonedDateTime)value.evaluate(ctx), targetType.schema(ctx), DateTimeType$.MODULE$, locationCapable, value, ctx);
        } else if (type18 != null && (type15 = type18).isInstanceOf(LocalDateTimeType$.MODULE$, ctx)) {
            string = this.formatTemporal((LocalDateTime)value.evaluate(ctx), targetType.schema(ctx), LocalDateTimeType$.MODULE$, locationCapable, value, ctx);
        } else if (type18 != null && (type14 = type18).isInstanceOf(LocalTimeType$.MODULE$, ctx)) {
            string = this.formatTemporal((LocalTime)value.evaluate(ctx), targetType.schema(ctx), LocalTimeType$.MODULE$, locationCapable, value, ctx);
        } else if (type18 != null && (type13 = type18).isInstanceOf(LocalDateType$.MODULE$, ctx)) {
            string = this.formatTemporal((LocalDate)value.evaluate(ctx), targetType.schema(ctx), LocalDateType$.MODULE$, locationCapable, value, ctx);
        } else if (type18 != null && (type12 = type18).isInstanceOf(TimeType$.MODULE$, ctx)) {
            string = this.formatTemporal((OffsetTime)value.evaluate(ctx), targetType.schema(ctx), TimeType$.MODULE$, locationCapable, value, ctx);
        } else if (type18 != null && (type11 = type18).isInstanceOf(PeriodType$.MODULE$, ctx)) {
            string = ((TemporalAmount)value.evaluate(ctx)).toString();
        } else if (type18 != null && (type10 = type18).isInstanceOf(TimeZoneType$.MODULE$, ctx)) {
            string = ((ZoneId)value.evaluate(ctx)).toString();
        } else if (type18 != null && (type9 = type18).isInstanceOf(NumberType$.MODULE$, ctx)) {
            string = this.formatNumber((Number)value.evaluate(ctx), targetType.schema(ctx), locationCapable, value, ctx);
        } else if (type18 != null && (type8 = type18).isInstanceOf(BooleanType$.MODULE$, ctx)) {
            string = ((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean(value.evaluate(ctx)))).toString();
        } else if (type18 != null && (type7 = type18).isInstanceOf(UriType$.MODULE$, ctx)) {
            string = ((URI)value.evaluate(ctx)).toString();
        } else if (type18 != null && (type6 = type18).isInstanceOf(BinaryType$.MODULE$, ctx)) {
            String string2;
            Value binaryValue = BinaryType$.MODULE$.coerce(value, ctx);
            Option maybeBase = targetType.schema(ctx).flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.base(ctx));
            if (maybeBase.isDefined()) {
                String string3;
                String base = (String)maybeBase.get();
                String string4 = base;
                if ("64".equals(string4)) {
                    string3 = BinaryHelper$.MODULE$.toBase64String((SeekableStream)binaryValue.evaluate(ctx));
                } else if ("16".equals(string4)) {
                    byte[] content = BinaryValue$.MODULE$.getBytes(binaryValue, BinaryValue$.MODULE$.getBytes$default$2(), ctx);
                    string3 = BinaryHelper$.MODULE$.toHexString(content);
                } else {
                    throw new UnsupportedBasePropertyException(((LocationCapable)((Schema)targetType.schema(ctx).get()).valueOf(Schema$.MODULE$.BASE_PROPERTY_NAME(), ctx).get()).location(), BinaryType$.MODULE$, StringType$.MODULE$, string4, ctx);
                }
                string2 = string3;
            } else {
                Charset charset = (Charset)targetType.schema(ctx).flatMap((Function1 & Serializable & scala.Serializable)schema -> schema.encoding(ctx).map((Function1 & Serializable & scala.Serializable)x$1 -> Charset.forName(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> ctx.serviceManager().charsetProviderService().defaultCharset());
                string2 = BinaryValue$.MODULE$.toString((SeekableStream)binaryValue.evaluate(ctx), charset, BinaryValue$.MODULE$.toString$default$3());
            }
            string = string2;
        } else if (type18 != null && (type5 = type18).isInstanceOf(NameType$.MODULE$, ctx)) {
            string = ((QualifiedName)value.evaluate(ctx)).name();
        } else if (type18 != null && (type4 = type18).isInstanceOf(TypeType$.MODULE$, ctx)) {
            string = ((Type)value.evaluate(ctx)).name();
        } else if (type18 != null && (type3 = type18).isInstanceOf(KeyType$.MODULE$, ctx)) {
            string = ((QualifiedName)value.evaluate(ctx)).name();
        } else if (type18 != null && (type2 = type18).isInstanceOf(RegexType$.MODULE$, ctx)) {
            string = ((Regex)value.evaluate(ctx)).toString();
        } else if (type18 != null && (type = type18).isInstanceOf(NamespaceType$.MODULE$, ctx)) {
            string = ((Namespace)value.evaluate(ctx)).uri();
        } else {
            throw new UnsupportedTypeCoercionException(locationCapable.location(), value.valueType(ctx), StringType$.MODULE$, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> String.valueOf(value), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$5(), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx);
        }
        String result = string;
        return StringValue$.MODULE$.apply(result, locationCapable, targetType);
    }

    public String formatTemporal(TemporalAccessor temporal, Option<Schema> schema, Type sourceType, LocationCapable locationCapable, Value<?> value, EvaluationContext ctx) {
        Option formattedStringMaybe = schema.flatMap((Function1 & Serializable & scala.Serializable)schemaValue -> schemaValue.format(ctx).map((Function1 & Serializable & scala.Serializable)format -> MODULE$.doFormatTemporal(temporal, (Locale)schemaValue.locale(ctx).map((Function1 & Serializable & scala.Serializable)localeString -> Locale.forLanguageTag(localeString)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Locale.getDefault()), (String)format, sourceType, locationCapable, value, ctx)));
        return (String)formattedStringMaybe.getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.defaultFormatTemporal(temporal));
    }

    public String doFormatTemporal(TemporalAccessor temporal, Locale locale, String format, Type sourceType, LocationCapable locationCapable, Value<?> value, EvaluationContext ctx) {
        String string;
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format, locale);
            string = formatter.format(temporal);
        }
        catch (DateTimeException dte) {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), sourceType, StringType$.MODULE$, value, (Option<String>)Option$.MODULE$.apply((Object)dte.getMessage()), ctx);
        }
        catch (IllegalArgumentException iae) {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), sourceType, StringType$.MODULE$, value, (Option<String>)Option$.MODULE$.apply((Object)iae.getMessage()), ctx);
        }
        return string;
    }

    public String defaultFormatTemporal(TemporalAccessor temporal) {
        DateTimeFormatter dateTimeFormatter;
        TemporalAccessor temporalAccessor = temporal;
        if (temporalAccessor instanceof ZonedDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        } else if (temporalAccessor instanceof LocalDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        } else if (temporalAccessor instanceof LocalTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;
        } else if (temporalAccessor instanceof LocalDate) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
        } else if (temporalAccessor instanceof OffsetTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_TIME;
        } else {
            throw new MatchError((Object)temporalAccessor);
        }
        DateTimeFormatter formatter = dateTimeFormatter;
        return formatter.format(temporal);
    }

    public String formatNumber(Number n, Option<Schema> mayBeSchema, LocationCapable locationCapable, Value<?> value2, EvaluationContext ctx) {
        String string;
        Option<Schema> option = mayBeSchema;
        if (option instanceof Some) {
            String string2;
            Some some = (Some)option;
            Schema schema = (Schema)some.value();
            Schema schemaValue = schema;
            Option<String> option2 = schemaValue.format(ctx);
            if (option2 instanceof Some) {
                String string3;
                Some some2 = (Some)option2;
                String f = (String)some2.value();
                try {
                    DecimalFormatSymbols formatSymbols = (DecimalFormatSymbols)schemaValue.locale(ctx).map((Function1 & Serializable & scala.Serializable)locale -> DecimalFormatSymbols.getInstance(Locale.forLanguageTag(locale))).getOrElse((Function0 & Serializable & scala.Serializable)() -> DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT)));
                    DecimalFormat formatter = new DecimalFormat(f, formatSymbols);
                    RoundingMode halfup = (RoundingMode)((Object)schemaValue.roundMode(ctx).flatMap((Function1 & Serializable & scala.Serializable)value -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> RoundingMode.valueOf(value)).toOption()).getOrElse((Function0 & Serializable & scala.Serializable)() -> RoundingMode.HALF_UP));
                    formatter.setRoundingMode(halfup);
                    formatter.setParseBigDecimal(true);
                    string3 = formatter.format(n.toBigDecimal().bigDecimal());
                }
                catch (IllegalArgumentException iae) {
                    throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), NumberType$.MODULE$, StringType$.MODULE$, value2, (Option<String>)Option$.MODULE$.apply((Object)iae.getMessage()), ctx);
                }
                string2 = string3;
            } else {
                string2 = this.numberToString(n);
            }
            string = string2;
        } else {
            string = this.numberToString(n);
        }
        return string;
    }

    public String numberToString(Number n) {
        return n.isWhole() ? (n.withinInt() ? ((Object)BoxesRunTime.boxToInteger((int)n.toInt())).toString() : (n.withinLong() ? ((Object)BoxesRunTime.boxToLong((long)n.toLong())).toString() : n.toBigInt().toString())) : n.toString();
    }

    private StringCoercer$() {
        MODULE$ = this;
        ValueCoercer.$init$(this);
    }
}

