/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.arq;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.topbraid.jenax.util.ARQFactory;
import org.topbraid.jenax.util.DatasetWithDifferentDefaultModel;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.arq.SHACLARQFunction;
import org.topbraid.shacl.model.SHConstraintComponent;
import org.topbraid.shacl.model.SHSPARQLFunction;
import org.topbraid.shacl.validation.sparql.SPARQLSubstitutions;
import org.topbraid.shacl.vocabulary.SH;

public class SHACLSPARQLARQFunction
extends SHACLARQFunction {
    private Query arqQuery;
    private String queryString;

    public SHACLSPARQLARQFunction(SHConstraintComponent component, Resource askValidator) {
        super(null);
        try {
            this.queryString = JenaUtil.getStringProperty(askValidator, SH.ask);
            this.arqQuery = ARQFactory.get().createQuery(SPARQLSubstitutions.withPrefixes(this.queryString, askValidator));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Validator " + askValidator + " does not define a valid body", ex);
        }
        if (!this.arqQuery.isAskType()) {
            throw new ExprEvalException("Body must be ASK query");
        }
        this.paramNames.add("value");
        this.addParameters(component);
        this.paramNames.add("shapesGraph");
    }

    public SHACLSPARQLARQFunction(SHSPARQLFunction shaclFunction) {
        super(shaclFunction);
        try {
            this.queryString = shaclFunction.getSPARQL();
            this.arqQuery = ARQFactory.get().createQuery(SPARQLSubstitutions.withPrefixes(this.queryString, shaclFunction));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Function " + shaclFunction.getURI() + " does not define a valid body", ex);
        }
        if (!this.arqQuery.isAskType() && !this.arqQuery.isSelectType()) {
            throw new ExprEvalException("Body must be ASK or SELECT query");
        }
        this.addParameters(shaclFunction);
    }

    @Override
    public void build(String uri, ExprList args) {
    }

    @Override
    public Function create(String uri) {
        return this;
    }

    private QueryExecution createQueryExecution(Dataset dataset, Model defaultModel, QuerySolution bindings) {
        if (dataset == null) {
            return ARQFactory.get().createQueryExecution(this.arqQuery, defaultModel, bindings);
        }
        DatasetWithDifferentDefaultModel newDataset = new DatasetWithDifferentDefaultModel(defaultModel, dataset);
        return ARQFactory.get().createQueryExecution(this.arqQuery, newDataset, bindings);
    }

    @Override
    public NodeValue executeBody(Dataset dataset, Model defaultModel, QuerySolution bindings) {
        Throwable throwable = null;
        try (QueryExecution qexec = this.createQueryExecution(dataset, defaultModel, bindings);){
            List resultVars;
            String varName;
            QuerySolution s;
            RDFNode resultNode;
            if (this.arqQuery.isAskType()) {
                boolean result = qexec.execAsk();
                NodeValue nodeValue = NodeValue.makeBoolean((boolean)result);
                return nodeValue;
            }
            ResultSet rs = qexec.execSelect();
            if (rs.hasNext() && (resultNode = (s = rs.nextSolution()).get(varName = (String)(resultVars = rs.getResultVars()).get(0))) != null) {
                NodeValue nodeValue = NodeValue.makeNode((Node)resultNode.asNode());
                return nodeValue;
            }
            try {
                throw new ExprEvalException("Empty result set for SHACL function");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Query getBodyQuery() {
        return this.arqQuery;
    }

    @Override
    protected String getQueryString() {
        return this.queryString;
    }
}

