/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.util;

import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.topbraid.shacl.vocabulary.DASH;

public class ExecutionPlatform {
    private static ExecutionPlatform singleton = new ExecutionPlatform();

    public static ExecutionPlatform get() {
        return singleton;
    }

    public static void set(ExecutionPlatform value) {
        singleton = value;
    }

    public static boolean canExecute(Resource executable) {
        StmtIterator it = executable.listProperties(DASH.requiredExecutionPlatform);
        if (!it.hasNext()) {
            return true;
        }
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            if (!s.getObject().isResource() || !ExecutionPlatform.isCompatibleWith(s.getResource())) continue;
            it.close();
            return true;
        }
        return false;
    }

    public static boolean isCompatibleWith(Resource platform) {
        if (ExecutionPlatform.get().isCompatibleWithExactly(platform)) {
            return true;
        }
        for (Resource include : platform.getModel().listSubjectsWithProperty(DASH.includedExecutionPlatform, (RDFNode)platform).toList()) {
            if (!ExecutionPlatform.isCompatibleWith(include)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompatibleWithExactly(Resource platform) {
        return false;
    }
}

