import envVars from dw::System
import props from dw::Runtime

import failIf from dw::Runtime

var DEBUG = (envVars().BAT_DEBUG? and ((envVars().BAT_DEBUG default "") contains "true")) or (props().BAT_DEBUG? and ((props().BAT_DEBUG default "") contains "true"))
var SERVER_MODE = (envVars().SERVER_MODE? and ((envVars().SERVER_MODE default "") contains "true"))or (props().SERVER_MODE? and ((props().SERVER_MODE default "") contains "true"))
var NO_CONSOLE = (envVars().NO_CONSOLE? and ((envVars().NO_CONSOLE default "") contains "true")) or (props().NO_CONSOLE? and ((props().NO_CONSOLE default "") contains "true"))


fun debug<X>(message: String = 'DEBUG LOG:', x: X): X =
  if (DEBUG)
    log(message, x)
  else
    x


fun prepareMessage(msg: String, padding: String): String =
  using (nl = '\u000A')
    msg replace /(\n)/ with ('$nl$padding')

var ansiReset = '\u001b[0m'

fun green(txt: String): String =
  '\u001b[32m' ++ txt ++ '\u001b[0m'

fun red(txt: String): String =
  '\u001b[31m' ++ txt ++ '\u001b[0m'

fun yellow(txt: String): String =
  '\u001b[33m' ++ txt ++ '\u001b[0m'

fun white(txt: String): String =
  '\u001b[37m' ++ txt ++ '\u001b[0m'

fun cyan(txt: String): String =
  '\u001b[36;1m' ++ txt ++ '\u001b[0m'

fun faint(txt: String): String =
  '\u001b[2m' ++ txt ++ '\u001b[22m'

fun superWhite(txt: String): String =
  '\u001b[37;1m' ++ txt ++ '\u001b[0m'

fun superGreen(txt: String): String =
  '\u001b[92m' ++ txt ++ '\u001b[0m'

fun superRed(txt: String): String =
  '\u001b[91m' ++ txt ++ '\u001b[0m'

fun deletePreviousLine(): String =
  '\u001b[A\u001b[2K'

fun println(message: Null, pass: Boolean | Null | String = null): String =
  ''

fun println(message: String, pass: Boolean | Null | String = null): String = do {
    log("[BAT]", {message: message, pass: pass, dummy: ''}).dummy
}

fun printPassCapable<T>(item: T): T = do {
  var maybeTime = (item as Object).time match {
    case x is Number -> using (str = x as String {format: "#.##"})
      if (x < 100)
        '\u001b[22m' ++ green(' ($(str)ms)')
      else if (x > 250)
        '\u001b[22m' ++ red(' ($(str)ms)')
      else
        '\u001b[22m' ++ yellow(' ($(str)ms)')
    else -> ''
  }
  var maybePending = if ((item as Object).skip == true)
    ' (pending)'
  else
    ''
  var defaultMessage = (item as Object).message default (item as Object).name default '(Unnamed)' as String ++ maybeTime ++ maybePending

  var message = (item as Object).kind match {
    case "TEST" -> "\n" ++ defaultMessage
    case "StoreValue" -> "  $defaultMessage"
    case "RuntimeException" -> defaultMessage ++
    '\n' ++ if ((item as Object).result.location is String and (item as Object).result.location != 'Unknown location')
      (item as Object).result.location as String
    else
      'at ' ++ ((((item) as Object).result.stack default ['Unknown location']) joinBy '\n   ')
    else -> defaultMessage
  }
  var kind = if ((item as Object).skip == true)
    "SKIP"
  else
    (item as Object).kind match {
      case "StoreValue" -> "INFO"
      case "RuntimeException" -> "ERROR"
      case "TestException" -> "ERROR"
      case "TEST" -> null
      else -> (item as Object).pass as Boolean | Null | String
    }
  ---
  using (msg = println(message, kind))
    item
}



fun push(message: String = ''): String = do {
    log("[BAT]", {action: "PUSH", pass: "DEBUG",message: "<$(message)>", dummy: ''}).dummy
}

fun pop(message: String = ''): String =
    log("[BAT]", {action: "POP", pass: "DEBUG" ,message: "</$(message)>", dummy: ''}).dummy


