/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import org.apache.jena.JenaRuntime;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.sparql.ARQInternalErrorException;

public abstract class NodeFormatterBase
implements NodeFormatter {
    @Override
    public void format(AWriter w, Node n) {
        if (n.isBlank()) {
            this.formatBNode(w, n);
        } else if (n.isURI()) {
            this.formatURI(w, n);
        } else if (n.isLiteral()) {
            this.formatLiteral(w, n);
        } else if (n.isVariable()) {
            this.formatVar(w, n);
        } else if (Node.ANY.equals((Object)n)) {
            w.print("ANY");
        } else {
            throw new ARQInternalErrorException("Unknow node type: " + n);
        }
    }

    @Override
    public void formatURI(AWriter w, Node n) {
        this.formatURI(w, n.getURI());
    }

    @Override
    public void formatBNode(AWriter w, Node n) {
        this.formatBNode(w, n.getBlankNodeLabel());
    }

    @Override
    public void formatLiteral(AWriter w, Node n) {
        RDFDatatype dt = n.getLiteralDatatype();
        String lang = n.getLiteralLanguage();
        String lex = n.getLiteralLexicalForm();
        if (lang != null && !lang.equals("")) {
            this.formatLitLang(w, lex, lang);
        } else if (dt == null) {
            this.formatLitString(w, lex);
        } else if (JenaRuntime.isRDF11 && dt.equals(XSDDatatype.XSDstring)) {
            this.formatLitString(w, lex);
        } else {
            this.formatLitDT(w, lex, dt.getURI());
        }
    }

    @Override
    public void formatVar(AWriter w, Node n) {
        this.formatVar(w, n.getName());
    }
}

