/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang;

import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.lang.UpdateParser;
import org.apache.jena.sparql.lang.arq.ARQParser;
import org.apache.jena.sparql.lang.arq.ParseException;
import org.apache.jena.sparql.lang.arq.TokenMgrError;
import org.apache.jena.sparql.modify.UpdateSink;
import org.slf4j.LoggerFactory;

public class ParserARQUpdate
extends UpdateParser {
    @Override
    protected void parse$(UpdateSink sink, String queryString) {
        StringReader r = new StringReader(queryString);
        this._parse(sink, r);
    }

    @Override
    protected void parse$(UpdateSink sink, Reader r) {
        this._parse(sink, r);
    }

    public void parse(UpdateSink sink, Reader r) {
        if (r instanceof FileReader) {
            LoggerFactory.getLogger(this.getClass()).warn("FileReader passed to ParserSPARQLUpdate.parse - use a FileInputStream");
        }
        this._parse(sink, r);
    }

    private void _parse(UpdateSink sink, Reader r) {
        ARQParser parser = null;
        try {
            parser = new ARQParser(r);
            parser.setUpdateSink(sink);
            parser.UpdateUnit();
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginColumn);
        }
        catch (TokenMgrError tErr) {
            int col = parser.token.endColumn;
            int line = parser.token.endLine;
            throw new QueryParseException(tErr.getMessage(), line, col);
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), err, -1, -1);
        }
        catch (Throwable th) {
            Log.error((Object)this, (String)"Unexpected throwable: ", (Throwable)th);
            throw new QueryException(th.getMessage(), th);
        }
    }
}

