/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import spire.math.NumberTag;
import spire.math.ULong;
import spire.math.ULongAlgebra;
import spire.math.ULongBitString;
import spire.math.ULongInstances;
import spire.math.package$;

public final class ULong$
implements ULongInstances {
    public static ULong$ MODULE$;
    private final long MinValue;
    private final long MaxValue;
    private final double LimitAsDouble;
    private final BigInt LimitAsBigInt;
    private final ULongAlgebra ULongAlgebra;
    private final ULongBitString ULongBitString;
    private final NumberTag.UnsignedIntTag<ULong> ULongTag;

    static {
        new ULong$();
    }

    @Override
    public final ULongAlgebra ULongAlgebra() {
        return this.ULongAlgebra;
    }

    @Override
    public final ULongBitString ULongBitString() {
        return this.ULongBitString;
    }

    @Override
    public final NumberTag.UnsignedIntTag<ULong> ULongTag() {
        return this.ULongTag;
    }

    @Override
    public final void spire$math$ULongInstances$_setter_$ULongAlgebra_$eq(ULongAlgebra x$1) {
        this.ULongAlgebra = x$1;
    }

    @Override
    public final void spire$math$ULongInstances$_setter_$ULongBitString_$eq(ULongBitString x$1) {
        this.ULongBitString = x$1;
    }

    @Override
    public final void spire$math$ULongInstances$_setter_$ULongTag_$eq(NumberTag.UnsignedIntTag<ULong> x$1) {
        this.ULongTag = x$1;
    }

    public final long apply(long n) {
        return n;
    }

    public final long apply(String s) {
        return this.fromBigInt(scala.package$.MODULE$.BigInt().apply(s));
    }

    public final long fromInt(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public final long fromLong(long n) {
        return n;
    }

    public final long fromBigInt(BigInt n) {
        if (n.$less((Object)BigInt$.MODULE$.int2bigInt(0))) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " < 0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})));
        }
        return n.toLong();
    }

    public BigInt ulongToBigInt(long n) {
        return this.toBigInt$extension(n);
    }

    public final long MinValue() {
        return this.MinValue;
    }

    public final long MaxValue() {
        return this.MaxValue;
    }

    public final long pow(long t, long b, long e) {
        while (e != 0L) {
            if ((e & 1L) == 1L) {
                long l = t * b;
                e >>>= (int)1L;
                b *= b;
                t = l;
                continue;
            }
            e >>>= (int)1L;
            b *= b;
        }
        return t;
    }

    public final long gcd(long a, long b) {
        while (!this.$eq$eq$extension(b, 0L)) {
            long l = b;
            b = this.$percent$extension(a, b);
            a = l;
        }
        return a;
    }

    public final double LimitAsDouble() {
        return this.LimitAsDouble;
    }

    public final BigInt LimitAsBigInt() {
        return this.LimitAsBigInt;
    }

    public final byte toByte$extension(long $this) {
        return (byte)$this;
    }

    public final char toChar$extension(long $this) {
        return (char)$this;
    }

    public final short toShort$extension(long $this) {
        return (short)$this;
    }

    public final int toInt$extension(long $this) {
        return (int)$this;
    }

    public final long toLong$extension(long $this) {
        return $this;
    }

    public final float toFloat$extension(long $this) {
        return $this < 0L ? (float)(this.LimitAsDouble() + (double)$this) : (float)$this;
    }

    public final double toDouble$extension(long $this) {
        return this.toBigInt$extension($this).toDouble();
    }

    public final BigInt toBigInt$extension(long $this) {
        return $this < 0L ? this.LimitAsBigInt().$plus(BigInt$.MODULE$.long2bigInt($this)) : scala.package$.MODULE$.BigInt().apply($this);
    }

    public final String toString$extension(long $this) {
        return $this >= 0L ? ((Object)BoxesRunTime.boxToLong((long)$this)).toString() : this.LimitAsBigInt().$plus(BigInt$.MODULE$.long2bigInt($this)).toString();
    }

    public final boolean $eq$eq$extension(long $this, long that) {
        return $this == that;
    }

    public final boolean $bang$eq$extension(long $this, long that) {
        return $this != that;
    }

    public final boolean $eq$eq$eq$extension(long $this, long that) {
        return $this == that;
    }

    public final boolean $eq$bang$eq$extension(long $this, long that) {
        return $this != that;
    }

    public final boolean $less$eq$extension(long $this, long that) {
        return $this >= 0L ? $this <= that || that < 0L : that >= $this && that < 0L;
    }

    public final boolean $less$extension(long $this, long that) {
        return $this >= 0L ? $this < that || that < 0L : that > $this && that < 0L;
    }

    public final boolean $greater$eq$extension(long $this, long that) {
        return this.$less$eq$extension(that, $this);
    }

    public final boolean $greater$extension(long $this, long that) {
        return this.$less$extension(that, $this);
    }

    public final long unary_$minus$extension(long $this) {
        return this.apply(-$this);
    }

    public final long $plus$extension(long $this, long that) {
        return this.apply($this + that);
    }

    public final long $minus$extension(long $this, long that) {
        return this.apply($this - that);
    }

    public final long $times$extension(long $this, long that) {
        return this.apply($this * that);
    }

    public final long $div$extension(long $this, long that) {
        long half;
        long n = $this;
        long d = that;
        if (d == 0L) {
            throw new ArithmeticException("/ by zero");
        }
        return d < 0L ? this.apply(n >= 0L || n < d ? 0 : 1) : (n >= 0L ? this.apply(n / d) : ((half = n >>> 1) < d ? this.apply(1L) : this.apply((half / d << 1) + ((half % d << 1) + (n & 1L)) / d)));
    }

    public final long $percent$extension(long $this, long that) {
        return this.$minus$extension($this, this.$times$extension(this.$div$extension($this, that), that));
    }

    public final Tuple2<ULong, ULong> $div$percent$extension(long $this, long that) {
        long q = this.$div$extension($this, that);
        return new Tuple2((Object)new ULong(q), (Object)new ULong(this.$minus$extension($this, this.$times$extension(q, that))));
    }

    public final long unary_$tilde$extension(long $this) {
        return this.apply($this ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final long $less$less$extension(long $this, int shift) {
        return this.apply($this << shift);
    }

    public final long $greater$greater$extension(long $this, int shift) {
        return this.apply($this >>> shift);
    }

    public final long $greater$greater$greater$extension(long $this, int shift) {
        return this.apply($this >>> shift);
    }

    public final long $amp$extension(long $this, long that) {
        return this.apply($this & that);
    }

    public final long $bar$extension(long $this, long that) {
        return this.apply($this | that);
    }

    public final long $up$extension(long $this, long that) {
        return this.apply($this ^ that);
    }

    public final long $times$times$extension(long $this, long that) {
        return this.pow(1L, $this, that);
    }

    public final long gcd$extension(long $this, long that) {
        return this.gcd($this, that);
    }

    public final int hashCode$extension(long $this) {
        return ((Object)BoxesRunTime.boxToLong((long)$this)).hashCode();
    }

    public final boolean equals$extension(long $this, Object x$1) {
        long l;
        Object object = x$1;
        boolean bl = object instanceof ULong;
        return bl && $this == (l = ((ULong)x$1).signed());
    }

    private ULong$() {
        MODULE$ = this;
        ULongInstances.$init$(this);
        this.MinValue = this.apply(0L);
        this.MaxValue = this.apply(-1L);
        this.LimitAsDouble = package$.MODULE$.pow(2.0, 64.0);
        this.LimitAsBigInt = scala.package$.MODULE$.BigInt().apply(1).$less$less(64);
    }
}

