/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.util.Symbol;

public class SystemVar
implements Function {
    private Symbol systemSymbol;

    protected SystemVar(Symbol systemSymbol) {
        if (systemSymbol == null) {
            throw new ExprException("System symbol is null ptr");
        }
        this.systemSymbol = systemSymbol;
    }

    @Override
    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        Object obj = env.getContext().get(this.systemSymbol);
        if (obj == null) {
            throw new ExprEvalException("null for system symbol: " + this.systemSymbol);
        }
        if (!(obj instanceof Node)) {
            throw new ExprEvalException("Not a Node: " + Lib.className(obj));
        }
        Node n = (Node)obj;
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }

    @Override
    public void build(String uri, ExprList args) {
    }
}

