/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.engine;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.jenax.util.JenaDatatypes;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.engine.Shape;
import org.topbraid.shacl.model.SHConstraintComponent;
import org.topbraid.shacl.model.SHFactory;
import org.topbraid.shacl.model.SHShape;
import org.topbraid.shacl.vocabulary.SH;

public class ShapesGraph {
    private Predicate<Constraint> constraintFilter;
    private Map<Property, SHConstraintComponent> parametersMap = new HashMap<Property, SHConstraintComponent>();
    private List<Shape> rootShapes;
    private Predicate<SHShape> shapeFilter;
    private Map<Node, Shape> shapesMap = new HashMap<Node, Shape>();
    private Model shapesModel;

    public ShapesGraph(Model shapesModel) {
        this.shapesModel = shapesModel;
    }

    public SHConstraintComponent getComponentWithParameter(Property parameter) {
        if (!this.parametersMap.containsKey(parameter)) {
            StmtIterator it = this.shapesModel.listStatements(null, SH.path, (RDFNode)parameter);
            while (it.hasNext()) {
                Resource param = ((Statement)it.next()).getSubject();
                if (param.hasProperty(SH.optional, (RDFNode)JenaDatatypes.TRUE)) continue;
                StmtIterator i2 = this.shapesModel.listStatements(null, SH.parameter, (RDFNode)param);
                while (i2.hasNext()) {
                    Resource r = ((Statement)i2.next()).getSubject();
                    if (!JenaUtil.hasIndirectType(r, SH.ConstraintComponent)) continue;
                    i2.close();
                    it.close();
                    SHConstraintComponent cc = SHFactory.asConstraintComponent((RDFNode)r);
                    this.parametersMap.put(parameter, cc);
                    return cc;
                }
            }
            this.parametersMap.put(parameter, null);
            return null;
        }
        return this.parametersMap.get(parameter);
    }

    public List<Shape> getRootShapes() {
        if (this.rootShapes == null) {
            HashSet<Resource> candidates = new HashSet<Resource>();
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.target).toList());
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.targetClass).toList());
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.targetNode).toList());
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.targetObjectsOf).toList());
            candidates.addAll(this.shapesModel.listSubjectsWithProperty(SH.targetSubjectsOf).toList());
            for (Resource shape : JenaUtil.getAllInstances(this.shapesModel.getResource(SH.NodeShape.getURI()))) {
                if (!JenaUtil.hasIndirectType(shape, RDFS.Class)) continue;
                candidates.add(shape);
            }
            for (Resource shape : JenaUtil.getAllInstances(this.shapesModel.getResource(SH.PropertyShape.getURI()))) {
                if (!JenaUtil.hasIndirectType(shape, RDFS.Class)) continue;
                candidates.add(shape);
            }
            this.rootShapes = new LinkedList<Shape>();
            for (Resource candidate : candidates) {
                SHShape shape = SHFactory.asShape((RDFNode)candidate);
                if (this.shapeFilter != null && !this.shapeFilter.test(shape)) continue;
                this.rootShapes.add(this.getShape(shape.asNode()));
            }
        }
        return this.rootShapes;
    }

    public Shape getShape(Node node) {
        Shape shape = this.shapesMap.get(node);
        if (shape == null) {
            shape = new Shape(this, SHFactory.asShape(this.shapesModel.asRDFNode(node)));
            this.shapesMap.put(node, shape);
        }
        return shape;
    }

    public boolean isIgnoredConstraint(Constraint constraint) {
        return this.constraintFilter != null && !this.constraintFilter.test(constraint);
    }

    public boolean isIgnored(Node shapeNode) {
        if (this.shapeFilter == null) {
            return false;
        }
        SHShape shape = SHFactory.asShape(this.shapesModel.asRDFNode(shapeNode));
        return !this.shapeFilter.test(shape);
    }

    public void setConstraintFilter(Predicate<Constraint> value) {
        this.constraintFilter = value;
    }

    public void setShapeFilter(Predicate<SHShape> value) {
        this.shapeFilter = value;
    }
}

