/**
* This module contains what is required for registering a new data format for
* the DataWeave language.
*
* For an example, see
https://github.com/mulesoft-labs/data-weave-custom-data-format[Custom Data Formats Example].
*
*/
%dw 2.0

/**
* Registration hook used by the DataWeave engine to discover the variable that represents the custom data format. For an example, see the https://github.com/mulesoft-labs/data-weave-custom-data-format/blob/master/README.md[Custom Data Formats Example README].
*/
@AnnotationTarget(targets = ["Variable"])
annotation DataFormatExtension()

/**
 * Represents a MimeType, such as `application/json`.
 */
@Since(version = "2.2.0")
type MimeType = String

/**
 * Represents reader or writer configuration Settings.
 */
@Since(version = "2.2.0")
type Settings = {}

/**
 * Represents a configuration with no Settings.
 */
@Since(version = "2.2.0")
type EmptySettings = {}

/**
 * Represents an Encoding Settings.
 */
@Since(version = "2.2.0")
type EncodingSettings = {
    /**
    * Encoding to be used by this writer.
    */
    encoding?: String
}

/**
 * Represents the DataFormat definition.
 */
@Since(version = "2.2.0")
type DataFormat<ReaderSettings <: Settings, WriterSettings <: Settings> = {
    /**
    * True if this is data format is represented in a binary representation instead of text, if not present is false
    */
    binaryFormat?: Boolean,
    /**
    * The default charset of this format, if any.
    */
    defaultCharset?: String,

    /**
    * Returns the list of file extensions with the . (".json", ".xml", etc...) that should be assigned to this Data Format
    */
    fileExtensions?: Array<String>,

    /**
    * The list of MimeTypes that are accepted
    */
    acceptedMimeTypes: Array<MimeType>,

    /**
    * This function will be in charge of reading the raw content and transform it into the DW canonical model
    */
    reader: (content: Binary, charset: String, settings: ReaderSettings) -> Any,

    /**
    * This function will be in charge of writing the DW canonical model into Binary content
    */
    writer: (value:Any, settings:WriterSettings) -> Binary
}
