%dw 2.0

type HashMapSetOperation<T> = {|
  operation: String,
  prevValue: T | Null,
  newValue: T,
  key: String
|}

type IHashMap = {
  get: (key: String) -> Nothing,
  set: (key: String, value: Any) -> HashMapSetOperation<Any>,
  instance: Any,
  getAll: () -> { _?: Nothing }
}

fun HashMap(): IHashMap = native("bat::HashMap")

type IListBuffer<T> = {
  peek: () -> T,
  pop: () -> T,
  push: (item: T) -> T,
  removeAt: (at: Number) -> T,
  getAt: (at: Number) -> T,
  setAt: (at: Number, item: T) -> T,
  instance: Any,
  items: () -> Array<T>,
  length: () -> Number
}

fun ListBuffer(): IListBuffer<Any> = native("bat::ListBuffer")